/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client.impl.proxy;

import com.day.packageshare.client.impl.proxy.AttributeList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeListImpl
implements AttributeList {
    private final Map<String, Value> attributes = new LinkedHashMap<String, Value>();
    private final Set<String> attributeNames = new LinkedHashSet<String>();
    private boolean modified;

    AttributeListImpl() {
    }

    public void addAttribute(String name, String value, char quoteChar) {
        this.attributes.put(name.toUpperCase(), new Value(quoteChar, value));
        this.attributeNames.add(name);
    }

    public void addAttribute(String name, char quoteChar) {
        this.attributes.put(name.toUpperCase(), null);
        this.attributeNames.add(name);
    }

    public void reset() {
        this.attributes.clear();
        this.attributeNames.clear();
        this.modified = false;
    }

    @Override
    public int attributeCount() {
        return this.attributes.size();
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames.iterator();
    }

    @Override
    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name.toUpperCase());
    }

    @Override
    public String getValue(String name) {
        Value value = this.getValueEx(name);
        if (value != null) {
            return value.value;
        }
        return null;
    }

    @Override
    public char getQuoteChar(String name) {
        Value value = this.getValueEx(name);
        if (value != null) {
            return value.quoteChar;
        }
        return '\u0000';
    }

    @Override
    public String getQuotedValue(String name) {
        Value value = this.getValueEx(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public void setValue(String name, String value) {
        if (value == null) {
            this.removeValue(name);
        } else {
            Value old = this.getValueEx(name);
            if (old == null) {
                this.addAttribute(name, value, '\"');
                this.modified = true;
            } else if (!old.value.equals(value)) {
                this.addAttribute(name, value, old.quoteChar);
                this.modified = true;
            }
        }
    }

    @Override
    public void removeValue(String name) {
        this.attributeNames.remove(name);
        this.attributes.remove(name.toUpperCase());
        this.modified = true;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    protected Value getValueEx(String name) {
        return this.attributes.get(name.toUpperCase());
    }

    static class Value {
        public final char quoteChar;
        public final String value;
        private String stringRep;

        public Value(char quoteChar, String value) {
            this.quoteChar = quoteChar;
            this.value = value;
        }

        public String toString() {
            if (this.stringRep == null) {
                this.stringRep = this.quoteChar + this.value + this.quoteChar;
            }
            return this.stringRep;
        }
    }
}

