/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client.impl.proxy;

import com.day.packageshare.client.impl.proxy.DocumentHandler;
import com.day.packageshare.client.impl.proxy.DocumentHandlerToSAXAdapter;
import com.day.packageshare.client.impl.proxy.TagTokenizer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlParser
extends Writer {
    public static final String INCLUDE_TAGS_PROPERTY = "includeTags";
    private final CharArrayWriter buffer = new CharArrayWriter(256);
    private final TagTokenizer tokenizer = new TagTokenizer();
    private final CharArrayWriter tagNameBuffer = new CharArrayWriter(30);
    private String tagName;
    private Set<String> tagInclusionSet = DEFAULT_INCLUSION_TAGS;
    private DocumentHandler documentHandler;
    private static final int PS_OUTSIDE = 0;
    private static final int PS_TAG = 1;
    private static final int PS_SCRIPT = 2;
    private static final int PS_COMMENT = 3;
    private static final int PS_STRING = 4;
    private static final int TT_NONE = 0;
    private static final int TT_MAYBE = 1;
    private static final int TT_TAG = 2;
    private int parseState;
    private int parseSubState;
    private int prevParseState;
    private int tagType;
    private char quoteChar;
    boolean started = false;
    private static final Set<String> DEFAULT_INCLUSION_TAGS = new HashSet<String>();

    public PrintWriter getWriter() {
        return new PrintWriter(this);
    }

    public Set<String> getTagInclusionSet() {
        return this.tagInclusionSet;
    }

    public void setTagInclusionSet(Set<String> tagInclusionSet) {
        this.tagInclusionSet = tagInclusionSet;
    }

    public void setContentHandler(ContentHandler handler) {
        this.documentHandler = new DocumentHandlerToSAXAdapter(handler);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.update(cbuf, 0, len);
    }

    @Override
    public void write(int b) throws IOException {
        char[] buf = new char[]{(char)b};
        this.update(buf, 0, buf.length);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.documentHandler.characters(new char[0], 0, 0);
    }

    public void update(char[] buf, int off, int len) throws IOException {
        if (!this.started) {
            this.documentHandler.onStart();
            this.started = true;
        }
        int start = off;
        int end = off + len;
        block31: for (int curr = start; curr < end; ++curr) {
            char c = buf[curr];
            switch (this.parseState) {
                case 0: {
                    if (c != '<') continue block31;
                    if (curr > start) {
                        this.documentHandler.characters(buf, start, curr - start);
                    }
                    start = curr;
                    this.parseState = 1;
                    this.parseSubState = 0;
                    this.tagType = 1;
                    this.resetTagName();
                    continue block31;
                }
                case 1: {
                    switch (this.parseSubState) {
                        case -1: {
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = 4;
                                this.parseSubState = -1;
                                break;
                            }
                            if (c != '>') break;
                            this.parseState = 0;
                            break;
                        }
                        case 0: {
                            if (c == '!') {
                                this.parseState = 3;
                                this.parseSubState = 0;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = 4;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = 0;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (!Character.isWhitespace(c)) {
                                this.tagNameBuffer.write(c);
                                this.parseSubState = 1;
                                break;
                            }
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 1: {
                            if (c == '\"' || c == '\'') {
                                if (this.tagIncluded(this.getTagName())) {
                                    this.tagType = 2;
                                } else {
                                    this.tagType = 0;
                                    this.flushBuffer();
                                }
                                this.parseSubState = 2;
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = 4;
                                break;
                            }
                            if (c == '>') {
                                if (this.tagIncluded(this.getTagName())) {
                                    this.processTag(buf, start, curr - start + 1);
                                    start = curr + 1;
                                    this.tagType = 0;
                                    this.parseState = this.getTagName().equalsIgnoreCase("SCRIPT") ? 2 : 0;
                                    this.parseSubState = 0;
                                    break;
                                }
                                this.tagType = 0;
                                this.flushBuffer();
                                this.parseState = 0;
                                break;
                            }
                            if (Character.isWhitespace(c)) {
                                if (this.tagIncluded(this.getTagName())) {
                                    this.tagType = 2;
                                } else {
                                    this.tagType = 0;
                                    this.flushBuffer();
                                }
                                this.parseSubState = 2;
                                break;
                            }
                            this.tagNameBuffer.write(c);
                            break;
                        }
                        case 2: {
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = this.parseState;
                                this.parseState = 4;
                                break;
                            }
                            if (c != '>') break;
                            if (this.tagType == 2) {
                                this.processTag(buf, start, curr - start + 1);
                                start = curr + 1;
                            } else {
                                this.flushBuffer();
                            }
                            this.tagType = 0;
                            this.parseState = this.getTagName().equalsIgnoreCase("SCRIPT") ? 2 : 0;
                            this.parseSubState = 0;
                        }
                    }
                    continue block31;
                }
                case 3: {
                    switch (this.parseSubState) {
                        case 0: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = 1;
                                this.parseState = 4;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = 0;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            this.parseState = 1;
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 1: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            if (c == '\"' || c == '\'') {
                                this.quoteChar = c;
                                this.prevParseState = 1;
                                this.parseState = 4;
                                this.parseSubState = -1;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            if (c == '>') {
                                this.parseState = 0;
                                this.tagType = 0;
                                this.flushBuffer();
                                break;
                            }
                            this.parseState = 1;
                            this.parseSubState = -1;
                            this.tagType = 0;
                            this.flushBuffer();
                            break;
                        }
                        case 2: {
                            if (c != '-') break;
                            ++this.parseSubState;
                            break;
                        }
                        case 3: {
                            if (c == '-') {
                                ++this.parseSubState;
                                break;
                            }
                            this.parseSubState = 2;
                            break;
                        }
                        case 4: {
                            if (c == '>') {
                                this.parseState = 0;
                                break;
                            }
                            this.parseSubState = 2;
                        }
                    }
                    continue block31;
                }
                case 2: {
                    switch (this.parseSubState) {
                        case 0: {
                            if (c != '<') break;
                            if (curr > start) {
                                this.documentHandler.characters(buf, start, curr - start);
                            }
                            start = curr;
                            this.tagType = 1;
                            ++this.parseSubState;
                            break;
                        }
                        case 1: {
                            if (c == '/') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 2: {
                            if (c == 'S' || c == 's') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 3: {
                            if (c == 'C' || c == 'c') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 4: {
                            if (c == 'R' || c == 'r') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 5: {
                            if (c == 'I' || c == 'i') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 6: {
                            if (c == 'P' || c == 'p') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 7: {
                            if (c == 'T' || c == 't') {
                                ++this.parseSubState;
                                break;
                            }
                            this.tagType = 0;
                            this.flushBuffer();
                            this.parseSubState = 0;
                            break;
                        }
                        case 8: {
                            if (c != '>') break;
                            if (this.tagIncluded("SCRIPT")) {
                                this.processTag(buf, start, curr - start + 1);
                                start = curr + 1;
                            } else {
                                this.flushBuffer();
                            }
                            this.tagType = 0;
                            this.parseState = 0;
                        }
                    }
                    continue block31;
                }
                case 4: {
                    if (c != this.quoteChar) continue block31;
                    this.parseState = this.prevParseState;
                }
            }
        }
        if (start < end) {
            if (this.tagType == 0) {
                this.documentHandler.characters(buf, start, end - start);
            } else {
                this.buffer.write(buf, start, end - start);
            }
        }
    }

    public boolean isEmpty() {
        return this.buffer.size() == 0;
    }

    public void finished() throws IOException {
        this.flushBuffer();
        this.documentHandler.onEnd();
    }

    protected void resetTagName() {
        this.tagName = null;
        this.tagNameBuffer.reset();
    }

    protected String getTagName() {
        if (this.tagName == null) {
            this.tagName = this.tagNameBuffer.toString();
        }
        return this.tagName;
    }

    protected void flushBuffer() throws IOException {
        if (this.buffer.size() > 0) {
            char[] ch = this.buffer.toCharArray();
            this.documentHandler.characters(ch, 0, ch.length);
            this.buffer.reset();
        }
    }

    protected boolean tagIncluded(String tagName) {
        return this.tagInclusionSet == null || this.tagInclusionSet.contains(tagName.toUpperCase());
    }

    protected void processTag(char[] ch, int off, int len) throws IOException {
        this.buffer.write(ch, off, len);
        char[] snippet = this.buffer.toCharArray();
        this.tokenizer.tokenize(snippet, 0, snippet.length);
        if (!this.tokenizer.endTag()) {
            this.documentHandler.onStartElement(this.tokenizer.tagName(), this.tokenizer.attributes(), snippet, 0, snippet.length, this.tokenizer.endSlash());
        } else {
            this.documentHandler.onEndElement(this.tokenizer.tagName(), snippet, 0, snippet.length);
        }
        this.buffer.reset();
    }

    static {
        DEFAULT_INCLUSION_TAGS.add("A");
        DEFAULT_INCLUSION_TAGS.add("/A");
        DEFAULT_INCLUSION_TAGS.add("IMG");
        DEFAULT_INCLUSION_TAGS.add("AREA");
        DEFAULT_INCLUSION_TAGS.add("FORM");
        DEFAULT_INCLUSION_TAGS.add("BASE");
        DEFAULT_INCLUSION_TAGS.add("LINK");
        DEFAULT_INCLUSION_TAGS.add("SCRIPT");
        DEFAULT_INCLUSION_TAGS.add("/BODY");
    }
}

