/*
 * Decompiled with CFR 0.152.
 */
package com.day.packageshare.client.impl.proxy;

import com.day.packageshare.client.Proxy;
import com.day.packageshare.client.ProxyTracker;
import com.day.packageshare.client.TrackingInputStream;
import com.day.packageshare.client.impl.proxy.AttributeList;
import com.day.packageshare.client.impl.proxy.DocumentHandler;
import com.day.packageshare.client.impl.proxy.HtmlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyImpl
implements DocumentHandler,
Proxy {
    private static final Logger log = LoggerFactory.getLogger(ProxyImpl.class);
    private String rewritePath;
    private String spoolPath;
    private URI targetURL;
    private Writer writer;
    private boolean ignoreTypeAttribute;
    private List<NameValuePair> extraParams = new LinkedList<NameValuePair>();
    private List<FilePart> extraFiles = new LinkedList<FilePart>();
    private List<Header> extraHeaders = new LinkedList<Header>();
    private int soTimeout = 60000;
    private final HttpClient httpClient;
    private HttpState httpState;
    private HttpMethodBase httpMethod;
    private String contentType;
    private String lastModified;
    private Credentials credentials;
    private ProxyTracker tracker;
    private String contextPath = "";
    private String idString = null;
    private boolean followRedirects = false;

    public ProxyImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getRewritePath() {
        return this.rewritePath;
    }

    public void setRewritePath(String rewritePath) {
        this.rewritePath = rewritePath;
    }

    public String getSpoolPath() {
        return this.spoolPath;
    }

    public void setSpoolPath(String spoolPath) {
        this.spoolPath = spoolPath;
    }

    public ProxyTracker getTracker() {
        return this.tracker;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setTracker(ProxyTracker tracker) {
        this.tracker = tracker;
    }

    public void setIdString(String id) {
        this.idString = id;
    }

    public void setContextPath(String path) {
        if (path.length() > 0 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.contextPath = path;
    }

    public void addExtraParameter(String name, String value) {
        this.extraParams.add(new NameValuePair(name, value));
    }

    public void addExtraHeader(String name, String value) {
        this.extraHeaders.add(new Header(name, value));
    }

    public void addExtraFile(String name, File file) throws FileNotFoundException {
        this.extraFiles.add(new FilePart(name, (PartSource)new MyFilePartSource(file)));
    }

    public void addExtraFile(String name, File file, String fileName) throws FileNotFoundException {
        this.extraFiles.add(new FilePart(name, (PartSource)new MyFilePartSource(file, fileName)));
    }

    public boolean isIgnoreTypeAttribute() {
        return this.ignoreTypeAttribute;
    }

    public void setIgnoreTypeAttribute(boolean ignoreTypeAttribute) {
        this.ignoreTypeAttribute = ignoreTypeAttribute;
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void onStart() throws IOException {
    }

    public void onStartElement(String name, AttributeList attList, char[] ch, int off, int len, boolean endSlash) throws IOException {
        String suffix = null;
        String upperName = name.toUpperCase();
        if (upperName.equals("A")) {
            boolean spool = !this.ignoreTypeAttribute && attList.containsAttribute("type");
            this.rewriteRef(attList, "HREF", spool);
        } else if (upperName.equals("AREA")) {
            this.rewriteRef(attList, "HREF", false);
        } else if (upperName.equals("FORM")) {
            suffix = this.rewriteForm(attList);
        } else if (upperName.equals("FRAME")) {
            this.rewriteRef(attList, "SRC", true);
        } else if (upperName.equals("IFRAME")) {
            this.rewriteRef(attList, "SRC", true);
        } else if (upperName.equals("IMG")) {
            this.rewriteRef(attList, "SRC", true);
        } else if (upperName.equals("INPUT")) {
            this.rewriteRef(attList, "SRC", true);
        } else if (upperName.equals("LINK")) {
            this.rewriteRef(attList, "HREF", true);
        } else if (upperName.equals("SCRIPT")) {
            this.rewriteRef(attList, "SRC", true);
        } else if (upperName.equals("TABLE")) {
            this.rewriteRef(attList, "BACKGROUND", true);
        } else if (upperName.equals("TD")) {
            this.rewriteRef(attList, "BACKGROUND", true);
        } else if (upperName.equals("TR")) {
            this.rewriteRef(attList, "BACKGROUND", true);
        }
        if (attList.isModified()) {
            this.writer.write(this.serialize(name, attList, endSlash));
        } else {
            this.writer.write(ch, off, len);
        }
        if (suffix != null) {
            this.writer.write(suffix);
        }
    }

    private String serialize(String name, AttributeList attList, boolean endSlash) {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("<");
        buffer.append(name);
        Iterator<String> attNames = attList.attributeNames();
        while (attNames.hasNext()) {
            String attName = attNames.next();
            String attValue = attList.getQuotedValue(attName);
            buffer.append(" ");
            buffer.append(attName);
            if (attValue == null) continue;
            buffer.append('=');
            buffer.append(attValue);
        }
        if (endSlash) {
            buffer.append(" /");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public void characters(char[] ch, int off, int len) throws IOException {
        this.writer.write(ch, off, len);
    }

    public void characters(String c) throws IOException {
        this.writer.write(c);
    }

    public void onEndElement(String name, char[] ch, int off, int len) {
        try {
            this.writer.write(ch, off, len);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onEnd() throws IOException {
        this.writer.flush();
    }

    private String rewriteForm(AttributeList attList) {
        String action = attList.getValue("ACTION");
        if (action != null && action.length() > 0) {
            String method = attList.getValue("METHOD");
            action = this.rewriteURL(action, "POST".equalsIgnoreCase(method));
            attList.setValue("ACTION", action);
        }
        return null;
    }

    private void rewriteRef(AttributeList attList, String attName, boolean spool) {
        String ref = attList.getValue(attName);
        if (ref != null) {
            attList.setValue(attName, this.rewriteURL(ref, spool));
        }
    }

    public String rewriteURL(String url, boolean spool) {
        if (url.startsWith("#")) {
            return url;
        }
        int firstSlash = url.indexOf(47);
        int firstColon = url.indexOf(58);
        if (firstColon >= 0 && (firstSlash < 0 || firstColon < firstSlash)) {
            return url;
        }
        if (firstSlash != 0) {
            try {
                url = new java.net.URI(this.targetURL.getEscapedPath()).resolve(url).getPath();
            }
            catch (URISyntaxException e) {
                log.warn("Error during creating relative link: {}", (Object)e.toString());
            }
        }
        StringBuffer newValue = new StringBuffer(this.contextPath);
        if (spool) {
            newValue.append(this.spoolPath);
        } else {
            newValue.append(this.rewritePath);
        }
        newValue.append(url);
        return newValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteHtml(InputStream in) throws IOException {
        String encoding = "8859_1";
        int charsetIndex = this.contentType.indexOf("charset=");
        if (charsetIndex != -1) {
            encoding = this.contentType.substring(charsetIndex + "charset=".length()).trim();
        }
        HashSet<String> inclusionSet = new HashSet<String>();
        inclusionSet.add("A");
        inclusionSet.add("AREA");
        inclusionSet.add("FORM");
        inclusionSet.add("FRAME");
        inclusionSet.add("IFRAME");
        inclusionSet.add("IMG");
        inclusionSet.add("INPUT");
        inclusionSet.add("LINK");
        inclusionSet.add("SCRIPT");
        inclusionSet.add("TABLE");
        inclusionSet.add("TD");
        inclusionSet.add("TR");
        inclusionSet.add("NOREWRITE");
        HtmlParser parser = new HtmlParser();
        parser.setTagInclusionSet(inclusionSet);
        parser.setDocumentHandler(this);
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(in, encoding));
            char[] buf = new char[2048];
            while ((len = reader.read(buf)) != -1) {
                parser.update(buf, 0, len);
            }
            parser.finished();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spoolCss(Writer out) throws IOException {
        String encoding = "8859_1";
        int charsetIndex = this.contentType.indexOf("charset=");
        if (charsetIndex != -1) {
            encoding = this.contentType.substring(charsetIndex + "charset=".length()).trim();
        }
        long start = System.currentTimeMillis();
        String css = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.httpMethod.getResponseBodyAsStream(), encoding));
            css = IOUtils.toString((Reader)reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        long end = System.currentTimeMillis();
        log.debug("read css in {}ms {} bytes", (Object)(end - start), (Object)css.length());
        char[] data = css.toCharArray();
        Pattern p = Pattern.compile("url\\((.*)\\)");
        Matcher m = p.matcher(css);
        int last = 0;
        while (m.find()) {
            out.write(data, last, m.start() - last);
            out.write("url(");
            out.write(this.rewriteURL(m.group(1), true));
            out.write(")");
            last = m.end();
        }
        out.write(data, last, data.length - last);
        out.flush();
    }

    public int doGet(String path) throws IOException {
        Header h2;
        if (this.httpMethod != null) {
            throw new IllegalStateException("already connected");
        }
        try {
            this.targetURL = new URI(path, false, "utf-8");
        }
        catch (URIException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        LinkedList<NameValuePair> ps = new LinkedList<NameValuePair>(this.extraParams);
        if (this.idString != null) {
            ps.add(new NameValuePair("daypsid", this.idString));
        }
        if (this.credentials != null && path.indexOf("sling:authRequestLogin") < 0) {
            ps.add(new NameValuePair("sling:authRequestLogin", "1"));
        }
        this.httpMethod = new GetMethod();
        this.httpMethod.setURI(this.targetURL);
        if (!ps.isEmpty()) {
            this.httpMethod.setQueryString(ps.toArray(new NameValuePair[ps.size()]));
        }
        for (Header h2 : this.extraHeaders) {
            this.httpMethod.addRequestHeader(h2);
        }
        this.httpMethod.addRequestHeader("User-Agent", "Day cq-packageshare-client");
        this.httpMethod.setFollowRedirects(this.followRedirects);
        this.httpMethod.getParams().setSoTimeout(this.soTimeout);
        this.httpState = new HttpState();
        if (this.credentials != null) {
            this.httpState.setAuthenticationPreemptive(true);
            this.httpState.setCredentials(AuthScope.ANY, this.credentials);
        }
        this.httpClient.executeMethod(null, (HttpMethod)this.httpMethod, this.httpState);
        Header hdr = this.httpMethod.getResponseHeader("Content-Type");
        this.contentType = hdr == null ? "text/plain" : hdr.getValue();
        h2 = this.httpMethod.getResponseHeader("Last-Modified");
        this.lastModified = h2 == null ? null : h2.getValue();
        return this.httpMethod.getStatusCode();
    }

    public int doPost(String path) throws IOException {
        if (this.httpMethod != null) {
            throw new IllegalStateException("already connected");
        }
        try {
            this.targetURL = new URI(path, false, "utf-8");
        }
        catch (URIException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        LinkedList<NameValuePair> ps = new LinkedList<NameValuePair>(this.extraParams);
        if (this.idString != null) {
            ps.add(new NameValuePair("daypsid", this.idString));
        }
        if (this.credentials != null && path.indexOf("sling:authRequestLogin") < 0) {
            ps.add(new NameValuePair("sling:authRequestLogin", "1"));
        }
        PostMethod m = new PostMethod();
        m.setURI(this.targetURL);
        this.httpMethod = m;
        if (this.extraFiles.isEmpty()) {
            m.addParameters(ps.toArray(new NameValuePair[ps.size()]));
        } else {
            LinkedList<FilePart> parts = new LinkedList<FilePart>(this.extraFiles);
            for (NameValuePair nvp : ps) {
                parts.add((FilePart)new StringPart(nvp.getName(), nvp.getValue()));
            }
            m.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), m.getParams()));
        }
        for (Header h : this.extraHeaders) {
            this.httpMethod.addRequestHeader(h);
        }
        this.httpMethod.addRequestHeader("User-Agent", "Day cq-packageshare-client");
        this.httpMethod.getParams().setSoTimeout(this.soTimeout);
        this.httpState = new HttpState();
        if (this.credentials != null) {
            this.httpState.setAuthenticationPreemptive(true);
            this.httpState.setCredentials(AuthScope.ANY, this.credentials);
        }
        this.httpClient.executeMethod(null, (HttpMethod)this.httpMethod, this.httpState);
        Header hdr = this.httpMethod.getResponseHeader("Content-Type");
        this.contentType = hdr == null ? "text/plain" : hdr.getValue();
        return this.httpMethod.getStatusCode();
    }

    public void close() {
        if (this.httpMethod != null) {
            this.httpMethod.releaseConnection();
            this.httpMethod = null;
        }
        if (this.httpState != null) {
            this.httpState.clear();
            this.httpState = null;
        }
    }

    public boolean isHtml() {
        return this.contentType != null && this.contentType.startsWith("text/html");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public long getContentLength() {
        return this.httpMethod.getResponseContentLength();
    }

    public String getLocation(boolean rewrite, boolean spool) {
        String location = this.getResponseHeaderValue("Location");
        if (location == null) {
            log.error("No location header in response.");
            return null;
        }
        if (rewrite) {
            if (!location.startsWith("/")) {
                log.error("Location must not be absolute url.");
                return null;
            }
            location = this.rewriteURL(location, spool);
        }
        return location;
    }

    public Header getResponseHeader(String name) {
        return this.httpMethod.getResponseHeader(name);
    }

    public String getResponseHeaderValue(String name) {
        Header header = this.httpMethod.getResponseHeader(name);
        return header == null ? null : header.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewrite(Writer writer) throws IOException {
        if (this.writer == null) {
            this.writer = writer;
        }
        InputStream in = this.httpMethod.getResponseBodyAsStream();
        try {
            if (in != null) {
                this.rewriteHtml(in);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int spool(OutputStream out) throws IOException {
        InputStream in = this.httpMethod.getResponseBodyAsStream();
        try {
            if (in != null) {
                int n;
                long len = this.httpMethod.getResponseContentLength();
                byte[] buffer = new byte[8192];
                long count = 0L;
                while (-1 != (n = in.read(buffer))) {
                    out.write(buffer, 0, n);
                    count += (long)n;
                    if (this.tracker == null) continue;
                    this.tracker.onProgress(count, len);
                }
                int n2 = (int)count;
                return n2;
            }
            int n = -1;
            return n;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetch() throws IOException {
        try {
            StringWriter ret = new StringWriter();
            IOUtils.copy((InputStream)this.httpMethod.getResponseBodyAsStream(), (Writer)ret, (String)this.httpMethod.getResponseCharSet());
            String string = ret.toString();
            return string;
        }
        finally {
            this.close();
        }
    }

    public class MyFilePartSource
    extends FilePartSource {
        public MyFilePartSource(File file) throws FileNotFoundException {
            super(file);
        }

        public MyFilePartSource(File file, String fileName) throws FileNotFoundException {
            super(fileName, file);
        }

        public InputStream createInputStream() throws IOException {
            InputStream in = super.createInputStream();
            if (ProxyImpl.this.tracker != null) {
                return new TrackingInputStream(in, this.getLength(), ProxyImpl.this.tracker);
            }
            return in;
        }
    }
}

