/*
 * Decompiled with CFR 0.152.
 */
package com.dayanruben.datastore.encrypted.migration;

import com.dayanruben.datastore.encrypted.AeadKt;
import com.dayanruben.datastore.encrypted.migration.StreamingAeadWithFallbackKt;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.StreamingAead;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J6\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u000e\u0010\t\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0010\u001a\n \u000e*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\u00110\u00112\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0013J6\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\u00150\u00152\u000e\u0010\u0012\u001a\n \u000e*\u0004\u0018\u00010\u00150\u00152\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\n \u000e*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\t\u001a\n \u000e*\u0004\u0018\u00010\u00180\u00182\u000e\u0010\n\u001a\n \u000e*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/dayanruben/datastore/encrypted/migration/StreamingAeadWithFallback;", "Lcom/google/crypto/tink/StreamingAead;", "delegate", "fallback", "Lcom/google/crypto/tink/Aead;", "<init>", "(Lcom/google/crypto/tink/StreamingAead;Lcom/google/crypto/tink/Aead;)V", "newDecryptingStream", "Ljava/io/InputStream;", "ciphertextSource", "associatedData", "", "newDecryptingChannel", "Ljava/nio/channels/ReadableByteChannel;", "kotlin.jvm.PlatformType", "(Ljava/nio/channels/ReadableByteChannel;[B)Ljava/nio/channels/ReadableByteChannel;", "newEncryptingChannel", "Ljava/nio/channels/WritableByteChannel;", "ciphertextDestination", "(Ljava/nio/channels/WritableByteChannel;[B)Ljava/nio/channels/WritableByteChannel;", "newEncryptingStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;[B)Ljava/io/OutputStream;", "newSeekableDecryptingChannel", "Ljava/nio/channels/SeekableByteChannel;", "(Ljava/nio/channels/SeekableByteChannel;[B)Ljava/nio/channels/SeekableByteChannel;", "DecryptingStreamWithFallback", "encrypted-datastore_release"})
public final class StreamingAeadWithFallback
implements StreamingAead {
    @NotNull
    private final StreamingAead delegate;
    @NotNull
    private final Aead fallback;

    public StreamingAeadWithFallback(@NotNull StreamingAead delegate, @NotNull Aead fallback) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        this.delegate = delegate;
        this.fallback = fallback;
    }

    @NotNull
    public InputStream newDecryptingStream(@NotNull InputStream ciphertextSource, @NotNull byte[] associatedData) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)ciphertextSource, (String)"ciphertextSource");
        Intrinsics.checkNotNullParameter((Object)associatedData, (String)"associatedData");
        if (ciphertextSource.markSupported()) {
            inputStream = ciphertextSource;
        } else {
            InputStream inputStream2 = ciphertextSource;
            int n = 8192;
            inputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        }
        InputStream inputStream3 = inputStream;
        InputStream inputStream4 = this.delegate.newDecryptingStream(inputStream3, associatedData);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream4, (String)"newDecryptingStream(...)");
        return new DecryptingStreamWithFallback(inputStream4, (Function0<? extends InputStream>)((Function0)() -> StreamingAeadWithFallback.newDecryptingStream$lambda$0(this, inputStream3)));
    }

    public WritableByteChannel newEncryptingChannel(WritableByteChannel ciphertextDestination, byte[] associatedData) {
        return this.delegate.newEncryptingChannel(ciphertextDestination, associatedData);
    }

    public SeekableByteChannel newSeekableDecryptingChannel(SeekableByteChannel ciphertextSource, byte[] associatedData) {
        return this.delegate.newSeekableDecryptingChannel(ciphertextSource, associatedData);
    }

    public ReadableByteChannel newDecryptingChannel(ReadableByteChannel ciphertextSource, byte[] associatedData) {
        return this.delegate.newDecryptingChannel(ciphertextSource, associatedData);
    }

    public OutputStream newEncryptingStream(OutputStream ciphertextDestination, byte[] associatedData) {
        return this.delegate.newEncryptingStream(ciphertextDestination, associatedData);
    }

    private static final InputStream newDecryptingStream$lambda$0(StreamingAeadWithFallback this$0, InputStream $inputStream) {
        return AeadKt.newDecryptedStream(this$0.fallback, $inputStream);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dayanruben/datastore/encrypted/migration/StreamingAeadWithFallback$DecryptingStreamWithFallback;", "Ljava/io/InputStream;", "stream", "fallbackStream", "Lkotlin/Function0;", "<init>", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function0;)V", "read", "", "b", "", "offset", "length", "skip", "", "n", "available", "close", "", "mark", "readlimit", "reset", "markSupported", "", "encrypted-datastore_release"})
    public static final class DecryptingStreamWithFallback
    extends InputStream {
        @NotNull
        private InputStream stream;
        @NotNull
        private final Function0<InputStream> fallbackStream;

        public DecryptingStreamWithFallback(@NotNull InputStream stream, @NotNull Function0<? extends InputStream> fallbackStream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter(fallbackStream, (String)"fallbackStream");
            this.stream = stream;
            this.fallbackStream = fallbackStream;
        }

        @Override
        public int read() {
            byte[] oneByte = new byte[1];
            return this.read(oneByte) == 1 ? oneByte[0] & 0xFF : -1;
        }

        @Override
        public int read(@NotNull byte[] b, int offset, int length) {
            int n;
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            try {
                n = this.stream.read(b, offset, length);
            }
            catch (IOException e) {
                if (!StreamingAeadWithFallbackKt.isProbablyEncryptedWithAeadException(e)) {
                    throw e;
                }
                this.stream = (InputStream)this.fallbackStream.invoke();
                n = this.stream.read(b, offset, length);
            }
            return n;
        }

        @Override
        public long skip(long n) {
            return this.stream.skip(n);
        }

        @Override
        public int available() {
            return this.stream.available();
        }

        @Override
        public void close() {
            this.stream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public void reset() {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

