/*
 * Decompiled with CFR 0.152.
 */
package com.dayanruben.maplibrecompose.compose;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.LayoutDirection;
import com.dayanruben.maplibrecompose.compose.CameraState;
import com.dayanruben.maplibrecompose.core.CameraPosition;
import com.dayanruben.spatialk.geojson.Position;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001:\u0001\fB\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003*\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u000b\u001a\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/dayanruben/maplibrecompose/compose/CameraStateSaver;", "Landroidx/compose/runtime/saveable/Saver;", "Lcom/dayanruben/maplibrecompose/compose/CameraState;", "", "", "", "<init>", "()V", "save", "Landroidx/compose/runtime/saveable/SaverScope;", "value", "restore", "Keys", "maplibre-compose_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCameraStateSaver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraStateSaver.kt\ncom/dayanruben/maplibrecompose/compose/CameraStateSaver\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,61:1\n118#2:62\n118#2:63\n118#2:64\n118#2:65\n*S KotlinDebug\n*F\n+ 1 CameraStateSaver.kt\ncom/dayanruben/maplibrecompose/compose/CameraStateSaver\n*L\n40#1:62\n41#1:63\n42#1:64\n43#1:65\n*E\n"})
public final class CameraStateSaver
implements Saver<CameraState, Map<String, ? extends Double>> {
    @NotNull
    public static final CameraStateSaver INSTANCE = new CameraStateSaver();
    public static final int $stable;

    private CameraStateSaver() {
    }

    @NotNull
    public Map<String, Double> save(@NotNull SaverScope $this$save, @NotNull CameraState value) {
        Intrinsics.checkNotNullParameter((Object)$this$save, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CameraPosition position = value.getPosition();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bearing", (Object)position.getBearing()), TuplesKt.to((Object)"latitude", (Object)position.getTarget().getLatitude()), TuplesKt.to((Object)"longitude", (Object)position.getTarget().getLongitude()), TuplesKt.to((Object)"tilt", (Object)position.getTilt()), TuplesKt.to((Object)"zoom", (Object)position.getZoom()), TuplesKt.to((Object)"padding_left", (Object)PaddingKt.calculateStartPadding((PaddingValues)position.getPadding(), (LayoutDirection)LayoutDirection.Ltr)), TuplesKt.to((Object)"padding_top", (Object)position.getPadding().calculateTopPadding-D9Ej5fM()), TuplesKt.to((Object)"padding_right", (Object)PaddingKt.calculateEndPadding((PaddingValues)position.getPadding(), (LayoutDirection)LayoutDirection.Ltr)), TuplesKt.to((Object)"padding_bottom", (Object)position.getPadding().calculateBottomPadding-D9Ej5fM())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public CameraState restore(@NotNull Map<String, Double> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Double d = value.get("bearing");
        Intrinsics.checkNotNull((Object)d);
        double d2 = ((Number)d).doubleValue();
        Double d3 = value.get("latitude");
        Intrinsics.checkNotNull((Object)d3);
        double d4 = ((Number)d3).doubleValue();
        Double d5 = value.get("longitude");
        Intrinsics.checkNotNull((Object)d5);
        double d6 = ((Number)d5).doubleValue();
        Position position = new Position(d6, d4);
        Double d7 = value.get("tilt");
        Intrinsics.checkNotNull((Object)d7);
        double d8 = ((Number)d7).doubleValue();
        Double d9 = value.get("zoom");
        Intrinsics.checkNotNull((Object)d9);
        double d10 = ((Number)d9).doubleValue();
        Double d11 = value.get("padding_left");
        Intrinsics.checkNotNull((Object)d11);
        double $this$dp$iv = ((Number)d11).doubleValue();
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl((float)((float)$this$dp$iv));
        Double d12 = value.get("padding_top");
        Intrinsics.checkNotNull((Object)d12);
        $this$dp$iv = ((Number)d12).doubleValue();
        $i$f$getDp = false;
        float f2 = Dp.constructor-impl((float)((float)$this$dp$iv));
        Double d13 = value.get("padding_right");
        Intrinsics.checkNotNull((Object)d13);
        $this$dp$iv = ((Number)d13).doubleValue();
        $i$f$getDp = false;
        float f3 = Dp.constructor-impl((float)((float)$this$dp$iv));
        Double d14 = value.get("padding_bottom");
        Intrinsics.checkNotNull((Object)d14);
        $this$dp$iv = ((Number)d14).doubleValue();
        $i$f$getDp = false;
        return new CameraState(new CameraPosition(d2, position, d8, d10, (PaddingValues)new PaddingValues.Absolute(f, f2, f3, Dp.constructor-impl((float)((float)$this$dp$iv)), null)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/dayanruben/maplibrecompose/compose/CameraStateSaver$Keys;", "", "<init>", "()V", "BEARING", "", "LATITUDE", "LONGITUDE", "TILT", "ZOOM", "PADDING_LEFT", "PADDING_TOP", "PADDING_RIGHT", "PADDING_BOTTOM", "maplibre-compose_release"})
    private static final class Keys {
        @NotNull
        public static final Keys INSTANCE = new Keys();
        @NotNull
        public static final String BEARING = "bearing";
        @NotNull
        public static final String LATITUDE = "latitude";
        @NotNull
        public static final String LONGITUDE = "longitude";
        @NotNull
        public static final String TILT = "tilt";
        @NotNull
        public static final String ZOOM = "zoom";
        @NotNull
        public static final String PADDING_LEFT = "padding_left";
        @NotNull
        public static final String PADDING_TOP = "padding_top";
        @NotNull
        public static final String PADDING_RIGHT = "padding_right";
        @NotNull
        public static final String PADDING_BOTTOM = "padding_bottom";

        private Keys() {
        }
    }
}

