/*
 * Decompiled with CFR 0.152.
 */
package com.dayanruben.security.crypto;

import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.security.crypto.EncryptedFile;
import androidx.security.crypto.EncryptedFileVisibilityHackKt;
import com.dayanruben.datastore.encrypted.EncryptingSerializerKt;
import com.dayanruben.datastore.encrypted.migration.StreamingAeadWithFallbackKt;
import com.dayanruben.security.crypto.EncryptedDataStoreOptions;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.StreamingAead;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u007f\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0019\b\u0002\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u001a\u0016\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"createEncrypted", "Landroidx/datastore/core/DataStore;", "T", "Landroidx/datastore/core/DataStoreFactory;", "serializer", "Landroidx/datastore/core/Serializer;", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "migrations", "", "Landroidx/datastore/core/DataMigration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "encryptionOptions", "Lkotlin/Function1;", "Lcom/dayanruben/security/crypto/EncryptedDataStoreOptions;", "", "Lkotlin/ExtensionFunctionType;", "produceFile", "Lkotlin/Function0;", "Landroidx/security/crypto/EncryptedFile;", "withDecryptionFallbackIfNotNull", "Lcom/google/crypto/tink/StreamingAead;", "fallbackAead", "Lcom/google/crypto/tink/Aead;", "security-crypto-datastore_release"})
public final class EncryptedDataStoreFactoryKt {
    @NotNull
    public static final <T> DataStore<T> createEncrypted(@NotNull DataStoreFactory $this$createEncrypted, @NotNull Serializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull List<? extends DataMigration<T>> migrations, @NotNull CoroutineScope scope, @NotNull Function1<? super EncryptedDataStoreOptions, Unit> encryptionOptions, @NotNull Function0<EncryptedFile> produceFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createEncrypted, (String)"<this>");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(encryptionOptions, (String)"encryptionOptions");
        Intrinsics.checkNotNullParameter(produceFile, (String)"produceFile");
        EncryptedDataStoreOptions encryptedDataStoreOptions = new EncryptedDataStoreOptions();
        encryptionOptions.invoke((Object)encryptedDataStoreOptions);
        EncryptedDataStoreOptions options = encryptedDataStoreOptions;
        EncryptedFile encryptedFile = (EncryptedFile)produceFile.invoke();
        StreamingAead streamingAead = EncryptedDataStoreFactoryKt.withDecryptionFallbackIfNotNull(EncryptedFileVisibilityHackKt.getStreamingAead(encryptedFile), options.getFallbackAead());
        File file = EncryptedFileVisibilityHackKt.getFile(encryptedFile);
        byte[] byArray = options.getAssociatedData();
        if (byArray == null) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        }
        byte[] associatedData = byArray;
        return $this$createEncrypted.create((Serializer)EncryptingSerializerKt.encrypted(serializer, (StreamingAead)streamingAead, (byte[])associatedData), corruptionHandler, migrations, scope, () -> EncryptedDataStoreFactoryKt.createEncrypted$lambda$1(file));
    }

    public static /* synthetic */ DataStore createEncrypted$default(DataStoreFactory dataStoreFactory, Serializer serializer, ReplaceFileCorruptionHandler replaceFileCorruptionHandler, List list, CoroutineScope coroutineScope, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            replaceFileCorruptionHandler = null;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        }
        if ((n & 0x10) != 0) {
            function1 = EncryptedDataStoreFactoryKt::createEncrypted$lambda$0;
        }
        return EncryptedDataStoreFactoryKt.createEncrypted(dataStoreFactory, serializer, replaceFileCorruptionHandler, list, coroutineScope, (Function1<? super EncryptedDataStoreOptions, Unit>)function1, (Function0<EncryptedFile>)function0);
    }

    private static final StreamingAead withDecryptionFallbackIfNotNull(StreamingAead $this$withDecryptionFallbackIfNotNull, Aead fallbackAead) {
        Aead aead = fallbackAead;
        return aead != null ? StreamingAeadWithFallbackKt.withDecryptionFallback((StreamingAead)$this$withDecryptionFallbackIfNotNull, (Aead)aead) : $this$withDecryptionFallbackIfNotNull;
    }

    private static final Unit createEncrypted$lambda$0(EncryptedDataStoreOptions encryptedDataStoreOptions) {
        Intrinsics.checkNotNullParameter((Object)encryptedDataStoreOptions, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final File createEncrypted$lambda$1(File $file) {
        return $file;
    }
}

