/*
 * Decompiled with CFR 0.152.
 */
package com.dayanruben.security.crypto;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.datastore.DataStoreFile;
import androidx.datastore.core.DataMigration;
import androidx.datastore.core.DataStore;
import androidx.datastore.core.DataStoreFactory;
import androidx.datastore.core.Serializer;
import androidx.datastore.core.handlers.ReplaceFileCorruptionHandler;
import androidx.security.crypto.EncryptedFile;
import com.dayanruben.security.crypto.EncryptedDataStoreFactoryKt;
import com.dayanruben.security.crypto.EncryptedDataStoreOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0002B\u0080\u0001\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\n\u0012\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0006\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\f\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u001e\u001a\u00020\u00032\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\f\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/dayanruben/security/crypto/EncryptedDataStoreSingletonDelegate;", "T", "Lkotlin/properties/ReadOnlyProperty;", "Landroid/content/Context;", "Landroidx/datastore/core/DataStore;", "fileName", "", "serializer", "Landroidx/datastore/core/Serializer;", "corruptionHandler", "Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;", "produceMigrations", "Lkotlin/Function1;", "", "Landroidx/datastore/core/DataMigration;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "masterKey", "fileEncryptionScheme", "Landroidx/security/crypto/EncryptedFile$FileEncryptionScheme;", "encryptionOptions", "Lcom/dayanruben/security/crypto/EncryptedDataStoreOptions;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Landroidx/datastore/core/Serializer;Landroidx/datastore/core/handlers/ReplaceFileCorruptionHandler;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Landroidx/security/crypto/EncryptedFile$FileEncryptionScheme;Lkotlin/jvm/functions/Function1;)V", "lock", "", "INSTANCE", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "security-crypto-datastore_release"})
public final class EncryptedDataStoreSingletonDelegate<T>
implements ReadOnlyProperty<Context, DataStore<T>> {
    @NotNull
    private final String fileName;
    @NotNull
    private final Serializer<T> serializer;
    @Nullable
    private final ReplaceFileCorruptionHandler<T> corruptionHandler;
    @NotNull
    private final Function1<Context, List<DataMigration<T>>> produceMigrations;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final String masterKey;
    @NotNull
    private final EncryptedFile.FileEncryptionScheme fileEncryptionScheme;
    @NotNull
    private final Function1<EncryptedDataStoreOptions, Unit> encryptionOptions;
    @NotNull
    private final Object lock;
    @GuardedBy(value="lock")
    @Nullable
    private volatile DataStore<T> INSTANCE;

    public EncryptedDataStoreSingletonDelegate(@NotNull String fileName, @NotNull Serializer<T> serializer, @Nullable ReplaceFileCorruptionHandler<T> corruptionHandler, @NotNull Function1<? super Context, ? extends List<? extends DataMigration<T>>> produceMigrations, @NotNull CoroutineScope scope, @NotNull String masterKey, @NotNull EncryptedFile.FileEncryptionScheme fileEncryptionScheme, @NotNull Function1<? super EncryptedDataStoreOptions, Unit> encryptionOptions) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter(produceMigrations, (String)"produceMigrations");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)fileEncryptionScheme, (String)"fileEncryptionScheme");
        Intrinsics.checkNotNullParameter(encryptionOptions, (String)"encryptionOptions");
        this.fileName = fileName;
        this.serializer = serializer;
        this.corruptionHandler = corruptionHandler;
        this.produceMigrations = produceMigrations;
        this.scope = scope;
        this.masterKey = masterKey;
        this.fileEncryptionScheme = fileEncryptionScheme;
        this.encryptionOptions = encryptionOptions;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataStore<T> getValue(@NotNull Context thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        DataStore<T> dataStore = this.INSTANCE;
        if (dataStore == null) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (this.INSTANCE == null) {
                    Context applicationContext = thisRef.getApplicationContext();
                    DataStoreFactory dataStoreFactory = DataStoreFactory.INSTANCE;
                    ReplaceFileCorruptionHandler<T> replaceFileCorruptionHandler = this.corruptionHandler;
                    Serializer<T> serializer = this.serializer;
                    Intrinsics.checkNotNull((Object)applicationContext);
                    List list = (List)this.produceMigrations.invoke((Object)applicationContext);
                    CoroutineScope coroutineScope = this.scope;
                    Function1<EncryptedDataStoreOptions, Unit> function1 = this.encryptionOptions;
                    this.INSTANCE = EncryptedDataStoreFactoryKt.createEncrypted(dataStoreFactory, serializer, replaceFileCorruptionHandler, list, coroutineScope, function1, (Function0<EncryptedFile>)((Function0)() -> EncryptedDataStoreSingletonDelegate.getValue$lambda$1$lambda$0(applicationContext, this)));
                }
                DataStore<T> dataStore2 = this.INSTANCE;
                Intrinsics.checkNotNull(dataStore2);
                DataStore<T> dataStore3 = dataStore2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                dataStore = dataStore3;
            }
        }
        return dataStore;
    }

    private static final EncryptedFile getValue$lambda$1$lambda$0(Context $applicationContext, EncryptedDataStoreSingletonDelegate this$0) {
        Intrinsics.checkNotNull((Object)$applicationContext);
        EncryptedFile encryptedFile = new EncryptedFile.Builder(DataStoreFile.dataStoreFile((Context)$applicationContext, (String)this$0.fileName), $applicationContext, this$0.masterKey, this$0.fileEncryptionScheme).build();
        Intrinsics.checkNotNullExpressionValue((Object)encryptedFile, (String)"build(...)");
        return encryptedFile;
    }
}

