/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy;

import com.dbdeploy.DbDeploy;
import com.dbdeploy.UserInputReader;
import com.dbdeploy.database.DelimiterType;
import com.dbdeploy.database.LineEnding;
import com.dbdeploy.exceptions.UsageException;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DbDeployCommandLineParser {
    private final UserInputReader userInputReader;

    public DbDeployCommandLineParser() {
        this(new UserInputReader());
    }

    public DbDeployCommandLineParser(UserInputReader userInputReader) {
        this.userInputReader = userInputReader;
    }

    public void parse(String[] args, DbDeploy dbDeploy) throws UsageException {
        try {
            dbDeploy.setScriptdirectory(new File("."));
            CommandLine commandLine = new GnuParser().parse(this.getOptions(), args);
            this.copyValuesFromCommandLineToDbDeployBean(dbDeploy, commandLine);
            if (commandLine.hasOption("password") && commandLine.getOptionValue("password") == null) {
                dbDeploy.setPassword(this.userInputReader.read("Password"));
            }
        }
        catch (ParseException e) {
            throw new UsageException(e.getMessage(), e);
        }
    }

    private void copyValuesFromCommandLineToDbDeployBean(DbDeploy dbDeploy, CommandLine commandLine) {
        try {
            BeanInfo info = Introspector.getBeanInfo(dbDeploy.getClass());
            for (PropertyDescriptor p : info.getPropertyDescriptors()) {
                String propertyName = p.getDisplayName();
                if (!commandLine.hasOption(propertyName)) continue;
                Object value = commandLine.getOptionValue(propertyName);
                if (p.getPropertyType().isAssignableFrom(File.class)) {
                    value = new File((String)value);
                }
                p.getWriteMethod().invoke((Object)dbDeploy, value);
            }
            if (commandLine.hasOption("delimitertype")) {
                dbDeploy.setDelimiterType(DelimiterType.valueOf(commandLine.getOptionValue("delimitertype")));
            }
            if (commandLine.hasOption("lineending")) {
                dbDeploy.setLineEnding(LineEnding.valueOf(commandLine.getOptionValue("lineending")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("dbdeploy", this.getOptions());
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("database user id");
        OptionBuilder.withLongOpt("userid");
        options.addOption(OptionBuilder.create("U"));
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("database password (use -P without a argument value to be prompted)");
        OptionBuilder.withLongOpt("password");
        options.addOption(OptionBuilder.create("P"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("database driver class");
        OptionBuilder.withLongOpt("driver");
        options.addOption(OptionBuilder.create("D"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("database url");
        OptionBuilder.withLongOpt("url");
        options.addOption(OptionBuilder.create("u"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("directory containing change scripts (default: .)");
        OptionBuilder.withLongOpt("scriptdirectory");
        options.addOption(OptionBuilder.create("s"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("encoding for input and output files (default: UTF-8)");
        OptionBuilder.withLongOpt("encoding");
        options.addOption(OptionBuilder.create("e"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("output file");
        OptionBuilder.withLongOpt("outputfile");
        options.addOption(OptionBuilder.create("o"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("dbms type");
        OptionBuilder.withLongOpt("dbms");
        options.addOption(OptionBuilder.create("d"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("template directory");
        OptionBuilder.withLongOpt("templatedir");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("name of change log table to use (default: changelog)");
        OptionBuilder.withLongOpt("changeLogTableName");
        options.addOption(OptionBuilder.create("t"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("delimiter to separate sql statements");
        OptionBuilder.withLongOpt("delimiter");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("delimiter type to separate sql statements (row or normal)");
        OptionBuilder.withLongOpt("delimitertype");
        options.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("line ending to use when applying scripts direct to db (platform, cr, crlf, lf)");
        OptionBuilder.withLongOpt("lineending");
        options.addOption(OptionBuilder.create());
        return options;
    }
}

