/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.appliers;

import com.dbdeploy.ChangeScriptApplier;
import com.dbdeploy.database.QueryStatementSplitter;
import com.dbdeploy.database.changelog.DatabaseSchemaVersionManager;
import com.dbdeploy.database.changelog.QueryExecuter;
import com.dbdeploy.exceptions.ChangeScriptFailedException;
import com.dbdeploy.scripts.ChangeScript;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectToDbApplier
implements ChangeScriptApplier {
    private final QueryExecuter queryExecuter;
    private final DatabaseSchemaVersionManager schemaVersionManager;
    private final QueryStatementSplitter splitter;

    public DirectToDbApplier(QueryExecuter queryExecuter, DatabaseSchemaVersionManager schemaVersionManager, QueryStatementSplitter splitter) {
        this.queryExecuter = queryExecuter;
        this.schemaVersionManager = schemaVersionManager;
        this.splitter = splitter;
    }

    @Override
    public void apply(List<ChangeScript> changeScript) {
        this.begin();
        for (ChangeScript script : changeScript) {
            System.err.println("Applying " + script + "...");
            this.applyChangeScript(script);
            this.insertToSchemaVersionTable(script);
            this.commitTransaction();
        }
    }

    public void begin() {
        try {
            this.queryExecuter.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void applyChangeScript(ChangeScript script) {
        List<String> statements = this.splitter.split(script.getContent());
        for (int i = 0; i < statements.size(); ++i) {
            String statement = statements.get(i);
            try {
                if (statements.size() > 1) {
                    System.err.println(" -> statement " + (i + 1) + " of " + statements.size() + "...");
                }
                this.queryExecuter.execute(statement);
                continue;
            }
            catch (SQLException e) {
                throw new ChangeScriptFailedException(e, script, i + 1, statement);
            }
        }
    }

    protected void insertToSchemaVersionTable(ChangeScript changeScript) {
        this.schemaVersionManager.recordScriptApplied(changeScript);
    }

    protected void commitTransaction() {
        try {
            this.queryExecuter.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException();
        }
    }
}

