/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy;

import com.dbdeploy.ChangeScriptApplier;
import com.dbdeploy.Controller;
import com.dbdeploy.appliers.DirectToDbApplier;
import com.dbdeploy.appliers.TemplateBasedApplier;
import com.dbdeploy.appliers.UndoTemplateBasedApplier;
import com.dbdeploy.database.DelimiterType;
import com.dbdeploy.database.LineEnding;
import com.dbdeploy.database.QueryStatementSplitter;
import com.dbdeploy.database.changelog.DatabaseSchemaVersionManager;
import com.dbdeploy.database.changelog.QueryExecuter;
import com.dbdeploy.exceptions.UsageException;
import com.dbdeploy.scripts.ChangeScriptRepository;
import com.dbdeploy.scripts.DirectoryScanner;
import java.io.File;
import java.io.PrintWriter;

public class DbDeploy {
    private String url;
    private String userid;
    private String password;
    private String encoding = "UTF-8";
    private File scriptdirectory;
    private File outputfile;
    private File undoOutputfile;
    private LineEnding lineEnding = LineEnding.platform;
    private String dbms;
    private Long lastChangeToApply = Long.MAX_VALUE;
    private String driver;
    private String changeLogTableName = "changelog";
    private String delimiter = ";";
    private DelimiterType delimiterType = DelimiterType.normal;
    private File templatedir;

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setScriptdirectory(File scriptdirectory) {
        this.scriptdirectory = scriptdirectory;
    }

    public void setOutputfile(File outputfile) {
        this.outputfile = outputfile;
    }

    public void setDbms(String dbms) {
        this.dbms = dbms;
    }

    public void setLastChangeToApply(Long lastChangeToApply) {
        this.lastChangeToApply = lastChangeToApply;
    }

    public void setUndoOutputfile(File undoOutputfile) {
        this.undoOutputfile = undoOutputfile;
    }

    public void setChangeLogTableName(String changeLogTableName) {
        this.changeLogTableName = changeLogTableName;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLineEnding(LineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }

    public void go() throws Exception {
        ChangeScriptApplier doScriptApplier;
        System.err.println(this.getWelcomeString());
        this.validate();
        Class.forName(this.driver);
        QueryExecuter queryExecuter = new QueryExecuter(this.url, this.userid, this.password);
        DatabaseSchemaVersionManager databaseSchemaVersionManager = new DatabaseSchemaVersionManager(queryExecuter, this.changeLogTableName);
        ChangeScriptRepository changeScriptRepository = new ChangeScriptRepository(new DirectoryScanner(this.encoding).getChangeScriptsForDirectory(this.scriptdirectory));
        if (this.outputfile != null) {
            doScriptApplier = new TemplateBasedApplier(new PrintWriter(this.outputfile, this.encoding), this.dbms, this.changeLogTableName, this.getTemplatedir());
        } else {
            QueryStatementSplitter splitter = new QueryStatementSplitter();
            splitter.setDelimiter(this.getDelimiter());
            splitter.setDelimiterType(this.getDelimiterType());
            splitter.setOutputLineEnding(this.lineEnding);
            doScriptApplier = new DirectToDbApplier(queryExecuter, databaseSchemaVersionManager, splitter);
        }
        UndoTemplateBasedApplier undoScriptApplier = null;
        if (this.undoOutputfile != null) {
            undoScriptApplier = new UndoTemplateBasedApplier(new PrintWriter(this.undoOutputfile), this.dbms, this.changeLogTableName, this.getTemplatedir());
        }
        Controller controller = new Controller(changeScriptRepository, databaseSchemaVersionManager, doScriptApplier, undoScriptApplier);
        controller.processChangeScripts(this.lastChangeToApply);
        queryExecuter.close();
    }

    private void validate() throws UsageException {
        this.checkForRequiredParameter(this.userid, "userid");
        this.checkForRequiredParameter(this.driver, "driver");
        this.checkForRequiredParameter(this.url, "url");
        this.checkForRequiredParameter(this.scriptdirectory, "dir");
        if (this.scriptdirectory == null || !this.scriptdirectory.isDirectory()) {
            throw new UsageException("Script directory must point to a valid directory");
        }
    }

    private void checkForRequiredParameter(String parameterValue, String parameterName) throws UsageException {
        if (parameterValue == null || parameterValue.length() == 0) {
            UsageException.throwForMissingRequiredValue(parameterName);
        }
    }

    private void checkForRequiredParameter(Object parameterValue, String parameterName) throws UsageException {
        if (parameterValue == null) {
            UsageException.throwForMissingRequiredValue(parameterName);
        }
    }

    public String getUserid() {
        return this.userid;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPassword() {
        return this.password;
    }

    public File getScriptdirectory() {
        return this.scriptdirectory;
    }

    public File getOutputfile() {
        return this.outputfile;
    }

    public File getUndoOutputfile() {
        return this.undoOutputfile;
    }

    public String getDbms() {
        return this.dbms;
    }

    public Long getLastChangeToApply() {
        return this.lastChangeToApply;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setTemplatedir(File templatedir) {
        this.templatedir = templatedir;
    }

    public File getTemplatedir() {
        return this.templatedir;
    }

    public String getChangeLogTableName() {
        return this.changeLogTableName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public DelimiterType getDelimiterType() {
        return this.delimiterType;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType;
    }

    public String getWelcomeString() {
        String version = this.getClass().getPackage().getImplementationVersion();
        return "dbdeploy " + version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public LineEnding getLineEnding() {
        return this.lineEnding;
    }
}

