/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy;

import com.dbdeploy.scripts.ChangeScript;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinter {
    public String format(List<Long> appliedChanges) {
        if (appliedChanges.isEmpty()) {
            return "(none)";
        }
        StringBuilder builder = new StringBuilder();
        Long lastRangeStart = null;
        Long lastNumber = null;
        for (Long thisNumber : appliedChanges) {
            if (lastNumber == null) {
                lastNumber = thisNumber;
                lastRangeStart = thisNumber;
                continue;
            }
            if (thisNumber == lastNumber + 1L) {
                lastNumber = thisNumber;
                continue;
            }
            this.appendRange(builder, lastRangeStart, lastNumber);
            lastNumber = thisNumber;
            lastRangeStart = thisNumber;
        }
        this.appendRange(builder, lastRangeStart, lastNumber);
        return builder.toString();
    }

    private void appendRange(StringBuilder builder, Long lastRangeStart, Long lastNumber) {
        if (lastRangeStart == lastNumber) {
            this.appendWithPossibleComma(builder, lastNumber);
        } else if (lastRangeStart + 1L == lastNumber) {
            this.appendWithPossibleComma(builder, lastRangeStart);
            this.appendWithPossibleComma(builder, lastNumber);
        } else {
            this.appendWithPossibleComma(builder, lastRangeStart + ".." + lastNumber);
        }
    }

    private void appendWithPossibleComma(StringBuilder builder, Object o) {
        if (builder.length() != 0) {
            builder.append(", ");
        }
        builder.append(o);
    }

    public String formatChangeScriptList(List<ChangeScript> changeScripts) {
        ArrayList<Long> numberList = new ArrayList<Long>(changeScripts.size());
        for (ChangeScript changeScript : changeScripts) {
            numberList.add(changeScript.getId());
        }
        return this.format(numberList);
    }
}

