/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.appliers;

import com.dbdeploy.ChangeScriptApplier;
import com.dbdeploy.exceptions.UsageException;
import com.dbdeploy.scripts.ChangeScript;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateBasedApplier
implements ChangeScriptApplier {
    private Configuration configuration;
    private Writer writer;
    private String syntax;
    private String changeLogTableName;

    public TemplateBasedApplier(Writer writer, String syntax, String changeLogTableName, File templateDirectory) throws IOException {
        this.syntax = syntax;
        this.changeLogTableName = changeLogTableName;
        this.writer = writer;
        this.configuration = new Configuration();
        FileTemplateLoader fileTemplateLoader = this.createFileTemplateLoader(templateDirectory);
        this.configuration.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(new TemplateLoader[]{fileTemplateLoader, new ClassTemplateLoader(this.getClass(), "/")}));
    }

    private FileTemplateLoader createFileTemplateLoader(File templateDirectory) throws IOException {
        if (templateDirectory == null) {
            return new FileTemplateLoader();
        }
        return new FileTemplateLoader(templateDirectory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(List<ChangeScript> changeScripts) {
        String filename = this.syntax + "_" + this.getTemplateQualifier() + ".ftl";
        try {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("scripts", changeScripts);
            model.put("changeLogTableName", this.changeLogTableName);
            try {
                Template template = this.configuration.getTemplate(filename);
                template.process(model, this.writer);
            }
            finally {
                this.writer.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw new UsageException("Could not find template named " + filename + "\n" + "Check that you have got the name of the database syntax correct.", ex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getTemplateQualifier() {
        return "apply";
    }
}

