/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.database;

import com.dbdeploy.database.DelimiterType;
import com.dbdeploy.database.LineEnding;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStatementSplitter {
    private String delimiter = ";";
    private DelimiterType delimiterType = DelimiterType.normal;
    private LineEnding lineEnding = LineEnding.platform;

    public List<String> split(String input) {
        ArrayList<String> statements = new ArrayList<String>();
        StrBuilder currentSql = new StrBuilder();
        StrTokenizer lineTokenizer = new StrTokenizer(input);
        lineTokenizer.setDelimiterMatcher(StrMatcher.charSetMatcher((String)"\r\n"));
        for (String line : lineTokenizer.getTokenArray()) {
            String strippedLine = StringUtils.stripEnd((String)line, null);
            if (!currentSql.isEmpty()) {
                currentSql.append(this.lineEnding.get());
            }
            currentSql.append(strippedLine);
            if (!this.delimiterType.matches(strippedLine, this.delimiter)) continue;
            statements.add(currentSql.substring(0, currentSql.length() - this.delimiter.length()));
            currentSql.clear();
        }
        if (!currentSql.isEmpty()) {
            statements.add(currentSql.toString());
        }
        return statements;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public DelimiterType getDelimiterType() {
        return this.delimiterType;
    }

    public void setDelimiterType(DelimiterType delimiterType) {
        this.delimiterType = delimiterType;
    }

    public void setOutputLineEnding(LineEnding lineEnding) {
        this.lineEnding = lineEnding;
    }
}

