/*
 * Decompiled with CFR 0.152.
 */
package com.dbdeploy.scripts;

import com.dbdeploy.exceptions.DbDeployException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ChangeScript
implements Comparable {
    private final long id;
    private final File file;
    private final String description;
    private final String encoding;
    private static final String UNDO_MARKER = "--//@UNDO";

    public ChangeScript(long id) {
        this(id, "test");
    }

    public ChangeScript(long id, String description) {
        this.id = id;
        this.file = null;
        this.description = description;
        this.encoding = "UTF-8";
    }

    public ChangeScript(long id, File file, String encoding) {
        this.id = id;
        this.file = file;
        this.description = file.getName();
        this.encoding = encoding;
    }

    public File getFile() {
        return this.file;
    }

    public long getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Object o) {
        ChangeScript other = (ChangeScript)o;
        return Long.valueOf(this.id).compareTo(other.id);
    }

    public String toString() {
        return "#" + this.id + ": " + this.description;
    }

    public String getContent() {
        return this.getFileContents(false);
    }

    public String getUndoContent() {
        return this.getFileContents(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(boolean onlyAfterUndoMarker) {
        try {
            StringBuilder content = new StringBuilder();
            boolean foundUndoMarker = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            try {
                String str;
                while ((str = reader.readLine()) != null) {
                    if (str.trim().equals(UNDO_MARKER)) {
                        foundUndoMarker = true;
                        continue;
                    }
                    if (foundUndoMarker != onlyAfterUndoMarker) continue;
                    content.append(str);
                    content.append('\n');
                }
            }
            finally {
                reader.close();
            }
            return content.toString();
        }
        catch (IOException e) {
            throw new DbDeployException("Failed to read change script file", e);
        }
    }
}

