/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema;

import com.dbschema.mongo.DriverPropertyInfoHelper;
import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.Util;
import com.dbschema.mongo.mongosh.LazyShellHolder;
import com.dbschema.mongo.mongosh.PrecalculatingShellHolder;
import com.dbschema.mongo.mongosh.ShellHolder;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.graalvm.polyglot.Engine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoJdbcDriver
implements Driver {
    private final DriverPropertyInfoHelper propertyInfoHelper = new DriverPropertyInfoHelper();
    @Nullable
    private ExecutorService executorService;
    @Nullable
    private Engine sharedEngine;
    @NotNull
    private ShellHolder shellHolder = this.createShellHolder();

    @NotNull
    private ShellHolder createShellHolder() {
        if ("true".equals(System.getProperty("mongosh.disableShellPrecalculation"))) {
            return new LazyShellHolder();
        }
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(10, Util.newNamedThreadFactory("MongoShell ExecutorService"));
        }
        Engine engine = null;
        if (!"true".equals(System.getProperty("mongosh.disableSharedEngine"))) {
            if (this.sharedEngine == null) {
                this.sharedEngine = Engine.create("js");
            }
            engine = this.sharedEngine;
        }
        return new PrecalculatingShellHolder(this.executorService, engine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null || !this.acceptsURL(url)) {
            return null;
        }
        int fetchDocumentsForMeta = 10;
        if (info.getProperty("fetch_documents_for_metainfo") != null) {
            try {
                fetchDocumentsForMeta = Integer.parseInt(info.getProperty("fetch_documents_for_metainfo"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (fetchDocumentsForMeta < 0) {
            fetchDocumentsForMeta = 0;
        }
        if (url.startsWith("jdbc:")) {
            url = url.substring("jdbc:".length());
        }
        String username = info.getProperty("user");
        String password = info.getProperty("password");
        MongoJdbcDriver mongoJdbcDriver = this;
        synchronized (mongoJdbcDriver) {
            ShellHolder shellHolder = this.shellHolder;
            this.shellHolder = this.createShellHolder();
            return new MongoConnection(url, info, username, password, fetchDocumentsForMeta, shellHolder);
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        if (url.startsWith("jdbc:")) {
            url = url.substring("jdbc:".length());
        }
        return url.startsWith("mongodb://") || url.startsWith("mongodb+srv://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return this.propertyInfoHelper.getPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 19;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public void close() {
        this.shellHolder.close();
        if (this.sharedEngine != null) {
            this.sharedEngine.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    static {
        try {
            DriverManager.registerDriver(new MongoJdbcDriver());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

