/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.SQLAlreadyClosedException;
import com.dbschema.mongo.SSLUtil;
import com.dbschema.mongo.Util;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.bson.UuidRepresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoClientWrapper
implements AutoCloseable {
    private boolean isClosed = false;
    private final MongoClient mongoClient;
    public final String databaseNameFromUrl;

    public MongoClientWrapper(@NotNull String uri, @NotNull Properties prop, @Nullable String username, @Nullable String password) throws SQLException {
        try {
            int timeout;
            boolean automaticEncoding = true;
            if (prop.getProperty("auto_encode_username_and_password") != null) {
                automaticEncoding = Boolean.parseBoolean(prop.getProperty("auto_encode_username_and_password"));
            }
            uri = Util.insertCredentials(uri, username, password, automaticEncoding);
            uri = Util.insertAuthMechanism(uri, prop.getProperty("authMechanism"));
            uri = Util.insertAuthSource(uri, prop.getProperty("authSource"));
            uri = Util.insertAuthProperty(uri, "AWS_SESSION_TOKEN", prop.getProperty("AWS_SESSION_TOKEN"));
            uri = Util.insertAuthProperty(uri, "SERVICE_NAME", prop.getProperty("SERVICE_NAME"));
            uri = Util.insertAuthProperty(uri, "SERVICE_REALM", prop.getProperty("SERVICE_REALM"));
            String canonicalizeHostName = prop.getProperty("CANONICALIZE_HOST_NAME");
            if (Boolean.TRUE.toString().equalsIgnoreCase(canonicalizeHostName) || Boolean.FALSE.toString().equalsIgnoreCase(canonicalizeHostName)) {
                uri = Util.insertAuthProperty(uri, "CANONICALIZE_HOST_NAME", canonicalizeHostName);
            } else if (canonicalizeHostName != null) {
                System.err.println("Unknown CANONICALIZE_HOST_NAME value. Must be true or false.");
            }
            uri = Util.insertRetryWrites(uri, prop.getProperty("retryWrites"));
            ConnectionString connectionString = new ConnectionString(uri);
            this.databaseNameFromUrl = connectionString.getDatabase();
            int maxPoolSize = this.getMaxPoolSize(prop);
            MongoClientSettings.Builder builder = MongoClientSettings.builder().applyConnectionString(connectionString).applyToConnectionPoolSettings(b -> b.maxSize(maxPoolSize));
            String application = prop.getProperty("appName");
            if (!Util.isNullOrEmpty(application)) {
                builder.applicationName(application);
            }
            if ("true".equals(prop.getProperty("ssl"))) {
                boolean allowInvalidCertificates = uri.contains("tlsAllowInvalidCertificates=true") || uri.contains("sslAllowInvalidCertificates=true") || Util.isTrue(prop.getProperty("tlsAllowInvalidCertificates", Boolean.toString(false)));
                builder.applyToSslSettings(s -> {
                    s.enabled(true);
                    boolean allowInvalidHostnames = Util.isTrue(prop.getProperty("tlsAllowInvalidHostnames", Boolean.toString(false)));
                    if (allowInvalidHostnames) {
                        s.invalidHostNameAllowed(true);
                    }
                    if (allowInvalidCertificates) {
                        String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                        String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
                        Object keyStoreUrl = System.getProperty("javax.net.ssl.keyStore", "");
                        if (!Util.isNullOrEmpty((String)keyStoreUrl)) {
                            try {
                                new URL((String)keyStoreUrl);
                            }
                            catch (MalformedURLException e) {
                                keyStoreUrl = "file:" + (String)keyStoreUrl;
                            }
                        }
                        try {
                            s.context(SSLUtil.getTrustEverybodySSLContext((String)keyStoreUrl, keyStoreType, keyStorePassword));
                        }
                        catch (SSLUtil.SSLParamsException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            if (connectionString.getUuidRepresentation() == null) {
                String uuidRepresentation = prop.getProperty("uuidRepresentation", "standard");
                builder.uuidRepresentation(MongoClientWrapper.createUuidRepresentation(uuidRepresentation));
            }
            if (connectionString.getServerSelectionTimeout() == null) {
                timeout = Integer.parseInt(prop.getProperty("serverSelectionTimeoutMS", "10000"));
                builder.applyToClusterSettings(b -> b.serverSelectionTimeout(timeout, TimeUnit.MILLISECONDS));
            }
            if (connectionString.getConnectTimeout() == null) {
                timeout = Integer.parseInt(prop.getProperty("connectTimeoutMS", "10000"));
                builder.applyToSocketSettings(b -> b.connectTimeout(timeout, TimeUnit.MILLISECONDS));
            }
            this.mongoClient = MongoClients.create(builder.build());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private static UuidRepresentation createUuidRepresentation(String value) {
        if (value.equalsIgnoreCase("unspecified")) {
            return UuidRepresentation.UNSPECIFIED;
        }
        if (value.equalsIgnoreCase("javaLegacy")) {
            return UuidRepresentation.JAVA_LEGACY;
        }
        if (value.equalsIgnoreCase("csharpLegacy")) {
            return UuidRepresentation.C_SHARP_LEGACY;
        }
        if (value.equalsIgnoreCase("pythonLegacy")) {
            return UuidRepresentation.PYTHON_LEGACY;
        }
        if (value.equalsIgnoreCase("standard")) {
            return UuidRepresentation.STANDARD;
        }
        throw new IllegalArgumentException("Unknown uuid representation: " + value);
    }

    private int getMaxPoolSize(@NotNull Properties prop) {
        try {
            String str = prop.getProperty("max_connection_pool_size");
            if (str != null) {
                int poolSize = Integer.parseInt(str);
                return poolSize > 0 ? poolSize : 1;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return 3;
    }

    @Override
    public void close() throws SQLAlreadyClosedException {
        this.checkClosed();
        this.isClosed = true;
        this.mongoClient.close();
    }

    private void checkClosed() throws SQLAlreadyClosedException {
        if (this.isClosed) {
            throw new SQLAlreadyClosedException(this.getClass().getSimpleName());
        }
    }

    public MongoIterable<String> listDatabaseNames() throws SQLAlreadyClosedException {
        this.checkClosed();
        return this.mongoClient.listDatabaseNames();
    }

    public MongoDatabase getDatabase(String databaseName) throws SQLAlreadyClosedException {
        this.checkClosed();
        return this.mongoClient.getDatabase(databaseName);
    }

    @NotNull
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }
}

