/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.MongoDatabaseMetaData;
import com.dbschema.mongo.MongoScriptEngine;
import com.dbschema.mongo.MongoService;
import com.dbschema.mongo.SQLAlreadyClosedException;
import com.dbschema.mongo.dbvis.DbVisMongoPreparedStatement;
import com.dbschema.mongo.mongosh.MongoshScriptEngine;
import com.dbschema.mongo.mongosh.ShellHolder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoConnection
implements Connection {
    private MongoService service;
    private MongoScriptEngine scriptEngine;
    private String schema;
    private boolean isClosed = false;
    private boolean isReadOnly = false;
    private final MongoDatabaseMetaData metaData = new MongoDatabaseMetaData(this);

    public MongoConnection(@NotNull String url, @NotNull Properties info, @Nullable String username, @Nullable String password, int fetchDocumentsForMeta, @NotNull ShellHolder shellHolder) throws SQLException {
        this.service = new MongoService(url, info, username, password, fetchDocumentsForMeta);
        this.scriptEngine = new MongoshScriptEngine(this, shellHolder);
        try {
            this.setSchema(this.service.getDatabaseNameFromUrl());
        }
        catch (SQLAlreadyClosedException sQLAlreadyClosedException) {
            // empty catch block
        }
    }

    @Override
    public String getCatalog() {
        return null;
    }

    public MongoService getService() {
        return this.service;
    }

    public MongoScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new DbVisMongoPreparedStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return new DbVisMongoPreparedStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new DbVisMongoPreparedStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new DbVisMongoPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB does not support SQL natively.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void close() throws SQLAlreadyClosedException {
        this.checkClosed();
        this.isClosed = true;
        this.service.close();
        this.service = null;
        this.scriptEngine.close();
        this.scriptEngine = null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.isReadOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String catalog) {
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB provides no support for transactions.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) {
    }

    @Override
    public void setHoldability(int holdability) {
    }

    @Override
    public int getHoldability() {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return null;
    }

    @Override
    public Clob createClob() {
        return null;
    }

    @Override
    public Blob createBlob() {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) {
    }

    @Override
    public void setClientInfo(Properties properties) {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getUrl() {
        return this.service.getURI();
    }

    private void checkClosed() throws SQLAlreadyClosedException {
        if (this.isClosed) {
            throw new SQLAlreadyClosedException(this.getClass().getSimpleName());
        }
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void abort(Executor executor) {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) {
    }

    @Override
    public int getNetworkTimeout() {
        return 0;
    }
}

