/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.MongoNamePattern;
import com.dbschema.mongo.SQLAlreadyClosedException;
import com.dbschema.mongo.resultSet.ListResultSet;
import com.dbschema.mongo.schema.MetaCollection;
import com.dbschema.mongo.schema.MetaField;
import com.dbschema.mongo.schema.MetaIndex;
import com.dbschema.mongo.schema.MetaJson;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MongoDatabaseMetaData
implements DatabaseMetaData {
    private static final String DB_NAME = "Mongo";
    private final MongoConnection con;
    public static final String OBJECT_ID_TYPE_NAME = "OBJECT_ID";
    public static final String DOCUMENT_TYPE_NAME = "DOCUMENT";

    public MongoDatabaseMetaData(MongoConnection con) {
        this.con = con;
    }

    @Override
    public ResultSet getSchemas() throws SQLAlreadyClosedException {
        List<String> mongoDbs = this.con.getService().getDatabaseNames();
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TABLE_SCHEM", "TABLE_CATALOG");
        for (String mongoDb : mongoDbs) {
            retVal.addRow(new String[]{mongoDb, DB_NAME});
        }
        return retVal;
    }

    @Override
    public ResultSet getCatalogs() {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TABLE_CAT");
        retVal.addRow(new String[]{DB_NAME});
        return retVal;
    }

    @Override
    public ResultSet getTables(String catalogName, String schemaPattern, String tableNamePattern, String[] types) throws SQLAlreadyClosedException {
        ListResultSet resultSet = new ListResultSet();
        resultSet.setColumnNames("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION");
        MongoNamePattern pSchema = MongoNamePattern.create(schemaPattern);
        MongoNamePattern pTable = MongoNamePattern.create(tableNamePattern);
        for (String schema : this.con.getService().getDatabaseNames()) {
            if (!pSchema.matches(schema)) continue;
            for (String tableName : this.con.getService().getCollectionNames(schema)) {
                if (!pTable.matches(tableName)) continue;
                resultSet.addRow(this.createTableRow(schema, tableName));
            }
        }
        return resultSet;
    }

    private String[] createTableRow(String catalogName, String tableName) {
        String[] data = new String[]{null, catalogName, tableName, "TABLE", "", "", "", "", "", ""};
        return data;
    }

    @Override
    public ResultSet getColumns(String catalogName, String schemaName, String tableNamePattern, String columnNamePattern) throws SQLAlreadyClosedException {
        List<MetaCollection> collections = this.con.getService().getMetaCollections(schemaName, tableNamePattern);
        ListResultSet result2 = new ListResultSet();
        result2.setColumnNames("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATLOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT");
        ArrayList<String[]> columnsData = new ArrayList<String[]>();
        for (MetaCollection metaCollection : collections) {
            MongoNamePattern p = MongoNamePattern.create(columnNamePattern);
            for (MetaField field : metaCollection.fields) {
                if (!p.matches(field.name)) continue;
                this.exportColumnsRecursive(metaCollection, columnsData, field);
            }
        }
        columnsData.sort((o1, o2) -> {
            String n1 = o1[3];
            String n2 = o2[3];
            if ("_id".equals(n1)) {
                return -1;
            }
            if ("_id".equals(n2)) {
                return 1;
            }
            return n1.compareTo(n2);
        });
        for (Object[] objectArray : columnsData) {
            result2.addRow(objectArray);
        }
        return result2;
    }

    private void exportColumnsRecursive(MetaCollection collection, List<String[]> columnsData, MetaField field) {
        String name = field.getNameWithPath();
        columnsData.add(new String[]{DB_NAME, collection.db, collection.name, name, "" + field.type, field.typeName, null, null, null, null, "" + (field.isMandatory() ? 0 : 1), null, null, null, null, null, null, "YES", null, null, null, null, "NO"});
        if (field instanceof MetaJson) {
            MetaJson json = (MetaJson)field;
            for (MetaField children : json.fields) {
                this.exportColumnsRecursive(collection, columnsData, children);
            }
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalogName, String schemaName, String tableNamePattern) throws SQLAlreadyClosedException {
        ListResultSet result2 = new ListResultSet();
        result2.setColumnNames("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME");
        List<MetaCollection> collections = this.con.getService().getMetaCollections(schemaName, tableNamePattern);
        for (MetaCollection collection : collections) {
            for (MetaIndex index : collection.metaIndexes) {
                if (!index.pk) continue;
                for (MetaField field : index.metaFields) {
                    result2.addRow(new String[]{collection.name, null, collection.name, field.getNameWithPath(), "" + index.metaFields.indexOf(field), index.name});
                }
            }
        }
        return result2;
    }

    @Override
    public ResultSet getIndexInfo(String catalogName, String schemaName, String tableNamePattern, boolean unique, boolean approximate) throws SQLAlreadyClosedException {
        ListResultSet result2 = new ListResultSet();
        result2.setColumnNames("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION");
        List<MetaCollection> collections = this.con.getService().getMetaCollections(schemaName, tableNamePattern);
        for (MetaCollection collection : collections) {
            for (MetaIndex index : collection.metaIndexes) {
                if (index.pk) continue;
                for (MetaField field : index.metaFields) {
                    result2.addRow(new String[]{collection.name, null, collection.name, "YES", collection.name, index.name, "0", "" + index.metaFields.indexOf(field), field.getNameWithPath(), "A", "0", "0", ""});
                }
            }
        }
        return result2;
    }

    @Override
    public ResultSet getTypeInfo() {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX");
        retVal.addRow(new String[]{OBJECT_ID_TYPE_NAME, "12", "800", "'", "'", null, "1", "true", "3", "false", "false", "false", OBJECT_ID_TYPE_NAME, "0", "0", null, null, "10"});
        retVal.addRow(new String[]{DOCUMENT_TYPE_NAME, "2005", "16777216", "'", "'", null, "1", "true", "3", "false", "false", "false", DOCUMENT_TYPE_NAME, "0", "0", null, null, "10"});
        return retVal;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public String getURL() {
        return this.con.getUrl();
    }

    @Override
    public String getUserName() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return "Mongo DB";
    }

    @Override
    @NotNull
    public String getDatabaseProductVersion() throws SQLException {
        return this.con.getService().getVersion();
    }

    @Override
    public String getDriverName() {
        return "MongoDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return "1.19";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 19;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() {
        return null;
    }

    @Override
    public String getSQLKeywords() {
        return null;
    }

    @Override
    public String getNumericFunctions() {
        return null;
    }

    @Override
    public String getStringFunctions() {
        return null;
    }

    @Override
    public String getSystemFunctions() {
        return null;
    }

    @Override
    public String getTimeDateFunctions() {
        return "date";
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() {
        return null;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    @Override
    public String getProcedureTerm() {
        return null;
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 90;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 1;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalogName, String schemaPattern, String procedureNamePattern) {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("PROCEDURE_CAT", "PROCEDURE_SCHEMA", "PROCEDURE_NAME", "REMARKS", "PROCEDURE_TYPE", "SPECIFIC_NAME");
        return retVal;
    }

    @Override
    public ResultSet getProcedureColumns(String catalogName, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return MongoDatabaseMetaData.empty();
    }

    private static ResultSet empty() {
        return new ListResultSet();
    }

    @Override
    public ResultSet getTableTypes() {
        ListResultSet result2 = new ListResultSet();
        result2.addRow(new String[]{"COLLECTION"});
        return result2;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalogName, String schemaName, String table, String columnNamePattern) {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalogName, String schemaPattern, String tableNamePattern) {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalogName, String schemaName, String table, int scope, boolean nullable) {
        return null;
    }

    @Override
    public ResultSet getVersionColumns(String catalogName, String schemaName, String table) {
        return MongoDatabaseMetaData.empty();
    }

    @Override
    public ResultSet getExportedKeys(String catalogName, String schemaName, String tableNamePattern) {
        return null;
    }

    @Override
    public ResultSet getImportedKeys(String catalogName, String schemaName, String tableNamePattern) {
        return null;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return MongoDatabaseMetaData.empty();
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public ResultSet getUDTs(String catalogName, String schemaPattern, String typeNamePattern, int[] types) {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS", "BASE_TYPE");
        return retVal;
    }

    @Override
    public Connection getConnection() {
        return this.con;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalogName, String schemaPattern, String typeNamePattern) {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SUPERTYPE_CAT", "SUPERTYPE_SCHEM", "SUPERTYPE_NAME");
        return retVal;
    }

    @Override
    public ResultSet getSuperTables(String catalogName, String schemaPattern, String tableNamePattern) {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "SUPERTABLE_NAME");
        return retVal;
    }

    @Override
    public ResultSet getAttributes(String catalogName, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        ListResultSet retVal = new ListResultSet();
        retVal.setColumnNames("TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "ATTR_NAME", "DATA_TYPE", "ATTR_TYPE_NAME", "ATTR_SIZE", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "ATTR_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE");
        return retVal;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return false;
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        String version = this.getDatabaseProductVersion();
        try {
            String[] parts = version.split("\\.");
            if (parts.length >= 1) {
                return Integer.parseInt(parts[0]);
            }
            System.err.println("WARNING: cannot extract major version from string: " + version);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String version = this.getDatabaseProductVersion();
        try {
            String[] parts = version.split("\\.");
            if (parts.length >= 2) {
                return Integer.parseInt(parts[1]);
            }
            System.err.println("WARNING: cannot extract minor version from string: " + version);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getSQLStateType() {
        return 1;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return null;
    }

    @Override
    public ResultSet getSchemas(String catalogName, String schemaPattern) throws SQLAlreadyClosedException {
        List<String> mongoDbs = this.con.getService().getDatabaseNames();
        ListResultSet retVal = new ListResultSet();
        MongoNamePattern p = MongoNamePattern.create(schemaPattern);
        retVal.setColumnNames("TABLE_SCHEM", "TABLE_CATALOG");
        for (String mongoDb : mongoDbs) {
            if (!p.matches(mongoDb)) continue;
            retVal.addRow(new String[]{mongoDb, DB_NAME});
        }
        return retVal;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalogName, String schemaPattern, String functionNamePattern) {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalogName, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        return null;
    }

    @Override
    public ResultSet getPseudoColumns(String catalogName, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }
}

