/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoNamePattern {
    private static final Set<Character> SPECIAL_REGEX_CHARS = new HashSet<Character>();
    private final String plain;
    private final Pattern pattern;

    private MongoNamePattern() {
        this.plain = null;
        this.pattern = null;
    }

    private MongoNamePattern(@NotNull Pattern pattern) {
        this.plain = null;
        this.pattern = pattern;
    }

    private MongoNamePattern(@NotNull String plain) {
        this.plain = plain;
        this.pattern = null;
    }

    @Nullable
    public String asPlain() {
        return this.plain;
    }

    public boolean matches(@NotNull String name) {
        return this.plain != null ? this.plain.equals(name) : this.pattern == null || this.pattern.matcher(name).matches();
    }

    @NotNull
    public static MongoNamePattern create(String inputPattern) throws IllegalArgumentException {
        if (inputPattern == null) {
            return new MongoNamePattern();
        }
        String plain = MongoNamePattern.toPlain(inputPattern);
        if (plain != null) {
            return new MongoNamePattern(plain);
        }
        boolean escaped = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < inputPattern.length(); ++i) {
            char c = inputPattern.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    sb.append("\\\\");
                }
                escaped = !escaped;
                continue;
            }
            if (escaped) {
                escaped = false;
                if (c == '_' || c == '%') {
                    sb.append(c);
                    continue;
                }
                throw new IllegalArgumentException("Illegal char escape " + c + " at position " + i + " string: " + inputPattern);
            }
            if (c == '_') {
                sb.append(".");
                continue;
            }
            if (c == '%') {
                sb.append(".*");
                continue;
            }
            if (SPECIAL_REGEX_CHARS.contains(Character.valueOf(c))) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        String pattern = sb.toString();
        return pattern.equals(".*") ? new MongoNamePattern() : new MongoNamePattern(Pattern.compile(pattern));
    }

    @Nullable
    private static String toPlain(@NotNull String inputPattern) {
        boolean escaped = false;
        StringBuilder plain = new StringBuilder();
        for (int i = 0; i < inputPattern.length(); ++i) {
            char c = inputPattern.charAt(i);
            if (c == '\\') {
                if (escaped) {
                    plain.append("\\");
                }
                escaped = !escaped;
                continue;
            }
            if (escaped) {
                escaped = false;
                if (c == '_') {
                    plain.append("_");
                    continue;
                }
                if (c == '%') {
                    plain.append("%");
                    continue;
                }
                throw new IllegalArgumentException("Illegal char escape " + c + " at position " + i + " string: " + inputPattern);
            }
            if (c == '_' || c == '%') {
                return null;
            }
            plain.append(c);
        }
        return plain.toString();
    }

    static {
        SPECIAL_REGEX_CHARS.add(Character.valueOf('['));
        SPECIAL_REGEX_CHARS.add(Character.valueOf(']'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('{'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('}'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('('));
        SPECIAL_REGEX_CHARS.add(Character.valueOf(')'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('\\'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('.'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('*'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('+'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('?'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('^'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('$'));
        SPECIAL_REGEX_CHARS.add(Character.valueOf('|'));
    }
}

