/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.MongoNamePattern;
import com.dbschema.mongo.SQLAlreadyClosedException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReplaceOptions;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.intellij.lang.annotations.Language;

public class MongoPreparedStatement
implements PreparedStatement {
    private final MongoConnection connection;
    protected ResultSet lastResultSet;
    private boolean isClosed = false;
    private int maxRows = -1;
    @Language(value="js")
    private final String query;
    private int fetchSize = -1;
    private Document documentParam;
    private static final Pattern PATTERN_UPDATE = Pattern.compile("UPDATE\\s+(.*)", 2);
    private static final Pattern PATTERN_DELETE = Pattern.compile("DELETE\\s+FROM\\s+(.*)", 2);
    private static final String ERROR_MESSAGE = "Allowed statements: update(<dbname>.<collectionName>) or delete(<dbname>.<collectionName>). Before calling this do setObject(0,<dbobject>).";
    private static final Pattern PATTERN_DB_IDENTIFIER = Pattern.compile("client\\.getDatabase\\('(.*)'\\).(.*)", 34);
    private static final Pattern PATTERN_COLLECTION_IDENTIFIER = Pattern.compile("getCollection\\('(.*)'\\).(.*)", 34);
    private static final Pattern PATTERN_DOT = Pattern.compile("(.*)\\.(.*)", 34);

    public MongoPreparedStatement(MongoConnection connection) {
        this.connection = connection;
        this.query = null;
    }

    public MongoPreparedStatement(MongoConnection connection, @Language(value="js") String query) {
        this.connection = connection;
        this.query = query;
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return false;
    }

    @Override
    public ResultSet executeQuery(@Language(value="js") String query) throws SQLException {
        this.checkClosed();
        if (this.lastResultSet != null && !this.lastResultSet.isClosed()) {
            this.lastResultSet.close();
        }
        if (query == null) {
            throw new SQLException("Null statement.");
        }
        return this.doExecuteQuery(query, this.fetchSize);
    }

    protected ResultSet doExecuteQuery(String query, int fetchSize) throws SQLException {
        this.lastResultSet = this.connection.getScriptEngine().execute(query, fetchSize);
        return this.lastResultSet;
    }

    @Override
    public boolean execute(@Language(value="js") String query) throws SQLException {
        this.executeQuery(query);
        return this.lastResultSet != null;
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x instanceof Document) {
            this.documentParam = (Document)x;
        } else if (x instanceof Map) {
            this.documentParam = new Document((Map)x);
        } else {
            if (x != null) {
                throw new SQLException("Map object expected. You currently did setObject( " + x.getClass().getName() + " ) ");
            }
            throw new SQLException("Map object expected. You currently did setObject( NULL ) ");
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.executeUpdate(this.query);
    }

    private MongoDatabase getDatabase(String name) throws SQLAlreadyClosedException {
        for (MongoDatabase scan : this.connection.getService().getDatabases(MongoNamePattern.create(null))) {
            if (!scan.getName().equalsIgnoreCase(name)) continue;
            return scan;
        }
        if ("db".equals(name) && this.connection.getSchema() != null) {
            for (MongoDatabase scan : this.connection.getService().getDatabases()) {
                if (!scan.getName().equalsIgnoreCase(this.connection.getSchema())) continue;
                return scan;
            }
        }
        return null;
    }

    @Override
    public int executeUpdate(@Language(value="js") String sql) throws SQLException {
        if (sql != null) {
            if (this.documentParam == null) {
                this.execute(sql);
                return 1;
            }
            sql = sql.trim();
            Matcher matcher = PATTERN_UPDATE.matcher(sql);
            Object id = this.documentParam.get("_id");
            if (matcher.matches()) {
                MongoCollection<Document> collection = this.getCollectionMandatory(matcher.group(1));
                if (id == null) {
                    collection.insertOne(this.documentParam);
                } else {
                    collection.replaceOne(new Document("_id", id), this.documentParam, new ReplaceOptions().upsert(true));
                }
                return 1;
            }
            matcher = PATTERN_DELETE.matcher(sql);
            if (matcher.matches()) {
                MongoCollection<Document> collection = this.getCollectionMandatory(matcher.group(1));
                Document m = new Document("_id", id);
                collection.deleteOne(m);
                return 1;
            }
        }
        throw new SQLException(ERROR_MESSAGE);
    }

    protected MongoCollection<Document> getCollectionMandatory(String collectionRef) throws SQLException {
        MongoDatabase mongoDatabase = null;
        Matcher matcherDbIdentifier = PATTERN_DB_IDENTIFIER.matcher(collectionRef);
        Matcher matcherDbDot = PATTERN_DOT.matcher(collectionRef);
        if (matcherDbIdentifier.matches()) {
            mongoDatabase = this.getDatabase(matcherDbIdentifier.group(1));
            collectionRef = matcherDbIdentifier.group(2);
        } else if (matcherDbDot.matches()) {
            mongoDatabase = this.getDatabase(matcherDbDot.group(1));
            collectionRef = matcherDbDot.group(2);
        }
        if (mongoDatabase == null) {
            throw new SQLException("Cannot find database '" + collectionRef + "'.");
        }
        Matcher matcherCollectionIdentifier = PATTERN_COLLECTION_IDENTIFIER.matcher(collectionRef);
        if (matcherCollectionIdentifier.matches()) {
            collectionRef = matcherDbIdentifier.group(1);
        }
        return mongoDatabase.getCollection(collectionRef);
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
        if (this.lastResultSet == null || this.lastResultSet.isClosed()) {
            return;
        }
        this.lastResultSet.close();
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for query timeouts.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for query timeouts.");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for interrupting an operation.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.lastResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return -1;
    }

    @Override
    public boolean getMoreResults() {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows <= 1) {
            throw new SQLException("Fetch size must be > 1. Actual: " + rows);
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() {
        return 1003;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    private void checkClosed() throws SQLAlreadyClosedException {
        if (this.isClosed) {
            throw new SQLAlreadyClosedException(this.getClass().getSimpleName());
        }
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute(this.query);
        return this.lastResultSet;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) {
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
    }

    @Override
    public void setByte(int parameterIndex, byte x) {
    }

    @Override
    public void setShort(int parameterIndex, short x) {
    }

    @Override
    public void setInt(int parameterIndex, int x) {
    }

    @Override
    public void setLong(int parameterIndex, long x) {
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) {
    }

    @Override
    public void setString(int parameterIndex, String x) {
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) {
    }

    @Override
    public void setDate(int parameterIndex, Date x) {
    }

    @Override
    public void setTime(int parameterIndex, Time x) {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) {
    }

    @Override
    public void clearParameters() {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) {
    }

    @Override
    public boolean execute() throws SQLException {
        return this.query != null && this.execute(this.query);
    }

    @Override
    public void addBatch() {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) {
    }

    @Override
    public void setArray(int parameterIndex, Array x) {
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) {
    }

    @Override
    public void setURL(int parameterIndex, URL x) {
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) {
    }

    @Override
    public void setNString(int parameterIndex, String value) {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) {
    }
}

