/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.MongoClientWrapper;
import com.dbschema.mongo.MongoNamePattern;
import com.dbschema.mongo.SQLAlreadyClosedException;
import com.dbschema.mongo.schema.MetaCollection;
import com.mongodb.MongoSecurityException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoService
implements AutoCloseable {
    private boolean isClosed = false;
    private final MongoClientWrapper client;
    private final String uri;
    private final int fetchDocumentsForMeta;
    public static final List<String> createdDatabases = new ArrayList<String>();

    public MongoService(@NotNull String uri, @NotNull Properties prop, @Nullable String username, @Nullable String password, int fetchDocumentsForMeta) throws SQLException {
        this.uri = uri;
        this.fetchDocumentsForMeta = fetchDocumentsForMeta;
        this.client = new MongoClientWrapper(uri, prop, username, password);
    }

    public MongoClientWrapper getClient() {
        return this.client;
    }

    @Override
    public void close() throws SQLAlreadyClosedException {
        this.checkClosed();
        this.isClosed = true;
        this.client.close();
    }

    private void checkClosed() throws SQLAlreadyClosedException {
        if (this.isClosed) {
            throw new SQLAlreadyClosedException(this.getClass().getSimpleName());
        }
    }

    public String getDatabaseNameFromUrl() throws SQLAlreadyClosedException {
        this.checkClosed();
        return this.client.databaseNameFromUrl != null ? this.client.databaseNameFromUrl : "test";
    }

    public List<String> getDatabaseNames() throws SQLAlreadyClosedException {
        this.checkClosed();
        ArrayList<String> names = new ArrayList<String>();
        try {
            for (String c : this.client.listDatabaseNames()) {
                names.add(c);
            }
        }
        catch (Throwable ex) {
            names.add(this.getDatabaseNameFromUrl());
        }
        for (String str : createdDatabases) {
            if (names.contains(str)) continue;
            names.add(str);
        }
        return names;
    }

    public MongoDatabase getDatabase(String dbName) throws SQLAlreadyClosedException {
        this.checkClosed();
        return this.client.getDatabase(dbName);
    }

    @NotNull
    public List<MongoDatabase> getDatabases(MongoNamePattern dbName) throws SQLAlreadyClosedException {
        this.checkClosed();
        String plain = dbName.asPlain();
        if (plain != null) {
            return Collections.singletonList(this.client.getDatabase(plain));
        }
        ArrayList<MongoDatabase> databases = new ArrayList<MongoDatabase>();
        for (String databaseName : this.client.getMongoClient().listDatabaseNames()) {
            if (!dbName.matches(databaseName)) continue;
            databases.add(this.client.getMongoClient().getDatabase(databaseName));
        }
        return databases;
    }

    public List<MongoDatabase> getDatabases() throws SQLAlreadyClosedException {
        ArrayList<MongoDatabase> list = new ArrayList<MongoDatabase>();
        for (String dbName : this.getDatabaseNames()) {
            list.add(this.getDatabase(dbName));
        }
        return list;
    }

    @NotNull
    public String getVersion() throws SQLException {
        this.checkClosed();
        MongoDatabase db = this.client.getDatabase("test");
        try {
            Document info = db.runCommand(new Document("buildInfo", 1));
            String version = info.getString("version");
            return version == null ? "UNKNOWN" : version;
        }
        catch (MongoSecurityException e) {
            throw new SQLException(e);
        }
    }

    @NotNull
    public List<MetaCollection> getMetaCollections(@Nullable String databasePattern, @Nullable String collectionPattern) throws SQLAlreadyClosedException {
        MongoNamePattern collectionName = MongoNamePattern.create(collectionPattern);
        List<MongoDatabase> databases = this.getDatabases(MongoNamePattern.create(databasePattern));
        ArrayList<MetaCollection> collections = new ArrayList<MetaCollection>();
        for (MongoDatabase database : databases) {
            try {
                String plainCollectionName = collectionName.asPlain();
                if (plainCollectionName != null) {
                    MongoCollection<Document> collection = database.getCollection(plainCollectionName);
                    collections.add(new MetaCollection(collection, this.fetchDocumentsForMeta));
                    continue;
                }
                for (String name : database.listCollectionNames()) {
                    if (!collectionName.matches(name)) continue;
                    MongoCollection<Document> collection = database.getCollection(name);
                    collections.add(new MetaCollection(collection, this.fetchDocumentsForMeta));
                }
            }
            catch (Throwable ex) {
                System.err.println("Error discovering collection " + database + " " + collectionName + ". " + ex);
                ex.printStackTrace();
            }
        }
        return collections;
    }

    public String getURI() {
        return this.uri;
    }

    public List<String> getCollectionNames(String catalog) throws SQLAlreadyClosedException {
        this.checkClosed();
        ArrayList<String> list = new ArrayList<String>();
        try {
            MongoDatabase db = this.client.getDatabase(catalog);
            if (db != null) {
                for (String str : db.listCollectionNames()) {
                    list.add(str);
                }
            }
            list.remove("system.indexes");
            list.remove("system.users");
            list.remove("system.version");
        }
        catch (Throwable ex) {
            System.err.println("Cannot list collection names for " + catalog + ". " + ex);
        }
        return list;
    }

    public String toString() {
        return this.client.toString();
    }

    public MongoClient getMongoClient() {
        return this.client.getMongoClient();
    }
}

