/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    public static SSLContext getTrustEverybodySSLContext(String clientCertificateKeyStoreUrl, String clientCertificateKeyStoreType, String clientCertificateKeyStorePassword) throws SSLParamsException {
        KeyManagerFactory kmf;
        KeyManager[] kms = null;
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLParamsException("Default algorithm definitions for TrustManager and/or KeyManager are invalid.  Check java security properties file.", nsae);
        }
        if (!Util.isNullOrEmpty(clientCertificateKeyStoreUrl)) {
            InputStream ksIS = null;
            try {
                if (!Util.isNullOrEmpty(clientCertificateKeyStoreType)) {
                    KeyStore clientKeyStore = KeyStore.getInstance(clientCertificateKeyStoreType);
                    URL ksURL = new URL(clientCertificateKeyStoreUrl);
                    char[] password = clientCertificateKeyStorePassword == null ? new char[]{} : clientCertificateKeyStorePassword.toCharArray();
                    ksIS = ksURL.openStream();
                    clientKeyStore.load(ksIS, password);
                    kmf.init(clientKeyStore, password);
                    kms = kmf.getKeyManagers();
                }
            }
            catch (UnrecoverableKeyException uke) {
                throw new SSLParamsException("Could not recover keys from client keystore.  Check password?", uke);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SSLParamsException("Unsupported keystore algorithm [" + nsae.getMessage() + "]", nsae);
            }
            catch (KeyStoreException kse) {
                throw new SSLParamsException("Could not create KeyStore instance [" + kse.getMessage() + "]", kse);
            }
            catch (CertificateException nsae) {
                throw new SSLParamsException("Could not load client" + clientCertificateKeyStoreType + " keystore from " + clientCertificateKeyStoreUrl, nsae);
            }
            catch (MalformedURLException mue) {
                throw new SSLParamsException(clientCertificateKeyStoreUrl + " does not appear to be a valid URL.", mue);
            }
            catch (IOException ioe) {
                throw new SSLParamsException("Cannot open " + clientCertificateKeyStoreUrl + " [" + ioe.getMessage() + "]", ioe);
            }
            finally {
                if (ksIS != null) {
                    try {
                        ksIS.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, new TrustManager[]{new MyTrustEverybodyManager()}, null);
            return sslContext;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SSLParamsException("TLS is not a valid SSL protocol.", nsae);
        }
        catch (KeyManagementException kme) {
            throw new SSLParamsException("KeyManagementException: " + kme.getMessage(), kme);
        }
    }

    public static class SSLParamsException
    extends SQLException {
        public SSLParamsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class MyTrustEverybodyManager
    implements X509TrustManager {
        private MyTrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

