/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo;

import com.dbschema.mongo.Condition;
import com.dbschema.mongo.resultSet.ListResultSet;
import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoClientSettings;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import kotlin.Pair;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    private static final String MONGODB_PREFIX = "mongodb://";
    private static final String MONGODB_SRV_PREFIX = "mongodb+srv://";
    static BitSet dontNeedEncoding;

    public static String nullize(String text) {
        return text == null || text.isEmpty() ? null : text;
    }

    public static ResultSet ok() {
        return new ListResultSet("OK", new String[]{"result"});
    }

    /*
     * Exception decompiling
     */
    public static ResultSet ok(Object result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResultSet ok(Map<?, ?> result2) {
        return new ListResultSet(result2, new String[]{"map"});
    }

    public static ResultSet error() {
        return new ListResultSet("ERROR", new String[]{"result"});
    }

    @Contract(pure=true)
    public static <T> T find(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        return Util.find(iterable.iterator(), condition);
    }

    public static <T> T find(@NotNull Iterator<? extends T> iterator2, @NotNull Condition<? super T> condition) {
        while (iterator2.hasNext()) {
            T value = iterator2.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        for (T value : array) {
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] filter(@NotNull T[] collection, @NotNull Condition<? super T> condition, @NotNull Class<? extends T[]> type) {
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        return Arrays.copyOf(result2.toArray(), result2.size(), type);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, R> R[] map(@NotNull T[] collection, @NotNull Function<? super T, R> func, @NotNull Class<? extends R[]> newType) {
        ArrayList<R> result2 = new ArrayList<R>();
        for (T t : collection) {
            result2.add(func.apply(t));
        }
        return Arrays.copyOf(result2.toArray(), result2.size(), newType);
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static Document toDocument(@Nullable BsonDocument bson) {
        return bson == null ? null : (Document)MongoClientSettings.getDefaultCodecRegistry().get(Document.class).decode(bson.asBsonReader(), DecoderContext.builder().build());
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static Object decode(@Nullable BsonValue bson) {
        return bson == null ? null : ((Document)MongoClientSettings.getDefaultCodecRegistry().get(Document.class).decode(new BsonDocument("v", bson).asBsonReader(), DecoderContext.builder().build())).get("v");
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T> T tryCast(@Nullable Object obj, @NotNull Class<T> clazz) {
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        return null;
    }

    @Contract(pure=true)
    public static <T> boolean all(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, Boolean> predicate) {
        for (T v : collection) {
            if (predicate.apply(v).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapping.apply(t));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping) {
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = new ArrayList(collection.size());
        for (T t : collection) {
            V o = mapping.apply(t);
            if (o == null) continue;
            result2.add(o);
        }
        return result2.isEmpty() ? Collections.emptyList() : result2;
    }

    @NotNull
    public static String insertCredentials(@NotNull String uri, @Nullable String username, @Nullable String password) {
        return Util.insertCredentials(uri, username, password, true);
    }

    @NotNull
    public static String insertAuthMechanism(@NotNull String uri, @Nullable String authMechanism) {
        AuthenticationMechanism mechanism;
        if (authMechanism == null) {
            return uri;
        }
        try {
            mechanism = AuthenticationMechanism.fromMechanismName(authMechanism);
        }
        catch (IllegalArgumentException ignored) {
            return uri;
        }
        return Util.insertUrlParameter(uri, "authMechanism", mechanism.getMechanismName());
    }

    @NotNull
    public static String insertRetryWrites(@NotNull String uri, @Nullable String retryWrites) {
        if (retryWrites == null) {
            return uri;
        }
        String lowercase = retryWrites.toLowerCase(Locale.ENGLISH);
        return lowercase.equals("true") || lowercase.equals("false") ? Util.insertUrlParameter(uri, "retryWrites", retryWrites) : uri;
    }

    @NotNull
    public static String insertAuthSource(@NotNull String uri, @Nullable String source) {
        return Util.insertUrlParameter(uri, "authSource", source);
    }

    @NotNull
    public static String insertUrlParameter(@NotNull String uri, @NotNull String key, @Nullable String value) {
        if (value == null || value.isEmpty()) {
            return uri;
        }
        Pair<String, String> pair = Util.splitPrefix(uri);
        String prefix = pair.getFirst();
        String uriWithoutPrefix = pair.getSecond();
        Pair<String, String> pair2 = Util.splitUriAndParameters(uriWithoutPrefix);
        String uriWithoutParameters = pair2.getFirst();
        Object parameters = pair2.getSecond();
        if (!((String)parameters).contains(key)) {
            parameters = ((String)parameters).isEmpty() || ((String)parameters).endsWith("&") ? parameters : (String)parameters + "&";
            parameters = (String)parameters + key + "=" + value;
        }
        return prefix + uriWithoutParameters + (String)parameters;
    }

    @NotNull
    private static Pair<String, String> splitUriAndParameters(@NotNull String uriWithoutPrefix) {
        Object uriWithoutParameters;
        int idx = uriWithoutPrefix.indexOf("?");
        Object object = uriWithoutParameters = idx == -1 ? uriWithoutPrefix : uriWithoutPrefix.substring(0, idx + 1);
        if (!((String)uriWithoutParameters).endsWith("?")) {
            uriWithoutParameters = (String)uriWithoutParameters + (((String)uriWithoutParameters).contains("/") ? "?" : "/?");
        }
        String parameters = idx == -1 ? "" : uriWithoutPrefix.substring(idx + 1);
        return new Pair<Object, String>(uriWithoutParameters, parameters);
    }

    @NotNull
    public static String insertAuthProperty(@NotNull String uri, @NotNull String name, @Nullable String value) {
        if (value == null || value.isEmpty()) {
            return uri;
        }
        Pair<String, String> pair = Util.splitPrefix(uri);
        String prefix = pair.getFirst();
        String uriWithoutPrefix = pair.getSecond();
        Pair<String, String> pair2 = Util.splitUriAndParameters(uriWithoutPrefix);
        String uriWithoutParameters = pair2.getFirst();
        String parameters = pair2.getSecond();
        String key = "authMechanismProperties=";
        String keyAndValue = Util.find(parameters.split("&"), (? super T param) -> param.startsWith(key));
        Object mechanismProperties = keyAndValue == null ? "" : keyAndValue.split("=")[1];
        String parametersWithoutProperties = String.join((CharSequence)"&", Util.filter(parameters.split("&"), param -> !param.isEmpty() && !param.startsWith(key), String[].class));
        mechanismProperties = ((String)mechanismProperties).isEmpty() ? name + ":" + value : (((String)mechanismProperties).contains(name) ? mechanismProperties : (String)mechanismProperties + (((String)mechanismProperties).endsWith(",") ? "" : ",") + name + ":" + value);
        return prefix + uriWithoutParameters + parametersWithoutProperties + (parametersWithoutProperties.isEmpty() ? "" : "&") + key + (String)mechanismProperties;
    }

    @NotNull
    public static String insertCredentials(@NotNull String uri, @Nullable String username, @Nullable String password, boolean automaticEncoding) {
        String userAndHostInformation;
        if (username == null) {
            if (password != null) {
                System.err.println("WARNING: Password is ignored because username is not specified");
            }
            return uri;
        }
        Pair<String, String> pair = Util.splitPrefix(uri);
        String prefix = pair.getFirst();
        String uriWithoutPrefix = pair.getSecond();
        int idx = uriWithoutPrefix.indexOf("/");
        String string = userAndHostInformation = idx == -1 ? uriWithoutPrefix : uriWithoutPrefix.substring(0, idx);
        if (userAndHostInformation.contains("@")) {
            return uri;
        }
        String passwordPart = password == null ? "" : ":" + Util.encode(password, automaticEncoding, "password");
        return prefix + Util.encode(username, automaticEncoding, "username") + passwordPart + "@" + uriWithoutPrefix;
    }

    private static Pair<String, String> splitPrefix(@NotNull String uri) {
        boolean jdbc = false;
        if (uri.startsWith("jdbc:")) {
            jdbc = true;
            uri = uri.substring("jdbc:".length());
        }
        if (uri.startsWith(MONGODB_SRV_PREFIX)) {
            return new Pair<CallSite, String>((CallSite)((Object)((jdbc ? "jdbc:" : "") + MONGODB_SRV_PREFIX)), uri.substring(MONGODB_SRV_PREFIX.length()));
        }
        if (uri.startsWith(MONGODB_PREFIX)) {
            return new Pair<CallSite, String>((CallSite)((Object)((jdbc ? "jdbc:" : "") + MONGODB_PREFIX)), uri.substring(MONGODB_PREFIX.length()));
        }
        throw new IllegalArgumentException("No valid prefix in uri: " + uri);
    }

    private static String encode(String text, boolean automaticEncoding, String what) {
        if (!automaticEncoding) {
            return text;
        }
        boolean shouldEncode = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (dontNeedEncoding.get(c) || c == '%' && i + 2 < text.length() && Util.isEncodedCharId(text.charAt(i + 1)) && Util.isEncodedCharId(text.charAt(i + 2))) continue;
            shouldEncode = true;
            break;
        }
        if (!shouldEncode) {
            return text;
        }
        System.err.println("WARNING: " + what + " was automatically url-encoded. To turn it off set auto_encode_username_and_password driver property to false.");
        try {
            return URLEncoder.encode(text, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return text;
        }
    }

    private static boolean isEncodedCharId(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @NotNull
    public static String trimEnd(@NotNull String str, char end) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == end; --i) {
        }
        return str.substring(0, i + 1);
    }

    public static boolean isTrue(@Nullable String value) {
        return value != null && (value.equals("1") || value.toLowerCase(Locale.ENGLISH).equals("true"));
    }

    public static boolean isNullOrEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    @NotNull
    public static String escapeChars(@NotNull String str, char ... character) {
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            Util.escapeChar(buf, c);
        }
        return buf.toString();
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        int idx = 0;
        while ((idx = Util.indexOf(buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        return Util.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        end = Math.min(end, s.length());
        for (int i = Math.max(start, 0); i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(@NonNls @NotNull String name) {
        return r -> {
            Thread thread2 = new Thread(r, name);
            thread2.setDaemon(true);
            return thread2;
        };
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

