/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.dbvis;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.MongoPreparedStatement;
import com.dbschema.mongo.resultSet.ListResultSet;
import com.dbschema.mongo.resultSet.ResultSetIterator;
import com.mongodb.client.MongoCollection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.bson.Document;

public class DbVisMongoPreparedStatement
extends MongoPreparedStatement {
    public DbVisMongoPreparedStatement(MongoConnection connection) {
        super(connection);
    }

    public DbVisMongoPreparedStatement(MongoConnection connection, String query) {
        super(connection, query);
    }

    @Override
    protected ResultSet doExecuteQuery(String query, int fetchSize) throws SQLException {
        QueryCommand command = this.parseQuery(query);
        if (command != null) {
            if (command.command == Command.GET_COLLECTION) {
                MongoCollection<Document> mongoCollection = this.getCollectionMandatory(command.collection);
                Iterator cursor = mongoCollection.find().iterator();
                ResultSetIterator iterator2 = new ResultSetIterator(cursor);
                this.lastResultSet = iterator2;
                return this.lastResultSet;
            }
            if (command.command == Command.COUNT_DOCUMENTS) {
                ListResultSet listResultSet = new ListResultSet();
                listResultSet.setColumnNames("Count");
                listResultSet.addRow(new Long[]{this.getCollectionMandatory(command.collection).countDocuments()});
                this.lastResultSet = listResultSet;
                return this.lastResultSet;
            }
        }
        return super.doExecuteQuery(query, fetchSize);
    }

    private QueryCommand parseQuery(String query) {
        if (query.startsWith("@db.getCollection")) {
            Command command = Command.GET_COLLECTION;
            if (query.endsWith(".countDocuments()")) {
                command = Command.COUNT_DOCUMENTS;
            }
            int p1 = query.indexOf("(");
            int p2 = query.indexOf(")", p1);
            query = query.substring(p1 + 1, p2);
            query = query.replaceAll("\"", "");
            return new QueryCommand(query, command);
        }
        return null;
    }

    static class QueryCommand {
        String collection;
        Command command;

        QueryCommand(String collection, Command command) {
            this.collection = collection;
            this.command = command;
        }
    }

    static enum Command {
        GET_COLLECTION,
        COUNT_DOCUMENTS;

    }
}

