/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.mongosh;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.mongosh.ShellHolder;
import com.mongodb.mongosh.MongoShell;
import org.jetbrains.annotations.NotNull;

public class LazyShellHolder
implements ShellHolder {
    private MongoShell shell;

    @Override
    @NotNull
    public synchronized MongoShell getShell(@NotNull MongoConnection connection) {
        if (this.shell == null) {
            System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
            this.shell = new MongoShell(connection.getService().getMongoClient(), null);
            this.shell.eval("use " + connection.getSchema());
        }
        return this.shell;
    }

    @Override
    public synchronized void recreateShell() {
        if (this.shell == null) {
            return;
        }
        this.shell.close();
        this.shell = null;
    }

    @Override
    public synchronized void close() {
        if (this.shell != null) {
            this.shell.close();
        }
    }
}

