/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.mongosh;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.MongoScriptEngine;
import com.dbschema.mongo.Util;
import com.dbschema.mongo.mongosh.ShellHolder;
import com.dbschema.mongo.resultSet.ResultSetIterator;
import com.mongodb.mongosh.MongoShell;
import com.mongodb.mongosh.result.BulkWriteResult;
import com.mongodb.mongosh.result.CursorResult;
import com.mongodb.mongosh.result.FindCursor;
import com.mongodb.mongosh.result.InsertManyResult;
import com.mongodb.mongosh.result.InsertOneResult;
import com.mongodb.mongosh.result.MongoShellResult;
import com.mongodb.mongosh.result.MongoShellUpdateResult;
import com.mongodb.mongosh.result.StringResult;
import com.mongodb.mongosh.result.VoidResult;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoshScriptEngine
implements MongoScriptEngine {
    private static final Pattern USE_DATABASE = Pattern.compile("use\\s+(.*)", 2);
    private static final Pattern CLEAR_CONTEXT = Pattern.compile("clearContext\\s*\\(\\s*\\)\\s*;?");
    private final MongoConnection connection;
    private final ShellHolder shellHolder;

    public MongoshScriptEngine(@NotNull MongoConnection connection, @NotNull ShellHolder holder) {
        this.connection = connection;
        this.shellHolder = holder;
    }

    @Override
    @Nullable
    public ResultSet execute(@Language(value="js") @NotNull String query, int fetchSize) throws SQLException {
        try {
            MongoShell repl;
            MongoShellResult<?> result2;
            if (CLEAR_CONTEXT.matcher(((String)query).trim()).matches()) {
                this.shellHolder.recreateShell();
                return null;
            }
            Matcher useCommand = USE_DATABASE.matcher(Util.trimEnd(((String)query).trim(), ';').trim());
            if (useCommand.matches()) {
                String db = useCommand.group(1);
                if (db.startsWith("\"") && db.endsWith("\"") || db.startsWith("'") && db.endsWith("'")) {
                    db = db.substring(1, db.length() - 1);
                }
                query = "use " + db.trim();
            }
            if ((result2 = (repl = this.shellHolder.getShell(this.connection)).eval((String)query)) instanceof CursorResult) {
                Object cursor = ((CursorResult)result2).getValue();
                if (fetchSize > 1 && cursor instanceof FindCursor) {
                    ((FindCursor)cursor).batchSize(fetchSize);
                }
                return new ResultSetIterator((Iterator<?>)cursor);
            }
            MongoShellResult<?> db = this.shellHolder.getShell(this.connection).eval("db");
            if (db instanceof StringResult) {
                this.connection.setSchema(((StringResult)db).getValue());
            }
            return result2 instanceof VoidResult || result2 instanceof BulkWriteResult || result2 instanceof InsertOneResult || result2 instanceof InsertManyResult || result2 instanceof MongoShellUpdateResult ? null : Util.ok(result2.getValue());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() {
        this.shellHolder.close();
    }
}

