/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.mongosh;

import com.dbschema.mongo.MongoConnection;
import com.dbschema.mongo.mongosh.ShellHolder;
import com.mongodb.mongosh.MongoShell;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.graalvm.polyglot.Engine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrecalculatingShellHolder
implements ShellHolder {
    private final ExecutorService executorService;
    private final Engine engine;
    @NotNull
    private Future<MongoShell> shellFuture;
    @Nullable
    private MongoShell shell;

    public PrecalculatingShellHolder(@NotNull ExecutorService executorService, @Nullable Engine engine) {
        this.executorService = executorService;
        this.engine = engine;
        this.shellFuture = this.submitNewShell();
    }

    @NotNull
    private Future<MongoShell> submitNewShell() {
        return this.executorService.submit(() -> {
            System.setProperty("polyglot.engine.WarnInterpreterOnly", "false");
            MongoShell shell = new MongoShell(null, this.engine);
            shell.eval("'initial warm up'");
            return shell;
        });
    }

    @Override
    @NotNull
    public synchronized MongoShell getShell(@NotNull MongoConnection connection) throws SQLException {
        if (this.shell == null) {
            try {
                this.shell = this.shellFuture.get();
                this.shell.setClient(connection.getService().getMongoClient());
                this.shell.eval("use " + connection.getSchema());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SQLException(e);
            }
        }
        return this.shell;
    }

    @Override
    public synchronized void recreateShell() {
        if (this.shell == null) {
            return;
        }
        this.shell.close();
        this.shell = null;
        this.shellFuture = this.submitNewShell();
    }

    @Override
    public synchronized void close() {
        try {
            if (!this.shellFuture.isDone()) {
                this.shellFuture.cancel(true);
            }
        }
        finally {
            if (this.shell != null) {
                this.shell.close();
            }
        }
    }
}

