/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.schema;

import com.dbschema.mongo.schema.MetaField;
import com.dbschema.mongo.schema.MetaIndex;
import com.dbschema.mongo.schema.MetaJson;
import com.mongodb.MongoQueryException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class MetaCollection
extends MetaJson {
    private boolean isFirstDiscover = true;
    public final String db;
    public final List<MetaIndex> metaIndexes = new ArrayList<MetaIndex>();
    private static final String KEY_NAME = "name";
    private static final String KEY_UNIQUE = "unique";
    private static final String KEY_KEY = "key";

    public MetaCollection(MongoCollection<?> mongoCollection, int fetchDocumentsForMeta) {
        super(null, mongoCollection.getNamespace().getCollectionName(), 4999544);
        this.db = mongoCollection.getNamespace().getDatabaseName();
        this.discoverCollectionFirstRecords(mongoCollection, fetchDocumentsForMeta);
        this.discoverIndexes(mongoCollection);
    }

    public MetaIndex createMetaIndex(String name, boolean pk, boolean unique) {
        MetaIndex index = new MetaIndex(this, name, "_id_".endsWith(name), false);
        this.metaIndexes.add(index);
        return index;
    }

    private void discoverCollectionFirstRecords(MongoCollection<?> mongoCollection, int iterations) {
        try (Iterator cursor = mongoCollection.find().iterator();){
            int iteration = 0;
            while (cursor.hasNext() && ++iteration <= iterations) {
                this.discoverMap(this, cursor.next());
            }
        }
        catch (MongoQueryException e) {
            if (e.getErrorCode() == 13) {
                return;
            }
            throw e;
        }
    }

    private void discoverCollectionRandomRecords(MongoCollection<Document> mongoCollection, int iterations) {
        int skip = 10;
        int i = 0;
        FindIterable<Document> jFindIterable = mongoCollection.find();
        while (i++ < iterations) {
            Iterator crs = jFindIterable.iterator();
            while (i++ < iterations && crs.hasNext()) {
                this.discoverMap(this, crs.next());
            }
            jFindIterable = jFindIterable.skip(skip);
            skip *= 2;
        }
    }

    private void discoverMap(MetaJson parentMap, Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                String type;
                Object value = map.get(key);
                String string = type = value != null ? value.getClass().getName() : "String";
                if (type.lastIndexOf(46) > 0) {
                    type = type.substring(type.lastIndexOf(46) + 1);
                }
                if (value instanceof Map) {
                    MetaJson childrenMap = parentMap.createJsonMapField(key.toString(), this.isFirstDiscover);
                    this.discoverMap(childrenMap, value);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.isEmpty() || this.isListOfDocuments(value)) {
                        MetaJson subDocument = parentMap.createJsonListField(key.toString(), this.isFirstDiscover);
                        for (Object child : (List)value) {
                            this.discoverMap(subDocument, child);
                        }
                        continue;
                    }
                    parentMap.createField((String)key, "array", 2003, this.isFirstDiscover);
                    continue;
                }
                parentMap.createField((String)key, type, this.getJavaType(value), this.isFirstDiscover);
            }
            for (MetaField field : parentMap.fields) {
                if (map.containsKey(field.name)) continue;
                field.setMandatory(false);
            }
        }
        this.isFirstDiscover = false;
    }

    public int getJavaType(Object value) {
        if (value instanceof Integer) {
            return 4;
        }
        if (value instanceof Timestamp) {
            return 93;
        }
        if (value instanceof Date) {
            return 91;
        }
        if (value instanceof Double) {
            return 8;
        }
        return 12;
    }

    private boolean isListOfDocuments(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object val : list) {
                if (val instanceof Map) continue;
                return false;
            }
            return list.size() > 0;
        }
        return false;
    }

    private void discoverIndexes(MongoCollection<?> dbCollection) {
        try {
            ListIndexesIterable<Document> iterable = dbCollection.listIndexes();
            for (Object e : iterable) {
                if (!(e instanceof Map)) continue;
                Map indexMap = (Map)e;
                String indexName = String.valueOf(indexMap.get(KEY_NAME));
                boolean indexIsPk = "_id_".endsWith(indexName);
                boolean indexIsUnique = Boolean.TRUE.equals(indexMap.get(KEY_UNIQUE));
                Object columnsObj = indexMap.get(KEY_KEY);
                if (!(columnsObj instanceof Map)) continue;
                Map columnsMap = (Map)columnsObj;
                MetaIndex metaIndex = this.createMetaIndex(indexName, indexIsPk, indexIsUnique);
                for (Object fieldNameObj : columnsMap.keySet()) {
                    MetaField metaField = this.findField((String)fieldNameObj);
                    if (metaField != null) {
                        metaIndex.addColumn(metaField);
                        continue;
                    }
                    System.err.println("MongoJDBC discover index cannot find metaField '" + fieldNameObj + "' for index " + e);
                }
            }
        }
        catch (Throwable ex) {
            System.err.println("Error in discover indexes " + dbCollection + "." + this + ". " + ex);
        }
    }
}

