/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.schema;

import com.dbschema.mongo.Util;
import com.dbschema.mongo.schema.MetaCollection;
import com.dbschema.mongo.schema.MetaJson;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;

public class MetaField {
    public final MetaJson parentJson;
    public final String name;
    public final String typeName;
    public final List<ObjectId> objectIds = new ArrayList<ObjectId>();
    public final int type;
    public boolean mandatory = true;

    public MetaField(MetaJson parentJson, String name, String typeName, int type) {
        this.parentJson = parentJson;
        this.name = name;
        this.typeName = typeName;
        this.type = type;
    }

    public void addObjectId(ObjectId objectId2) {
        if (this.objectIds.size() < 4) {
            this.objectIds.add(objectId2);
        }
    }

    public String getNameWithPath() {
        String qualifier = this.parentJson != null && !(this.parentJson instanceof MetaCollection) ? this.parentJson.getNameWithPath() + "." : "";
        return qualifier + Util.escapeChars(this.name, '\\', '.');
    }

    public String toString() {
        return this.getNameWithPath();
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }
}

