/*
 * Decompiled with CFR 0.152.
 */
package com.dbschema.mongo.schema;

import com.dbschema.mongo.schema.MetaField;
import java.util.ArrayList;
import java.util.List;

public class MetaJson
extends MetaField {
    public static final int TYPE_MAP = 4999544;
    public static final int TYPE_LIST = 4999545;
    public static final int TYPE_ARRAY = 2003;
    public final List<MetaField> fields = new ArrayList<MetaField>();

    public MetaJson(MetaJson parentJson, String name, int type) {
        super(parentJson, name, type == 4999545 ? "list" : "map", type);
    }

    public void createField(String name, String typeName, int type, boolean mandatoryIfNew) {
        for (MetaField column : this.fields) {
            if (!column.name.equals(name)) continue;
            return;
        }
        MetaField field = new MetaField(this, name, typeName, type);
        field.setMandatory(mandatoryIfNew);
        this.fields.add(field);
    }

    public MetaJson createJsonMapField(String name, boolean mandatoryIfNew) {
        for (MetaField field : this.fields) {
            if (!(field instanceof MetaJson) || !field.name.equals(name)) continue;
            return (MetaJson)field;
        }
        MetaJson json = new MetaJson(this, name, 4999544);
        this.fields.add(json);
        json.setMandatory(mandatoryIfNew);
        return json;
    }

    public MetaJson createJsonListField(String name, boolean mandatoryIfNew) {
        for (MetaField field : this.fields) {
            if (!(field instanceof MetaJson) || !field.name.equals(name)) continue;
            return (MetaJson)field;
        }
        MetaJson json = new MetaJson(this, name, 4999545);
        json.setMandatory(mandatoryIfNew);
        this.fields.add(json);
        return json;
    }

    public MetaField findField(String name) {
        for (MetaField other : this.fields) {
            if (!name.startsWith(other.getNameWithPath())) continue;
            MetaField found = null;
            if (other instanceof MetaJson) {
                found = ((MetaJson)other).findField(name);
            }
            return found != null ? found : other;
        }
        return null;
    }
}

