/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.QuantileMethod;
import com.mongodb.client.model.Window;
import com.mongodb.client.model.WindowOutputField;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class WindowOutputFields {
    public static WindowOutputField of(BsonField windowOutputField) {
        return new BsonFieldWindowOutputField(Assertions.notNull("windowOutputField", windowOutputField));
    }

    public static <TExpression> WindowOutputField sum(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$sum", expression, window);
    }

    public static <TExpression> WindowOutputField avg(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$avg", expression, window);
    }

    public static <InExpression, PExpression> WindowOutputField percentile(String path, InExpression inExpression, PExpression pExpression, QuantileMethod method, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("pExpression", pExpression);
        Assertions.notNull("method", method);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.P_LOWERCASE, pExpression);
        args2.put(ParamName.METHOD, method.toBsonValue());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$percentile", args2, window);
    }

    public static <InExpression> WindowOutputField median(String path, InExpression inExpression, QuantileMethod method, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("method", method);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(2);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.METHOD, method.toBsonValue());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$median", args2, window);
    }

    public static <TExpression> WindowOutputField stdDevSamp(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$stdDevSamp", expression, window);
    }

    public static <TExpression> WindowOutputField stdDevPop(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$stdDevPop", expression, window);
    }

    public static <TExpression> WindowOutputField min(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$min", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField minN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$minN", args2, window);
    }

    public static <TExpression> WindowOutputField max(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$max", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField maxN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$maxN", args2, window);
    }

    public static WindowOutputField count(String path, @Nullable Window window) {
        Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$count", null, window);
    }

    public static <TExpression> WindowOutputField derivative(String path, TExpression expression, Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        Assertions.notNull("window", window);
        HashMap<ParamName, Object> args2 = new HashMap<ParamName, Object>(1);
        args2.put(ParamName.INPUT, expression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$derivative", args2, window);
    }

    public static <TExpression> WindowOutputField timeDerivative(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        Assertions.notNull("window", window);
        Assertions.notNull("unit", unit);
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(2);
        args2.put(ParamName.INPUT, expression);
        args2.put(ParamName.UNIT, unit.value());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$derivative", args2, window);
    }

    public static <TExpression> WindowOutputField integral(String path, TExpression expression, Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        Assertions.notNull("window", window);
        HashMap<ParamName, Object> args2 = new HashMap<ParamName, Object>(1);
        args2.put(ParamName.INPUT, expression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$integral", args2, window);
    }

    public static <TExpression> WindowOutputField timeIntegral(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        Assertions.notNull("window", window);
        Assertions.notNull("unit", unit);
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(2);
        args2.put(ParamName.INPUT, expression);
        args2.put(ParamName.UNIT, unit.value());
        return WindowOutputFields.compoundParameterWindowFunction(path, "$integral", args2, window);
    }

    public static <TExpression> WindowOutputField covarianceSamp(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression1", expression1);
        Assertions.notNull("expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$covarianceSamp", expressions, window);
    }

    public static <TExpression> WindowOutputField covariancePop(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression1", expression1);
        Assertions.notNull("expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$covariancePop", expressions, window);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String path, TExpression expression, int n) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        com.mongodb.assertions.Assertions.isTrueArgument("n > 0", n > 0);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(2);
        args2.put(ParamName.INPUT, expression);
        args2.put(ParamName.N_UPPERCASE, n);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$expMovingAvg", args2, null);
    }

    public static <TExpression> WindowOutputField expMovingAvg(String path, TExpression expression, double alpha) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha > 0", alpha > 0.0);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha < 1", alpha < 1.0);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(2);
        args2.put(ParamName.INPUT, expression);
        args2.put(ParamName.ALPHA, alpha);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$expMovingAvg", args2, null);
    }

    public static <TExpression> WindowOutputField push(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$push", expression, window);
    }

    public static <TExpression> WindowOutputField addToSet(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$addToSet", expression, window);
    }

    public static <TExpression> WindowOutputField first(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$first", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField firstN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$firstN", args2, window);
    }

    public static <OutExpression> WindowOutputField top(String path, Bson sortBy, OutExpression outExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("sortBy", sortBy);
        Assertions.notNull("outExpression", outExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.SORT_BY, sortBy);
        args2.put(ParamName.OUTPUT, outExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$top", args2, window);
    }

    public static <OutExpression, NExpression> WindowOutputField topN(String path, Bson sortBy, OutExpression outExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("sortBy", sortBy);
        Assertions.notNull("outExpression", outExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.SORT_BY, sortBy);
        args2.put(ParamName.OUTPUT, outExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$topN", args2, window);
    }

    public static <TExpression> WindowOutputField last(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$last", expression, window);
    }

    public static <InExpression, NExpression> WindowOutputField lastN(String path, InExpression inExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.INPUT, inExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$lastN", args2, window);
    }

    public static <OutExpression> WindowOutputField bottom(String path, Bson sortBy, OutExpression outExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("sortBy", sortBy);
        Assertions.notNull("outExpression", outExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.SORT_BY, sortBy);
        args2.put(ParamName.OUTPUT, outExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$bottom", args2, window);
    }

    public static <OutExpression, NExpression> WindowOutputField bottomN(String path, Bson sortBy, OutExpression outExpression, NExpression nExpression, @Nullable Window window) {
        Assertions.notNull("path", path);
        Assertions.notNull("sortBy", sortBy);
        Assertions.notNull("outExpression", outExpression);
        Assertions.notNull("nExpression", nExpression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.SORT_BY, sortBy);
        args2.put(ParamName.OUTPUT, outExpression);
        args2.put(ParamName.N_LOWERCASE, nExpression);
        return WindowOutputFields.compoundParameterWindowFunction(path, "$bottomN", args2, window);
    }

    public static <TExpression> WindowOutputField shift(String path, TExpression expression, @Nullable TExpression defaultExpression, int by) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        LinkedHashMap<ParamName, Object> args2 = new LinkedHashMap<ParamName, Object>(3);
        args2.put(ParamName.OUTPUT, expression);
        args2.put(ParamName.BY, by);
        if (defaultExpression != null) {
            args2.put(ParamName.DEFAULT, defaultExpression);
        }
        return WindowOutputFields.compoundParameterWindowFunction(path, "$shift", args2, null);
    }

    public static WindowOutputField documentNumber(String path) {
        Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$documentNumber", null, null);
    }

    public static WindowOutputField rank(String path) {
        Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$rank", null, null);
    }

    public static WindowOutputField denseRank(String path) {
        Assertions.notNull("path", path);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$denseRank", null, null);
    }

    public static <TExpression> WindowOutputField locf(String path, TExpression expression) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$locf", expression, null);
    }

    public static <TExpression> WindowOutputField linearFill(String path, TExpression expression) {
        Assertions.notNull("path", path);
        Assertions.notNull("expression", expression);
        return WindowOutputFields.simpleParameterWindowFunction(path, "$linearFill", expression, null);
    }

    private static WindowOutputField simpleParameterWindowFunction(String path, String functionName, @Nullable Object expression, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(path, new SimpleParameterFunctionAndWindow(functionName, expression, window)));
    }

    private static WindowOutputField compoundParameterWindowFunction(String path, String functionName, Map<ParamName, Object> args2, @Nullable Window window) {
        return new BsonFieldWindowOutputField(new BsonField(path, new CompoundParameterFunctionAndWindow(functionName, args2, window)));
    }

    private WindowOutputFields() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonFieldWindowOutputField
    implements WindowOutputField {
        private final BsonField wrapped;

        BsonFieldWindowOutputField(BsonField field) {
            this.wrapped = com.mongodb.assertions.Assertions.assertNotNull(field);
        }

        @Override
        public BsonField toBsonField() {
            return this.wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsonFieldWindowOutputField that = (BsonFieldWindowOutputField)o;
            return this.wrapped.equals(that.wrapped);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static enum ParamName {
        INPUT("input"),
        UNIT("unit"),
        N_UPPERCASE("N"),
        N_LOWERCASE("n"),
        P_LOWERCASE("p"),
        ALPHA("alpha"),
        OUTPUT("output"),
        BY("by"),
        DEFAULT("default"),
        SORT_BY("sortBy"),
        METHOD("method");

        private final String value;

        private ParamName(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }

    private static final class SimpleParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        @Nullable
        private final Object expression;

        SimpleParameterFunctionAndWindow(String functionName, @Nullable Object expression, @Nullable Window window) {
            super(functionName, window);
            this.expression = expression;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            if (this.expression == null) {
                writer.writeStartDocument();
                writer.writeEndDocument();
            } else {
                BuildersHelper.encodeValue(writer, this.expression, codecRegistry);
            }
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleParameterFunctionAndWindow that = (SimpleParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.expression, that.expression) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.expression, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", expression=" + this.expression + ", window=" + this.window() + '}';
        }
    }

    private static final class CompoundParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        private final Map<ParamName, Object> args;

        CompoundParameterFunctionAndWindow(String functionName, Map<ParamName, Object> args2, @Nullable Window window) {
            super(functionName, window);
            this.args = args2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            writer.writeStartDocument();
            this.args.forEach((paramName, paramValue) -> {
                writer.writeName(paramName.value());
                BuildersHelper.encodeValue(writer, paramValue, codecRegistry);
            });
            writer.writeEndDocument();
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundParameterFunctionAndWindow that = (CompoundParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.args, that.args) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.args, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", args=" + this.args + ", window=" + this.window() + '}';
        }
    }

    private static abstract class AbstractFunctionAndWindow
    implements Bson {
        private final String functionName;
        @Nullable
        private final Window window;

        AbstractFunctionAndWindow(String functionName, @Nullable Window window) {
            this.functionName = functionName;
            this.window = window;
        }

        final void writeWindow(CodecRegistry codecRegistry, BsonDocumentWriter writer) {
            if (this.window != null) {
                writer.writeName("window");
                BuildersHelper.encodeValue(writer, this.window, codecRegistry);
            }
        }

        final String functionName() {
            return this.functionName;
        }

        final Optional<Window> window() {
            return Optional.ofNullable(this.window);
        }
    }
}

