/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class AsynchronousSocketChannelStream
extends AsynchronousChannelStream {
    private final ServerAddress serverAddress;
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStream(ServerAddress serverAddress, SocketSettings settings, PowerOfTwoBufferPool bufferProvider, AsynchronousChannelGroup group) {
        super(serverAddress, settings, bufferProvider);
        this.serverAddress = serverAddress;
        this.settings = settings;
        this.group = group;
    }

    @Override
    public void openAsync(AsyncCompletionHandler<Void> handler) {
        LinkedList<SocketAddress> socketAddressQueue;
        Assertions.isTrue("unopened", this.getChannel() == null);
        try {
            socketAddressQueue = new LinkedList<SocketAddress>(this.serverAddress.getSocketAddresses());
        }
        catch (Throwable t) {
            handler.failed(t);
            return;
        }
        this.initializeSocketChannel(handler, socketAddressQueue);
    }

    private void initializeSocketChannel(AsyncCompletionHandler<Void> handler, Queue<SocketAddress> socketAddressQueue) {
        if (socketAddressQueue.isEmpty()) {
            handler.failed(new MongoSocketException("Exception opening socket", this.serverAddress));
        } else {
            SocketAddress socketAddress = socketAddressQueue.poll();
            try {
                AsynchronousSocketChannel attemptConnectionChannel = AsynchronousSocketChannel.open(this.group);
                attemptConnectionChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                attemptConnectionChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                if (this.settings.getReceiveBufferSize() > 0) {
                    attemptConnectionChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.settings.getReceiveBufferSize());
                }
                if (this.settings.getSendBufferSize() > 0) {
                    attemptConnectionChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.settings.getSendBufferSize());
                }
                attemptConnectionChannel.connect(socketAddress, null, new OpenCompletionHandler(handler, socketAddressQueue, attemptConnectionChannel));
            }
            catch (IOException e) {
                handler.failed(new MongoSocketOpenException("Exception opening socket", this.serverAddress, (Throwable)e));
            }
            catch (Throwable t) {
                handler.failed(t);
            }
        }
    }

    public AsynchronousChannelGroup getGroup() {
        return this.group;
    }

    private class OpenCompletionHandler
    implements CompletionHandler<Void, Object> {
        private final AtomicReference<AsyncCompletionHandler<Void>> handlerReference;
        private final Queue<SocketAddress> socketAddressQueue;
        private final AsynchronousSocketChannel attemptConnectionChannel;

        OpenCompletionHandler(AsyncCompletionHandler<Void> handler, Queue<SocketAddress> socketAddressQueue, AsynchronousSocketChannel attemptConnectionChannel) {
            this.handlerReference = new AtomicReference<AsyncCompletionHandler<Void>>(handler);
            this.socketAddressQueue = socketAddressQueue;
            this.attemptConnectionChannel = attemptConnectionChannel;
        }

        @Override
        public void completed(Void result2, Object attachment) {
            AsynchronousSocketChannelStream.this.setChannel(new AsynchronousSocketChannelAdapter(this.attemptConnectionChannel));
            ((AsyncCompletionHandler)this.handlerReference.getAndSet(null)).completed(null);
        }

        @Override
        public void failed(Throwable exc, Object attachment) {
            AsyncCompletionHandler localHandler = this.handlerReference.getAndSet(null);
            if (this.socketAddressQueue.isEmpty()) {
                if (exc instanceof IOException) {
                    localHandler.failed(new MongoSocketOpenException("Exception opening socket", AsynchronousSocketChannelStream.this.getAddress(), exc));
                } else {
                    localHandler.failed(exc);
                }
            } else {
                AsynchronousSocketChannelStream.this.initializeSocketChannel(localHandler, this.socketAddressQueue);
            }
        }
    }

    private static final class AsynchronousSocketChannelAdapter
    implements ExtendedAsynchronousByteChannel {
        private final AsynchronousSocketChannel channel;

        private AsynchronousSocketChannelAdapter(AsynchronousSocketChannel channel) {
            this.channel = channel;
        }

        @Override
        public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, @Nullable A attach, CompletionHandler<Integer, ? super A> handler) {
            this.channel.read(dst, timeout, unit, attach, handler);
        }

        @Override
        public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, @Nullable A attach, CompletionHandler<Long, ? super A> handler) {
            this.channel.read(dsts, offset, length, timeout, unit, attach, handler);
        }

        @Override
        public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attach, CompletionHandler<Integer, ? super A> handler) {
            this.channel.write(src, timeout, unit, attach, handler);
        }

        @Override
        public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attach, CompletionHandler<Long, ? super A> handler) {
            this.channel.write(srcs, offset, length, timeout, unit, attach, handler);
        }

        @Override
        public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
            this.channel.read(dst, attachment, handler);
        }

        @Override
        public Future<Integer> read(ByteBuffer dst) {
            return this.channel.read(dst);
        }

        @Override
        public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
            this.channel.write(src, attachment, handler);
        }

        @Override
        public Future<Integer> write(ByteBuffer src) {
            return this.channel.write(src);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

