/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;

final class AuthorizationHeader {
    private static final String AWS4_HMAC_SHA256 = "AWS4-HMAC-SHA256";
    private static final String SERVICE = "sts";
    private final String host;
    private final String timestamp;
    private final String signature;
    private final String sessionToken;
    private final String authorizationHeader;
    private final byte[] nonce;
    private final Map<String, String> requestHeaders;
    private final String body;

    private AuthorizationHeader(Builder builder) throws SaslException {
        this.sessionToken = builder.sessionToken;
        this.host = builder.host;
        this.timestamp = builder.timestamp;
        this.nonce = builder.nonce;
        this.body = "Action=GetCallerIdentity&Version=2011-06-15";
        this.requestHeaders = this.getRequestHeaders();
        String canonicalRequest = AuthorizationHeader.createCanonicalRequest("POST", "", this.body, this.requestHeaders);
        String toSign = AuthorizationHeader.createStringToSign(AuthorizationHeader.hash(canonicalRequest), this.getTimestamp(), this.getCredentialScope());
        this.signature = AuthorizationHeader.calculateSignature(toSign, builder.secretKey, this.getDate(), AuthorizationHeader.getRegion(this.host), SERVICE);
        this.authorizationHeader = String.format("%s Credential=%s/%s, SignedHeaders=%s, Signature=%s", AWS4_HMAC_SHA256, builder.accessKeyID, this.getCredentialScope(), AuthorizationHeader.getSignedHeaders(this.requestHeaders), this.getSignature());
    }

    static String createCanonicalRequest(String method, String query, String body, Map<String, String> requestHeaders) throws SaslException {
        String headers = AuthorizationHeader.getCanonicalHeaders(requestHeaders);
        String signedHeaders = AuthorizationHeader.getSignedHeaders(requestHeaders);
        List<String> request = Arrays.asList(method, "/", query, headers, signedHeaders, AuthorizationHeader.hash(body));
        return String.join((CharSequence)"\n", request);
    }

    static String createStringToSign(String hash, String timestamp2, String credentialScope) {
        List<String> toSign = Arrays.asList(AWS4_HMAC_SHA256, timestamp2, credentialScope, hash);
        return String.join((CharSequence)"\n", toSign);
    }

    static String calculateSignature(String toSign, String secret, String date, String region, String service) throws SaslException {
        byte[] kDate = AuthorizationHeader.hmac(AuthorizationHeader.decodeUTF8("AWS4" + secret), AuthorizationHeader.decodeUTF8(date));
        byte[] kRegion = AuthorizationHeader.hmac(kDate, AuthorizationHeader.decodeUTF8(region));
        byte[] kService = AuthorizationHeader.hmac(kRegion, AuthorizationHeader.decodeUTF8(service));
        byte[] kSigning = AuthorizationHeader.hmac(kService, AuthorizationHeader.decodeUTF8("aws4_request"));
        return AuthorizationHeader.hexEncode(AuthorizationHeader.hmac(kSigning, AuthorizationHeader.decodeUTF8(toSign)));
    }

    private Map<String, String> getRequestHeaders() {
        if (this.requestHeaders != null) {
            return this.requestHeaders;
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        requestHeaders.put("Content-Length", String.valueOf(this.body.length()));
        requestHeaders.put("Host", this.host);
        requestHeaders.put("X-Amz-Date", this.timestamp);
        requestHeaders.put("X-MongoDB-Server-Nonce", Base64.getEncoder().encodeToString(this.nonce));
        requestHeaders.put("X-MongoDB-GS2-CB-Flag", "n");
        if (this.sessionToken != null) {
            requestHeaders.put("X-Amz-Security-Token", this.sessionToken);
        }
        return requestHeaders;
    }

    private String getCredentialScope() throws SaslException {
        return String.format("%s/%s/%s/aws4_request", this.getDate(), AuthorizationHeader.getRegion(this.host), SERVICE);
    }

    static String getSignedHeaders(Map<String, String> requestHeaders) {
        return requestHeaders.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    static String getCanonicalHeaders(Map<String, String> requestHeaders) {
        return requestHeaders.entrySet().stream().map(kvp -> String.format("%s:%s\n", ((String)kvp.getKey()).toLowerCase(), ((String)kvp.getValue()).trim().replaceAll(" +", " "))).sorted().collect(Collectors.joining(""));
    }

    static String getRegion(String host) throws SaslException {
        String word = "(\\w)+(-\\w)*";
        if (host.equals("sts.amazonaws.com") || host.matches(String.format("%s", word))) {
            return "us-east-1";
        }
        if (host.matches(String.format("%s(.%s)+", word, word))) {
            return host.split("\\.")[1];
        }
        throw new SaslException("Invalid host");
    }

    String getSignature() {
        return this.signature;
    }

    String getTimestamp() {
        return this.timestamp;
    }

    private String getDate() {
        return this.getTimestamp().substring(0, "YYYYMMDD".length());
    }

    static String hash(String str) throws SaslException {
        return AuthorizationHeader.hexEncode(AuthorizationHeader.sha256(str)).toLowerCase();
    }

    private static String hexEncode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static byte[] decodeUTF8(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] hmac(byte[] secret, byte[] message) throws SaslException {
        byte[] hmacSha256;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec spec = new SecretKeySpec(secret, "HmacSHA256");
            mac.init(spec);
            hmacSha256 = mac.doFinal(message);
        }
        catch (Exception e) {
            throw new SaslException(e.getMessage());
        }
        return hmacSha256;
    }

    private static byte[] sha256(String payload) throws SaslException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException(e.getMessage());
        }
        return md.digest(payload.getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return this.authorizationHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String accessKeyID;
        private String secretKey;
        private String sessionToken;
        private String host;
        private String timestamp;
        private byte[] nonce;

        private Builder() {
        }

        Builder setAccessKeyID(String accessKeyID) {
            this.accessKeyID = accessKeyID;
            return this;
        }

        Builder setSecretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        Builder setSessionToken(@Nullable String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        Builder setHost(String host) {
            this.host = host;
            return this;
        }

        Builder setTimestamp(String timestamp2) {
            this.timestamp = timestamp2;
            return this;
        }

        Builder setNonce(byte[] nonce) {
            this.nonce = nonce;
            return this;
        }

        AuthorizationHeader build() throws SaslException {
            return new AuthorizationHeader(this);
        }
    }
}

