/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh;

import com.mongodb.client.MongoClient;
import com.mongodb.mongosh.ConsoleLogSupport;
import com.mongodb.mongosh.MongoShellContext;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.MongoShellEvaluator;
import com.mongodb.mongosh.ValueWrapper;
import com.mongodb.mongosh.result.ArrayResult;
import com.mongodb.mongosh.result.MongoShellResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Value;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mongodb/mongosh/MongoShell;", "", "client", "Lcom/mongodb/client/MongoClient;", "engine", "Lorg/graalvm/polyglot/Engine;", "(Lcom/mongodb/client/MongoClient;Lorg/graalvm/polyglot/Engine;)V", "consoleLog", "Lcom/mongodb/mongosh/ConsoleLogSupport;", "context", "Lcom/mongodb/mongosh/MongoShellContext;", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "evaluator", "Lcom/mongodb/mongosh/MongoShellEvaluator;", "wrapper", "Lcom/mongodb/mongosh/ValueWrapper;", "close", "", "eval", "Lcom/mongodb/mongosh/result/MongoShellResult;", "script", "", "setClient", "JMongosh"})
public final class MongoShell {
    @NotNull
    private final MongoShellContext context;
    @NotNull
    private final ValueWrapper wrapper;
    @NotNull
    private final MongoShellConverter converter;
    @NotNull
    private final MongoShellEvaluator evaluator;
    @NotNull
    private final ConsoleLogSupport consoleLog;

    public MongoShell(@Nullable MongoClient client, @Nullable Engine engine) {
        this.context = new MongoShellContext(engine);
        this.wrapper = new ValueWrapper(this.context);
        this.converter = new MongoShellConverter(this.context, this.wrapper);
        this.evaluator = new MongoShellEvaluator(client, this.context, this.converter, this.wrapper);
        this.consoleLog = new ConsoleLogSupport(this.context, this.converter);
    }

    public /* synthetic */ MongoShell(MongoClient mongoClient, Engine engine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mongoClient = null;
        }
        if ((n & 2) != 0) {
            engine = null;
        }
        this(mongoClient, engine);
    }

    public final void setClient(@NotNull MongoClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.evaluator.setClient(client);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MongoShellResult<?> eval(@Language(value="js") @NotNull String script) {
        MongoShellResult mongoShellResult;
        Intrinsics.checkNotNullParameter(script, "script");
        List printedValues = new ArrayList();
        Value result2 = (Value)this.consoleLog.withConsoleLogEnabled(printedValues, (Function0)new Function0<Value>(this, script){
            final /* synthetic */ MongoShell this$0;
            final /* synthetic */ String $script;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                super(0);
            }

            @NotNull
            public final Value invoke() {
                return MongoShell.access$getConverter$p(this.this$0).unwrapPromise(MongoShell.access$getEvaluator$p(this.this$0).eval(this.$script, "user_script"));
            }
        });
        if (!((Collection)printedValues).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = printedValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$associateByTo$iv$iv;
                void args2;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int idx = 0;
                Iterable $this$associateBy$iv = (Iterable)args2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                Iterable iterable2 = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv;
                    Object t = element$iv$iv = iterator2.next();
                    Map map = destination$iv$iv2;
                    boolean bl2 = false;
                    int n = idx;
                    idx = n + 1;
                    map.put(String.valueOf(n), element$iv$iv);
                }
                collection.add(destination$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            mongoShellResult = new ArrayResult(list);
        } else {
            Value printable = result2.getMember("printable");
            String type = result2.getMember("type").asString();
            Intrinsics.checkNotNullExpressionValue(printable, "printable");
            mongoShellResult = this.converter.toJava(printable, type);
        }
        return mongoShellResult;
    }

    public final void close() {
        this.evaluator.close();
    }

    public MongoShell() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ MongoShellConverter access$getConverter$p(MongoShell $this) {
        return $this.converter;
    }

    public static final /* synthetic */ MongoShellEvaluator access$getEvaluator$p(MongoShell $this) {
        return $this.evaluator;
    }
}

