/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh;

import com.mongodb.DBRef;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.mongosh.BsonTypes;
import com.mongodb.mongosh.MongoShellContext;
import com.mongodb.mongosh.MongoshDate;
import com.mongodb.mongosh.ValueWrapper;
import com.mongodb.mongosh.result.ArrayResult;
import com.mongodb.mongosh.result.BSONTimestampResult;
import com.mongodb.mongosh.result.BinaryResult;
import com.mongodb.mongosh.result.BooleanResult;
import com.mongodb.mongosh.result.BulkWriteResult;
import com.mongodb.mongosh.result.CodeResult;
import com.mongodb.mongosh.result.CodeWithScopeResult;
import com.mongodb.mongosh.result.Cursor;
import com.mongodb.mongosh.result.CursorResult;
import com.mongodb.mongosh.result.DBRefResult;
import com.mongodb.mongosh.result.DateResult;
import com.mongodb.mongosh.result.Decimal128Result;
import com.mongodb.mongosh.result.DeleteResult;
import com.mongodb.mongosh.result.DocumentResult;
import com.mongodb.mongosh.result.DoubleResult;
import com.mongodb.mongosh.result.FindCursor;
import com.mongodb.mongosh.result.FindCursorResult;
import com.mongodb.mongosh.result.FloatResult;
import com.mongodb.mongosh.result.FunctionResult;
import com.mongodb.mongosh.result.InsertManyResult;
import com.mongodb.mongosh.result.InsertOneResult;
import com.mongodb.mongosh.result.IntResult;
import com.mongodb.mongosh.result.LongResult;
import com.mongodb.mongosh.result.MaxKeyResult;
import com.mongodb.mongosh.result.MinKeyResult;
import com.mongodb.mongosh.result.MongoShellResult;
import com.mongodb.mongosh.result.MongoShellUpdateResult;
import com.mongodb.mongosh.result.NullResult;
import com.mongodb.mongosh.result.ObjectIdResult;
import com.mongodb.mongosh.result.PatternResult;
import com.mongodb.mongosh.result.StringResult;
import com.mongodb.mongosh.result.SymbolResult;
import com.mongodb.mongosh.result.UUIDResult;
import com.mongodb.mongosh.result.UtilKt;
import com.mongodb.mongosh.result.VoidResult;
import com.mongodb.mongosh.service.Either;
import com.mongodb.mongosh.service.Left;
import com.mongodb.mongosh.service.Right;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.json.JsonReader;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWithScope;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u000f\u001a\u00020\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u0019\u0010\u0014\u001a\u00020\n2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0019H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bH\u0002J\u001a\u0010\u001c\u001a\u00020\n\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/mongodb/mongosh/MongoShellConverter;", "", "context", "Lcom/mongodb/mongosh/MongoShellContext;", "wrapper", "Lcom/mongodb/mongosh/ValueWrapper;", "(Lcom/mongodb/mongosh/MongoShellContext;Lcom/mongodb/mongosh/ValueWrapper;)V", "bsonTypes", "Lcom/mongodb/mongosh/BsonTypes;", "toBuffer", "Lorg/graalvm/polyglot/Value;", "array", "", "toJava", "Lcom/mongodb/mongosh/result/MongoShellResult;", "v", "type", "", "toJavaPromise", "Ljava/util/concurrent/CompletableFuture;", "toJs", "o", "list", "", "([Ljava/lang/Object;)Lorg/graalvm/polyglot/Value;", "", "map", "", "toJsPromise", "T", "promise", "Lcom/mongodb/mongosh/service/Either;", "unwrapPromise", "JMongosh"})
public final class MongoShellConverter {
    @NotNull
    private final MongoShellContext context;
    @NotNull
    private final ValueWrapper wrapper;
    @NotNull
    private final BsonTypes bsonTypes;

    public MongoShellConverter(@NotNull MongoShellContext context, @NotNull ValueWrapper wrapper) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        this.context = context;
        this.wrapper = wrapper;
        this.bsonTypes = new BsonTypes(this.context);
    }

    @Nullable
    public final Object toJs(@Nullable Object o) {
        Object object;
        Object object2 = o;
        if (object2 instanceof Iterable) {
            object = this.toJs((Iterable)o);
        } else if (object2 instanceof Object[]) {
            object = this.toJs((Object[])o);
        } else if (object2 instanceof Map) {
            object = this.toJs((Map)o);
        } else if (object2 instanceof Unit) {
            object = MongoShellContext.eval$default(this.context, "undefined", null, 2, null);
        } else if (object2 instanceof MaxKey) {
            object = this.bsonTypes.getMaxKey().newInstance(new Object[0]);
        } else if (object2 instanceof MinKey) {
            object = this.bsonTypes.getMinKey().newInstance(new Object[0]);
        } else if (object2 instanceof Binary) {
            Value value = this.bsonTypes.getBinData();
            Object[] objectArray = new Object[2];
            byte[] byArray = ((Binary)o).getData();
            Intrinsics.checkNotNullExpressionValue(byArray, "o.data");
            objectArray[0] = this.toJs(byArray);
            objectArray[1] = ((Binary)o).getType();
            object = value.newInstance(objectArray);
        } else if (object2 instanceof Symbol) {
            Object[] objectArray = new Object[]{((Symbol)o).getSymbol()};
            object = this.bsonTypes.getBsonSymbol().newInstance(objectArray);
        } else if (object2 instanceof Decimal128) {
            Object[] objectArray = new Object[]{((Decimal128)o).bigDecimalValue().toPlainString()};
            object = this.bsonTypes.getNumberDecimal().newInstance(objectArray);
        } else if (object2 instanceof Long) {
            Object[] objectArray = new Object[]{String.valueOf(((Number)o).longValue())};
            object = this.bsonTypes.getNumberLong().newInstance(objectArray);
        } else if (object2 instanceof Integer) {
            Object[] objectArray = new Object[]{String.valueOf(((Number)o).intValue())};
            object = this.bsonTypes.getNumberInt().newInstance(objectArray);
        } else if (object2 instanceof CodeWithScope) {
            Value value = this.bsonTypes.getCode();
            Object[] objectArray = new Object[2];
            objectArray[0] = ((CodeWithScope)o).getCode();
            Document document = ((CodeWithScope)o).getScope();
            Intrinsics.checkNotNullExpressionValue(document, "o.scope");
            objectArray[1] = this.toJs(document);
            object = value.newInstance(objectArray);
        } else if (object2 instanceof Code) {
            Object[] objectArray = new Object[]{((Code)o).getCode()};
            object = this.bsonTypes.getCode().newInstance(objectArray);
        } else if (object2 instanceof DBRef) {
            Object[] objectArray = new Object[]{((DBRef)o).getCollectionName(), this.toJs(((DBRef)o).getId()), ((DBRef)o).getDatabaseName()};
            object = this.bsonTypes.getDbRef().newInstance(objectArray);
        } else if (object2 instanceof BsonValue) {
            BsonValue bsonValue = (BsonValue)o;
            if (bsonValue instanceof BsonSymbol) {
                Object[] objectArray = new Object[]{((BsonSymbol)o).getSymbol()};
                object = this.bsonTypes.getBsonSymbol().newInstance(objectArray);
            } else if (bsonValue instanceof BsonNull) {
                object = null;
            } else if (bsonValue instanceof BsonObjectId) {
                Object[] objectArray = new Object[]{((BsonObjectId)o).getValue().toHexString()};
                object = this.bsonTypes.getObjectId().newInstance(objectArray);
            } else if (bsonValue instanceof BsonBoolean) {
                object = ((BsonBoolean)o).getValue();
            } else if (bsonValue instanceof BsonMaxKey) {
                object = this.bsonTypes.getMaxKey().newInstance(new Object[0]);
            } else if (bsonValue instanceof BsonString) {
                object = ((BsonString)o).getValue();
            } else if (bsonValue instanceof BsonMinKey) {
                object = this.bsonTypes.getMinKey().newInstance(new Object[0]);
            } else if (bsonValue instanceof BsonDateTime) {
                object = new MongoshDate(((BsonDateTime)o).getValue());
            } else if (bsonValue instanceof BsonJavaScript) {
                Object[] objectArray = new Object[]{((BsonJavaScript)o).getCode()};
                object = this.bsonTypes.getCode().newInstance(objectArray);
            } else if (bsonValue instanceof BsonJavaScriptWithScope) {
                Value value = this.bsonTypes.getCode();
                Object[] objectArray = new Object[2];
                objectArray[0] = ((BsonJavaScriptWithScope)o).getCode();
                BsonDocument bsonDocument = ((BsonJavaScriptWithScope)o).getScope();
                Intrinsics.checkNotNullExpressionValue(bsonDocument, "o.scope");
                objectArray[1] = this.toJs(bsonDocument);
                object = value.newInstance(objectArray);
            } else if (bsonValue instanceof BsonTimestamp) {
                Object[] objectArray = new Object[]{((BsonTimestamp)o).getInc(), ((BsonTimestamp)o).getTime()};
                object = this.bsonTypes.getTimestamp().newInstance(objectArray);
            } else if (bsonValue instanceof BsonInt64) {
                Object[] objectArray = new Object[]{((BsonInt64)o).getValue()};
                object = this.bsonTypes.getNumberLong().newInstance(objectArray);
            } else if (bsonValue instanceof BsonInt32) {
                Object[] objectArray = new Object[]{((BsonInt32)o).getValue()};
                object = this.bsonTypes.getNumberInt().newInstance(objectArray);
            } else if (bsonValue instanceof BsonDecimal128) {
                Object[] objectArray = new Object[]{((BsonDecimal128)o).getValue()};
                object = this.bsonTypes.getNumberDecimal().newInstance(objectArray);
            } else if (bsonValue instanceof BsonDouble) {
                object = ((BsonDouble)o).getValue();
            } else if (bsonValue instanceof BsonUndefined) {
                object = MongoShellContext.eval$default(this.context, "undefined", null, 2, null);
            } else if (bsonValue instanceof BsonBinary) {
                Value value = this.bsonTypes.getBinData();
                Object[] objectArray = new Object[2];
                byte[] byArray = ((BsonBinary)o).getData();
                Intrinsics.checkNotNullExpressionValue(byArray, "o.data");
                objectArray[0] = this.toJs(byArray);
                objectArray[1] = ((BsonBinary)o).getType();
                object = value.newInstance(objectArray);
            } else {
                object = o;
            }
        } else {
            object = o;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final Value toJs(Map<?, ?> map) {
        Value jsMap = MongoShellContext.eval$default(this.context, "new Object()", null, 2, null);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            void identifier$iv;
            void $this$set$iv;
            Object key = entry.getKey();
            Object value = entry.getValue();
            Value value2 = jsMap;
            Object obj = key;
            if (obj == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String string = (String)obj;
            Object value$iv = this.toJs(value);
            boolean $i$f$set = false;
            $this$set$iv.putMember((String)identifier$iv, value$iv);
        }
        return jsMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Value toJs(Iterable<? extends Object> list) {
        Value array = MongoShellContext.eval$default(this.context, "[]", null, 2, null);
        Iterable<? extends Object> $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object object : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object object2 = object;
            int index = n;
            boolean bl = false;
            array.setArrayElement(index, this.toJs(v));
        }
        return array;
    }

    /*
     * WARNING - void declaration
     */
    private final Value toJs(byte[] array) {
        Value jsArray = MongoShellContext.eval$default(this.context, "[]", null, 2, null);
        byte[] $this$forEachIndexed$iv = array;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv;
            index$iv = n + 1;
            byte by = item$iv;
            int index = n;
            boolean bl = false;
            jsArray.setArrayElement(index, (byte)v);
        }
        return jsArray;
    }

    /*
     * WARNING - void declaration
     */
    private final Value toJs(Object[] list) {
        Value array = MongoShellContext.eval$default(this.context, "[]", null, 2, null);
        Object[] $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv;
            index$iv = n + 1;
            Object object = item$iv;
            int index = n;
            boolean bl = false;
            array.setArrayElement(index, this.toJs(v));
        }
        return array;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Value toBuffer(@NotNull byte[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        Value jsArray = MongoShellContext.eval$default(this.context, "new Buffer(" + array.length + ')', null, 2, null);
        byte[] $this$forEachIndexed$iv = array;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void v;
            int n = index$iv;
            index$iv = n + 1;
            byte by = item$iv;
            int index = n;
            boolean bl = false;
            jsArray.setArrayElement(index, (byte)v);
        }
        return jsArray;
    }

    @NotNull
    public final <T> Value toJsPromise(@NotNull Either<? extends T> promise) {
        Value value;
        Intrinsics.checkNotNullParameter(promise, "promise");
        Either<? extends T> either = promise;
        if (either instanceof Right) {
            Object[] objectArray = new Object[]{this.toJs(((Right)promise).getValue())};
            Value value2 = this.context.eval("(v) => new Promise(((resolve) => resolve(v)))", "resolved_promise_script").execute(objectArray);
            Intrinsics.checkNotNullExpressionValue(value2, "context.eval(\"(v) => new\u2026cute(toJs(promise.value))");
            value = value2;
        } else if (either instanceof Left) {
            Object[] objectArray = new Object[]{((Left)promise).getValue()};
            Value value3 = this.context.eval("(v) => new Promise(((_, reject) => reject(v)))", "rejected_promise_script").execute(objectArray);
            Intrinsics.checkNotNullExpressionValue(value3, "context.eval(\"(v) => new\u2026\").execute(promise.value)");
            value = value3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Value> toJavaPromise(@NotNull Value v) {
        CompletableFuture<Value> completableFuture;
        void context$iv;
        void $this$instanceOf$iv;
        Intrinsics.checkNotNullParameter(v, "v");
        CompletableFuture<Value> completableFuture2 = v;
        MongoShellContext mongoShellContext = this.context;
        String clazz$iv = "Promise";
        boolean $i$f$instanceOf = false;
        Object[] objectArray = new Object[]{$this$instanceOf$iv};
        if (context$iv.eval(Intrinsics.stringPlus("(x) => x instanceof ", clazz$iv), "instance_of_script").execute(objectArray).asBoolean()) {
            CompletableFuture<Value> future = completableFuture2 = new CompletableFuture<Value>();
            boolean bl = false;
            Object[] objectArray2 = new Object[]{arg_0 -> MongoShellConverter.toJavaPromise$lambda-6$lambda-4(future, arg_0)};
            Value value = v.invokeMember("then", objectArray2);
            objectArray2 = new Object[]{arg_0 -> MongoShellConverter.toJavaPromise$lambda-6$lambda-5(future, this, arg_0)};
            value.invokeMember("catch", objectArray2);
            completableFuture = completableFuture2;
        } else {
            completableFuture2 = CompletableFuture.completedFuture(v);
            Intrinsics.checkNotNullExpressionValue(completableFuture2, "completedFuture(v)");
            completableFuture = completableFuture2;
        }
        return completableFuture;
    }

    @NotNull
    public final Value unwrapPromise(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        try {
            Value value = this.toJavaPromise(v).get(1L, TimeUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue(value, "toJavaPromise(v).get(1, TimeUnit.SECONDS)");
            return value;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final MongoShellResult<?> toJava(@NotNull Value v, @Nullable String type) {
        block74: {
            block94: {
                block93: {
                    block92: {
                        block91: {
                            block90: {
                                block89: {
                                    block88: {
                                        block87: {
                                            block86: {
                                                block85: {
                                                    block84: {
                                                        block83: {
                                                            block82: {
                                                                block81: {
                                                                    block80: {
                                                                        block79: {
                                                                            block78: {
                                                                                block77: {
                                                                                    block76: {
                                                                                        block75: {
                                                                                            block73: {
                                                                                                Intrinsics.checkNotNullParameter(v, "v");
                                                                                                if (!this.wrapper.isWrapped(v)) break block73;
                                                                                                v0 = this.toJava(this.wrapper.unwrap(v), type);
                                                                                                break block74;
                                                                                            }
                                                                                            if (!Intrinsics.areEqual(type, "Help")) break block75;
                                                                                            var3_3 = v;
                                                                                            identifier$iv = "attr";
                                                                                            $i$f$get = false;
                                                                                            v1 = $this$get$iv.getMember(identifier$iv);
                                                                                            Intrinsics.checkNotNull(v1);
                                                                                            v0 = MongoShellConverter.toJava$default(this, v1, null, 2, null);
                                                                                            break block74;
                                                                                        }
                                                                                        if (!Intrinsics.areEqual(type, "Cursor")) break block76;
                                                                                        v0 = new FindCursorResult(new FindCursor<T>(v, this));
                                                                                        break block74;
                                                                                    }
                                                                                    if (!Intrinsics.areEqual(type, "AggregationCursor") || !v.hasMember("_cursor")) break block77;
                                                                                    v0 = new CursorResult<Cursor<T>>(new Cursor<T>(v, this));
                                                                                    break block74;
                                                                                }
                                                                                if (!Intrinsics.areEqual(type, "InsertOneResult")) break block78;
                                                                                $this$get$iv = v;
                                                                                identifier$iv = "acknowledged";
                                                                                $i$f$get = false;
                                                                                v2 = $this$get$iv.getMember((String)identifier$iv);
                                                                                Intrinsics.checkNotNull(v2);
                                                                                v3 = v2.asBoolean();
                                                                                identifier$iv = v;
                                                                                identifier$iv = "insertedId";
                                                                                $i$f$get = false;
                                                                                v4 = $this$get$iv.getMember((String)identifier$iv);
                                                                                if (v4 == null) {
                                                                                    v5 = null;
                                                                                } else {
                                                                                    identifier$iv = v4;
                                                                                    var16_43 = v3;
                                                                                    $i$a$-let-MongoShellConverter$toJava$1 = false;
                                                                                    var17_46 = MongoShellConverter.toJava$default(this, (Value)it, null, 2, null).getValue();
                                                                                    v3 = var16_43;
                                                                                    v5 = var17_46;
                                                                                }
                                                                                var21_48 = v5;
                                                                                var22_49 = v3;
                                                                                v0 = new InsertOneResult(var22_49, var21_48);
                                                                                break block74;
                                                                            }
                                                                            if (!Intrinsics.areEqual(type, "DeleteResult")) break block79;
                                                                            $this$get$iv = v;
                                                                            identifier$iv = "acknowledged";
                                                                            $i$f$get = false;
                                                                            v6 = $this$get$iv.getMember(identifier$iv);
                                                                            Intrinsics.checkNotNull(v6);
                                                                            v7 = v6.asBoolean();
                                                                            $this$get$iv = v;
                                                                            identifier$iv = "deletedCount";
                                                                            $i$f$get = false;
                                                                            v8 = $this$get$iv.getMember(identifier$iv);
                                                                            Intrinsics.checkNotNull(v8);
                                                                            v0 = new DeleteResult(v7, ((LongResult)MongoShellConverter.toJava$default(this, v8, null, 2, null)).getValue());
                                                                            break block74;
                                                                        }
                                                                        if (!Intrinsics.areEqual(type, "UpdateResult")) break block80;
                                                                        identifier$iv = v;
                                                                        identifier$iv = "acknowledged";
                                                                        $i$f$get = false;
                                                                        v9 = $this$get$iv.getMember(identifier$iv);
                                                                        Intrinsics.checkNotNull(v9);
                                                                        if (v9.asBoolean()) {
                                                                            $this$get$iv = v;
                                                                            identifier$iv = "matchedCount";
                                                                            $i$f$get = false;
                                                                            v10 = $this$get$iv.getMember(identifier$iv);
                                                                            Intrinsics.checkNotNull(v10);
                                                                            v11 = ((LongResult)MongoShellConverter.toJava$default(this, v10, null, 2, null)).getValue();
                                                                            $this$get$iv = v;
                                                                            identifier$iv = "modifiedCount";
                                                                            $i$f$get = false;
                                                                            v12 = $this$get$iv.getMember(identifier$iv);
                                                                            Intrinsics.checkNotNull(v12);
                                                                            v13 = UpdateResult.acknowledged(v11, ((LongResult)MongoShellConverter.toJava$default(this, v12, null, 2, null)).getValue(), null);
                                                                        } else {
                                                                            v13 = UpdateResult.unacknowledged();
                                                                        }
                                                                        res = v13;
                                                                        Intrinsics.checkNotNullExpressionValue(res, "res");
                                                                        v0 = new MongoShellUpdateResult(res);
                                                                        break block74;
                                                                    }
                                                                    if (!Intrinsics.areEqual(type, "BulkWriteResult")) break block81;
                                                                    res = v;
                                                                    identifier$iv = "acknowledged";
                                                                    $i$f$get = false;
                                                                    v14 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v14);
                                                                    v15 = v14.asBoolean();
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "insertedCount";
                                                                    $i$f$get = false;
                                                                    v16 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v16);
                                                                    v17 = ((IntResult)MongoShellConverter.toJava$default(this, v16, null, 2, null)).getValue();
                                                                    $i$f$get = v;
                                                                    identifier$iv = "insertedIds";
                                                                    $i$f$get = false;
                                                                    v18 = $this$get$iv.getMember((String)identifier$iv);
                                                                    if (v18 == null) {
                                                                        v19 = null;
                                                                    } else {
                                                                        identifier$iv = v18;
                                                                        var17_47 = v17;
                                                                        var16_44 = v15;
                                                                        $i$a$-let-MongoShellConverter$toJava$2 = false;
                                                                        var18_60 = ((DocumentResult)MongoShellConverter.toJava$default(this, (Value)it, null, 2, null)).getValue();
                                                                        v15 = var16_44;
                                                                        v17 = var17_47;
                                                                        v19 = var18_60;
                                                                    }
                                                                    v20 = v19 == null ? MapsKt.emptyMap() : (Map<K, V>)v19;
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "matchedCount";
                                                                    $i$f$get = false;
                                                                    v21 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v21);
                                                                    v22 = ((IntResult)MongoShellConverter.toJava$default(this, v21, null, 2, null)).getValue();
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "modifiedCount";
                                                                    $i$f$get = false;
                                                                    v23 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v23);
                                                                    v24 = ((IntResult)MongoShellConverter.toJava$default(this, v23, null, 2, null)).getValue();
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "deletedCount";
                                                                    $i$f$get = false;
                                                                    v25 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v25);
                                                                    v26 = ((IntResult)MongoShellConverter.toJava$default(this, v25, null, 2, null)).getValue();
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "upsertedCount";
                                                                    $i$f$get = false;
                                                                    v27 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v27);
                                                                    v28 = ((IntResult)MongoShellConverter.toJava$default(this, v27, null, 2, null)).getValue();
                                                                    $this$get$iv = v;
                                                                    identifier$iv = "upsertedIds";
                                                                    $i$f$get = false;
                                                                    v29 = $this$get$iv.getMember(identifier$iv);
                                                                    Intrinsics.checkNotNull(v29);
                                                                    var23_62 = ((ArrayResult)MongoShellConverter.toJava$default(this, v29, null, 2, null)).getValue();
                                                                    var24_63 = v28;
                                                                    var25_64 = v26;
                                                                    var26_65 = v24;
                                                                    var27_66 = v22;
                                                                    var28_67 = v20;
                                                                    var29_68 = v17;
                                                                    var30_69 = v15;
                                                                    v0 = new BulkWriteResult(var30_69, var29_68, var28_67, var27_66, var26_65, var25_64, var24_63, (List<? extends Object>)var23_62);
                                                                    break block74;
                                                                }
                                                                if (!Intrinsics.areEqual(type, "InsertManyResult")) break block82;
                                                                $this$get$iv = v;
                                                                identifier$iv = "acknowledged";
                                                                $i$f$get = false;
                                                                v30 = $this$get$iv.getMember((String)identifier$iv);
                                                                Intrinsics.checkNotNull(v30);
                                                                v31 = v30.asBoolean();
                                                                identifier$iv = v;
                                                                identifier$iv = "insertedIds";
                                                                $i$f$get = false;
                                                                v32 = $this$get$iv.getMember(identifier$iv);
                                                                Intrinsics.checkNotNull(v32);
                                                                v33 = MongoShellConverter.toJava$default(this, v32, null, 2, null).getValue();
                                                                if (v33 == null) {
                                                                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                                                                }
                                                                v0 = new InsertManyResult(v31, (List)v33);
                                                                break block74;
                                                            }
                                                            $this$get$iv = v;
                                                            $this$get$iv = this.context;
                                                            clazz$iv = "RegExp";
                                                            $i$f$instanceOf = false;
                                                            $i$a$-let-MongoShellConverter$toJava$2 = new Object[]{$this$instanceOf$iv};
                                                            if (!context$iv.eval(Intrinsics.stringPlus("(x) => x instanceof ", clazz$iv), "instance_of_script").execute($i$a$-let-MongoShellConverter$toJava$2).asBoolean()) break block83;
                                                            context$iv = v;
                                                            identifier$iv = "source";
                                                            $i$f$get = false;
                                                            v34 = $this$get$iv.getMember((String)identifier$iv);
                                                            Intrinsics.checkNotNull(v34);
                                                            pattern = v34.asString();
                                                            identifier$iv = v;
                                                            identifier$iv = "flags";
                                                            $i$f$get = false;
                                                            v35 = $this$get$iv.getMember((String)identifier$iv);
                                                            Intrinsics.checkNotNull(v35);
                                                            flags1 = v35.asString();
                                                            f = 0;
                                                            Intrinsics.checkNotNullExpressionValue(flags1, "flags1");
                                                            if (StringsKt.contains$default((CharSequence)flags1, 'm', false, 2, null)) {
                                                                f |= 8;
                                                            }
                                                            if (StringsKt.contains$default((CharSequence)flags1, 'i', false, 2, null)) {
                                                                f |= 2;
                                                            }
                                                            identifier$iv = Pattern.compile((String)pattern, f);
                                                            Intrinsics.checkNotNullExpressionValue(identifier$iv, "compile(pattern, f)");
                                                            v0 = new PatternResult((Pattern)identifier$iv);
                                                            break block74;
                                                        }
                                                        pattern = v;
                                                        flags1 = this.context;
                                                        clazz$iv = this.bsonTypes.getMaxKey();
                                                        $i$f$instanceOf = false;
                                                        if (clazz$iv == null) ** GOTO lbl-1000
                                                        $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                                        if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                                            v36 = true;
                                                        } else lbl-1000:
                                                        // 2 sources

                                                        {
                                                            v36 = false;
                                                        }
                                                        if (!v36) break block84;
                                                        v0 = new MaxKeyResult();
                                                        break block74;
                                                    }
                                                    $this$instanceOf$iv = v;
                                                    context$iv = this.context;
                                                    clazz$iv = this.bsonTypes.getMinKey();
                                                    $i$f$instanceOf = false;
                                                    if (clazz$iv == null) ** GOTO lbl-1000
                                                    $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                                    if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                                        v37 = true;
                                                    } else lbl-1000:
                                                    // 2 sources

                                                    {
                                                        v37 = false;
                                                    }
                                                    if (!v37) break block85;
                                                    v0 = new MinKeyResult();
                                                    break block74;
                                                }
                                                $this$instanceOf$iv = v;
                                                context$iv = this.context;
                                                clazz$iv = this.bsonTypes.getObjectId();
                                                $i$f$instanceOf = false;
                                                if (clazz$iv == null) ** GOTO lbl-1000
                                                $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                                if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                                    v38 = true;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    v38 = false;
                                                }
                                                if (!v38) break block86;
                                                $this$instanceOf$iv = new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readObjectId();
                                                Intrinsics.checkNotNullExpressionValue($this$instanceOf$iv, "JsonReader(v.invokeMembe\u2026oString()).readObjectId()");
                                                v0 = new ObjectIdResult((ObjectId)$this$instanceOf$iv);
                                                break block74;
                                            }
                                            $this$instanceOf$iv = v;
                                            context$iv = this.context;
                                            clazz$iv = this.bsonTypes.getNumberDecimal();
                                            $i$f$instanceOf = false;
                                            if (clazz$iv == null) ** GOTO lbl-1000
                                            $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                            if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                                v39 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                v39 = false;
                                            }
                                            if (!v39) break block87;
                                            $this$instanceOf$iv = new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readDecimal128();
                                            Intrinsics.checkNotNullExpressionValue($this$instanceOf$iv, "JsonReader(v.invokeMembe\u2026tring()).readDecimal128()");
                                            v0 = new Decimal128Result((Decimal128)$this$instanceOf$iv);
                                            break block74;
                                        }
                                        $this$instanceOf$iv = v;
                                        context$iv = this.context;
                                        clazz$iv = this.bsonTypes.getNumberInt();
                                        $i$f$instanceOf = false;
                                        if (clazz$iv == null) ** GOTO lbl-1000
                                        $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                        if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                            v40 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v40 = false;
                                        }
                                        if (!v40) break block88;
                                        v0 = new IntResult(new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readInt32());
                                        break block74;
                                    }
                                    $this$instanceOf$iv = v;
                                    context$iv = this.context;
                                    clazz$iv = this.bsonTypes.getBsonSymbol();
                                    $i$f$instanceOf = false;
                                    if (clazz$iv == null) ** GOTO lbl-1000
                                    $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                    if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                        v41 = true;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v41 = false;
                                    }
                                    if (!v41) break block89;
                                    v0 = new SymbolResult(new Symbol(new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readSymbol()));
                                    break block74;
                                }
                                $this$instanceOf$iv = v;
                                context$iv = this.context;
                                clazz$iv = this.bsonTypes.getTimestamp();
                                $i$f$instanceOf = false;
                                if (clazz$iv == null) ** GOTO lbl-1000
                                $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                                if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                    v42 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v42 = false;
                                }
                                if (!v42) break block90;
                                context$iv = v.invokeMember("toExtendedJSON", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue(context$iv, "v.invokeMember(\"toExtendedJSON\")");
                                timestamp = new JsonReader(UtilKt.toLiteral(MongoShellConverter.toJava$default(this, (Value)context$iv, null, 2, null).getValue())).readTimestamp();
                                v0 = new BSONTimestampResult(new BSONTimestamp(timestamp.getTime(), timestamp.getInc()));
                                break block74;
                            }
                            timestamp = v;
                            context$iv = this.context;
                            clazz$iv = this.bsonTypes.getCode();
                            $i$f$instanceOf = false;
                            if (clazz$iv == null) ** GOTO lbl-1000
                            $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                            if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                                v43 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v43 = false;
                            }
                            if (!v43) break block91;
                            clazz$iv = v;
                            identifier$iv = "scope";
                            $i$f$get = false;
                            v44 = $this$get$iv.getMember(identifier$iv);
                            Intrinsics.checkNotNull(v44);
                            context$iv = MongoShellConverter.toJava$default(this, v44, null, 2, null).getValue();
                            scope = context$iv instanceof Document != false ? (Document)context$iv : null;
                            $this$get$iv = v;
                            identifier$iv = "code";
                            $i$f$get = false;
                            v45 = $this$get$iv.getMember(identifier$iv);
                            Intrinsics.checkNotNull(v45);
                            code = v45.asString();
                            v0 = scope == null ? (MongoShellResult)new CodeResult(new Code((String)code)) : (MongoShellResult)new CodeWithScopeResult(new CodeWithScope((String)code, (Document)scope));
                            break block74;
                        }
                        scope = v;
                        code = this.context;
                        clazz$iv = this.bsonTypes.getDbRef();
                        $i$f$instanceOf = false;
                        if (clazz$iv == null) ** GOTO lbl-1000
                        $i$f$get = new Object[]{$this$instanceOf$iv, clazz$iv};
                        if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute($i$f$get).asBoolean()) {
                            v46 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v46 = false;
                        }
                        if (!v46) break block92;
                        clazz$iv = v;
                        identifier$iv = "db";
                        $i$f$get = false;
                        v47 = $this$get$iv.getMember((String)identifier$iv);
                        if (v47 == null) {
                            v48 /* !! */  = null;
                        } else {
                            it = v47;
                            $i$a$-let-MongoShellConverter$toJava$databaseName$1 = false;
                            v49 = it.isNull() ? null : it;
                            v48 /* !! */  = v49 == null ? null : v49.asString();
                        }
                        databaseName = v48 /* !! */ ;
                        $this$get$iv = v;
                        identifier$iv = "collection";
                        $i$f$get = false;
                        v50 = $this$get$iv.getMember((String)identifier$iv);
                        Intrinsics.checkNotNull(v50);
                        collectionName = v50.asString();
                        identifier$iv = v;
                        identifier$iv = "oid";
                        $i$f$get = false;
                        v51 = $this$get$iv.getMember(identifier$iv);
                        Intrinsics.checkNotNull(v51);
                        v52 = MongoShellConverter.toJava$default(this, v51, null, 2, null).getValue();
                        Intrinsics.checkNotNull(v52);
                        value = v52;
                        v0 = new DBRefResult(new DBRef((String)databaseName, (String)collectionName, value));
                        break block74;
                    }
                    databaseName = v;
                    collectionName = this.context;
                    clazz$iv = this.bsonTypes.getNumberLong();
                    $i$f$instanceOf = false;
                    if (clazz$iv == null) ** GOTO lbl-1000
                    identifier$iv = new Object[]{$this$instanceOf$iv, clazz$iv};
                    if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute(identifier$iv).asBoolean()) {
                        v53 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v53 = false;
                    }
                    if (!v53) break block93;
                    v0 = new LongResult(new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readInt64());
                    break block74;
                }
                $this$instanceOf$iv = v;
                context$iv = this.context;
                clazz$iv = this.bsonTypes.getBinData();
                $i$f$instanceOf = false;
                if (clazz$iv == null) ** GOTO lbl-1000
                identifier$iv = new Object[]{$this$instanceOf$iv, clazz$iv};
                if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute(identifier$iv).asBoolean()) {
                    v54 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v54 = false;
                }
                if (!v54) break block94;
                binary = new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readBinaryData();
                clazz$iv = binary.getType();
                v55 /* !! */  = clazz$iv == BsonBinarySubType.UUID_STANDARD.getValue() ? UuidRepresentation.STANDARD : (uuidRepresentation /* !! */  = clazz$iv == BsonBinarySubType.UUID_LEGACY.getValue() ? UuidRepresentation.JAVA_LEGACY : null);
                if (uuidRepresentation /* !! */  != null && binary.getData().length == 16) {
                    clazz$iv = UuidHelper.decodeBinaryToUuid(binary.getData(), binary.getType(), (UuidRepresentation)uuidRepresentation /* !! */ );
                    Intrinsics.checkNotNullExpressionValue(clazz$iv, "decodeBinaryToUuid(binar\u2026type, uuidRepresentation)");
                    v0 = new UUIDResult(clazz$iv);
                } else {
                    v0 = new BinaryResult(new Binary(binary.getType(), binary.getData()));
                }
                break block74;
            }
            binary = v;
            uuidRepresentation /* !! */  = this.context;
            clazz$iv = this.bsonTypes.getHexData();
            $i$f$instanceOf = false;
            if (clazz$iv == null) ** GOTO lbl-1000
            identifier$iv = new Object[]{$this$instanceOf$iv, clazz$iv};
            if (context$iv.eval("(o, clazz) => o instanceof clazz", "instance_of_class_script").execute(identifier$iv).asBoolean()) {
                v56 = true;
            } else lbl-1000:
            // 2 sources

            {
                v56 = false;
            }
            if (v56) {
                binary = new JsonReader(v.invokeMember("toExtendedJSON", new Object[0]).toString()).readBinaryData();
                v0 = new BinaryResult(new Binary(binary.getType(), binary.getData()));
            } else if (v.isString()) {
                binary = v.asString();
                Intrinsics.checkNotNullExpressionValue(binary, "v.asString()");
                v0 = new StringResult((String)binary);
            } else if (v.isBoolean()) {
                v0 = new BooleanResult(v.asBoolean());
            } else if (v.fitsInInt()) {
                v0 = new IntResult(v.asInt());
            } else if (v.fitsInLong()) {
                v0 = new LongResult(v.asLong());
            } else if (v.fitsInFloat()) {
                v0 = new FloatResult(v.asFloat());
            } else if (v.fitsInDouble()) {
                v0 = new DoubleResult(v.asDouble());
            } else {
                binary = v;
                context$iv = this.context;
                value$iv = "undefined";
                $i$f$equalsTo = false;
                identifier$iv = new Object[]{$this$equalsTo$iv};
                if (context$iv.eval(Intrinsics.stringPlus("(x) => x === ", value$iv), "equals_script").execute(identifier$iv).asBoolean()) {
                    v0 = VoidResult.INSTANCE;
                } else if (v.isNull()) {
                    v0 = NullResult.INSTANCE;
                } else if (v.isHostObject() && v.asHostObject() instanceof Unit) {
                    v0 = VoidResult.INSTANCE;
                } else if (v.isHostObject() && v.asHostObject() instanceof Document) {
                    $this$equalsTo$iv = v.asHostObject();
                    Intrinsics.checkNotNullExpressionValue($this$equalsTo$iv, "v.asHostObject()");
                    v0 = new DocumentResult((Document)$this$equalsTo$iv);
                } else if (v.isHostObject() && v.asHostObject() instanceof ObjectId) {
                    $this$equalsTo$iv = v.asHostObject();
                    Intrinsics.checkNotNullExpressionValue($this$equalsTo$iv, "v.asHostObject()");
                    v0 = new ObjectIdResult((ObjectId)$this$equalsTo$iv);
                } else if (v.isHostObject() && v.asHostObject() instanceof UUID) {
                    $this$equalsTo$iv = v.asHostObject();
                    Intrinsics.checkNotNullExpressionValue($this$equalsTo$iv, "v.asHostObject()");
                    v0 = new UUIDResult((UUID)$this$equalsTo$iv);
                } else if (v.isHostObject() && v.asHostObject() instanceof Date) {
                    $this$equalsTo$iv = v.asHostObject();
                    Intrinsics.checkNotNullExpressionValue($this$equalsTo$iv, "v.asHostObject()");
                    v0 = new DateResult((Date)$this$equalsTo$iv);
                } else if (v.hasArrayElements()) {
                    $this$map$iv = (Set<String>)RangesKt.until(0, v.getArraySize());
                    $i$f$map = false;
                    value$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    var8_71 = $this$mapTo$iv$iv.iterator();
                    while (var8_71.hasNext()) {
                        var11_75 = item$iv$iv = ((LongIterator)var8_71).nextLong();
                        var16_45 = destination$iv$iv;
                        $i$a$-map-MongoShellConverter$toJava$3 = false;
                        var14_79 = v.getArrayElement((long)it);
                        Intrinsics.checkNotNullExpressionValue(var14_79, "v.getArrayElement(it)");
                        var16_45.add(MongoShellConverter.toJava$default(this, var14_79, null, 2, null).getValue());
                    }
                    var31_81 = (List)destination$iv$iv;
                    v0 = new ArrayResult(var31_81);
                } else if (v.canExecute()) {
                    v0 = FunctionResult.INSTANCE;
                } else if (v.hasMembers()) {
                    $this$map$iv = v.getMemberKeys();
                    Intrinsics.checkNotNullExpressionValue($this$map$iv, "v.memberKeys");
                    $this$associateWith$iv = $this$map$iv;
                    $i$f$associateWith = false;
                    result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                    $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    $i$f$associateWithTo = false;
                    for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                        it = (String)element$iv$iv;
                        var19_84 = element$iv$iv;
                        var18_61 = result$iv;
                        $i$a$-associateWith-MongoShellConverter$toJava$4 = false;
                        $i$a$-map-MongoShellConverter$toJava$3 = v;
                        Intrinsics.checkNotNullExpressionValue(key, "key");
                        identifier$iv = key;
                        $i$f$get = false;
                        v57 = $this$get$iv.getMember((String)identifier$iv);
                        Intrinsics.checkNotNull(v57);
                        var20_85 = MongoShellConverter.toJava$default(this, v57, null, 2, null).getValue();
                        var18_61.put(var19_84, var20_85);
                    }
                    var32_86 = result$iv;
                    var33_87 = new Document(var32_86);
                    v0 = new DocumentResult(var33_87);
                } else {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("unknown result: ", v));
                }
            }
        }
        return v0;
    }

    public static /* synthetic */ MongoShellResult toJava$default(MongoShellConverter mongoShellConverter, Value value, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return mongoShellConverter.toJava(value, string);
    }

    private static final Object toJavaPromise$lambda-6$lambda-4(CompletableFuture $future, Value[] args2) {
        Intrinsics.checkNotNullParameter($future, "$future");
        return $future.complete(args2[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object toJavaPromise$lambda-6$lambda-5(CompletableFuture $future, MongoShellConverter this$0, Value[] args2) {
        boolean bl;
        Intrinsics.checkNotNullParameter($future, "$future");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Value error = args2[0];
        if (error.isHostObject() && error.asHostObject() instanceof Throwable) {
            Object t = error.asHostObject();
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Throwable");
            }
            bl = $future.completeExceptionally((Throwable)t);
        } else {
            void context$iv;
            void $this$instanceOf$iv;
            Intrinsics.checkNotNullExpressionValue(error, "error");
            Value value = error;
            MongoShellContext mongoShellContext = this$0.context;
            String clazz$iv = "Error";
            boolean $i$f$instanceOf = false;
            Object[] objectArray = new Object[]{$this$instanceOf$iv};
            String message = context$iv.eval(Intrinsics.stringPlus("(x) => x instanceof ", clazz$iv), "instance_of_script").execute(objectArray).asBoolean() ? error.getMember("stack").asString() : error.toString();
            bl = $future.completeExceptionally(new Exception(message));
        }
        return bl;
    }
}

