/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh;

import com.mongodb.client.MongoClient;
import com.mongodb.mongosh.MongoShellContext;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.MongoShellEvaluatorKt;
import com.mongodb.mongosh.MongoshDate;
import com.mongodb.mongosh.ValueWrapper;
import com.mongodb.mongosh.service.JavaServiceProvider;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\fJ\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002J\b\u0010%\u001a\u00020\fH\u0002J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001bH\u0002J\b\u0010*\u001a\u00020\u0013H\u0002J\u001b\u0010+\u001a\u0004\u0018\u00010,*\u00020-2\u0006\u0010.\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00100R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/mongodb/mongosh/MongoShellEvaluator;", "", "client", "Lcom/mongodb/client/MongoClient;", "context", "Lcom/mongodb/mongosh/MongoShellContext;", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "wrapper", "Lcom/mongodb/mongosh/ValueWrapper;", "(Lcom/mongodb/client/MongoClient;Lcom/mongodb/mongosh/MongoShellContext;Lcom/mongodb/mongosh/MongoShellConverter;Lcom/mongodb/mongosh/ValueWrapper;)V", "getShellApiTypeFn", "Lorg/graalvm/polyglot/Value;", "serviceProvider", "Lcom/mongodb/mongosh/service/JavaServiceProvider;", "shellEvaluator", "shellInstanceState", "toShellResultFn", "close", "", "dateHelper", "createObject", "", "args", "", "eval", "script", "", "name", "getShellApiType", "rawValue", "initContext", "bindings", "global", "parseDate", "Ljava/util/Date;", "str", "resultHandler", "setClient", "shellResult", "printable", "type", "updateDatabase", "safeGet", "", "Ljava/time/temporal/TemporalAccessor;", "field", "Ljava/time/temporal/TemporalField;", "(Ljava/time/temporal/TemporalAccessor;Ljava/time/temporal/TemporalField;)Ljava/lang/Integer;", "JMongosh"})
public final class MongoShellEvaluator {
    @NotNull
    private final MongoShellContext context;
    @NotNull
    private final MongoShellConverter converter;
    @NotNull
    private final JavaServiceProvider serviceProvider;
    @NotNull
    private final Value shellEvaluator;
    @NotNull
    private final Value shellInstanceState;
    @NotNull
    private final Value toShellResultFn;
    @NotNull
    private final Value getShellApiTypeFn;

    /*
     * WARNING - void declaration
     */
    public MongoShellEvaluator(@Nullable MongoClient client, @NotNull MongoShellContext context, @NotNull MongoShellConverter converter, @NotNull ValueWrapper wrapper) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        this.context = context;
        this.converter = converter;
        this.serviceProvider = new JavaServiceProvider(client, this.converter, wrapper);
        this.context.eval(MongoShellEvaluatorKt.access$getSetupScript());
        Object[] objectArray = this.context.getBindings();
        String identifier$iv = "_global";
        boolean $i$f$get = false;
        Value value = $this$get$iv.getMember(identifier$iv);
        Intrinsics.checkNotNull(value);
        Value global = value;
        this.context.getBindings().removeMember("_global");
        Object[] objectArray2 = new Object[]{this.serviceProvider};
        objectArray = global.getMember("ShellInstanceState").newInstance(objectArray2);
        Intrinsics.checkNotNullExpressionValue(objectArray, "global.getMember(\"ShellI\u2026Instance(serviceProvider)");
        this.shellInstanceState = objectArray;
        objectArray2 = new Object[]{this.shellInstanceState, this.resultHandler()};
        objectArray = global.getMember("ShellEvaluator").newInstance(objectArray2);
        Intrinsics.checkNotNullExpressionValue(objectArray, "global.getMember(\"ShellE\u2026ceState, resultHandler())");
        this.shellEvaluator = objectArray;
        objectArray = global.getMember("toShellResult");
        Intrinsics.checkNotNullExpressionValue(objectArray, "global.getMember(\"toShellResult\")");
        this.toShellResultFn = objectArray;
        objectArray = global.getMember("getShellApiType");
        Intrinsics.checkNotNullExpressionValue(objectArray, "global.getMember(\"getShellApiType\")");
        this.getShellApiTypeFn = objectArray;
        objectArray = new Object[]{this.context.getBindings()};
        this.shellInstanceState.invokeMember("setCtx", objectArray);
        this.initContext(this.context.getBindings(), global);
    }

    private final Value resultHandler() {
        return this.context.jsFun((Function1<? super Value[], ? extends Object>)new Function1<Value[], Object>(this){
            final /* synthetic */ MongoShellEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull Value[] args2) {
                Value value;
                Intrinsics.checkNotNullParameter(args2, "args");
                if (args2.length != 1) {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected one argument. Got ").append(args2.length).append(' ');
                    String string = Arrays.toString(args2);
                    Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
                    throw new IllegalArgumentException(stringBuilder.append(string).toString());
                }
                Value rawValue = args2[0];
                String type = this.this$0.getShellApiType(rawValue);
                if (Intrinsics.areEqual(type, "Cursor") ? true : Intrinsics.areEqual(type, "AggregationCursor")) {
                    value = MongoShellEvaluator.access$shellResult(this.this$0, rawValue, type);
                } else {
                    Object[] objectArray = new Object[]{rawValue};
                    value = MongoShellEvaluator.access$getToShellResultFn$p(this.this$0).execute(objectArray);
                }
                return value;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void initContext(Value bindings, Value global) {
        void $this$set$iv;
        Value $this$get$iv;
        Object identifier$iv;
        Value $this$set$iv2;
        Object object = new Object[]{arg_0 -> MongoShellEvaluator.initContext$lambda-0(this, arg_0)};
        Value date = this.context.eval("(dateHelper) => function inner() { return dateHelper(new.target !== undefined, ...arguments) }", "dateHelper_script").execute(object);
        Intrinsics.checkNotNullExpressionValue(date, "date");
        object = date;
        String string = "now";
        ProxyExecutable value$iv = MongoShellEvaluator::initContext$lambda-1;
        boolean $i$f$set = false;
        $this$set$iv2.putMember((String)identifier$iv, value$iv);
        $this$set$iv2 = bindings;
        identifier$iv = "Date";
        boolean $i$f$set2 = false;
        $this$set$iv2.putMember((String)identifier$iv, date);
        $this$set$iv2 = bindings;
        identifier$iv = "ISODate";
        Value value$iv2 = this.context.jsFun((Function1<? super Value[], ? extends Object>)new Function1<Value[], Object>(this){
            final /* synthetic */ MongoShellEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull Value[] args2) {
                Intrinsics.checkNotNullParameter(args2, "args");
                return MongoShellEvaluator.access$dateHelper(this.this$0, true, ArraysKt.toList(args2));
            }
        });
        $i$f$set = false;
        $this$set$iv2.putMember((String)identifier$iv, value$iv2);
        SecureRandom secureRandom = new SecureRandom();
        identifier$iv = global;
        String identifier$iv2 = "crypto";
        boolean $i$f$get = false;
        Value value = $this$get$iv.getMember(identifier$iv2);
        Intrinsics.checkNotNull(value);
        $this$get$iv = value;
        identifier$iv2 = "randomBytes";
        Value value$iv3 = this.context.jsFun((Function1<? super Value[], ? extends Object>)new Function1<Value[], Object>(secureRandom, this){
            final /* synthetic */ SecureRandom $secureRandom;
            final /* synthetic */ MongoShellEvaluator this$0;
            {
                this.$secureRandom = $secureRandom;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull Value[] args2) {
                Intrinsics.checkNotNullParameter(args2, "args");
                if (args2.length != 1) {
                    StringBuilder stringBuilder = new StringBuilder().append("Expected one argument. Got ").append(args2.length).append(' ');
                    String string = Arrays.toString(args2);
                    Intrinsics.checkNotNullExpressionValue(string, "toString(this)");
                    throw new IllegalArgumentException(stringBuilder.append(string).toString());
                }
                byte[] randomBytes = new byte[args2[0].asInt()];
                this.$secureRandom.nextBytes(randomBytes);
                return MongoShellEvaluator.access$getConverter$p(this.this$0).toBuffer(randomBytes);
            }
        });
        boolean $i$f$set3 = false;
        $this$set$iv.putMember(identifier$iv2, value$iv3);
    }

    private final Value shellResult(Value printable, String type) {
        Object[] objectArray = new Object[]{printable, type};
        Value value = MongoShellContext.eval$default(this.context, "(printable, type) => ({printable: printable, type: type})", null, 2, null).execute(objectArray);
        Intrinsics.checkNotNullExpressionValue(value, "context.eval(\"(printable\u2026.execute(printable, type)");
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object dateHelper(boolean createObject, List<Value> args2) {
        Object object;
        Date date;
        Date date2;
        if (args2.isEmpty()) {
            date2 = new MongoshDate(System.currentTimeMillis());
        } else if (args2.size() == 1) {
            Object v = MongoShellConverter.toJava$default(this.converter, args2.get(0), null, 2, null).getValue();
            if (v instanceof String) {
                date2 = this.parseDate((String)v);
            } else {
                if (!(v instanceof Number)) throw new IllegalArgumentException("Expected number or string. Got: " + args2.get(0) + " (" + v + ')');
                date2 = new MongoshDate(((Number)v).longValue());
            }
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            boolean bl;
            block12: {
                Iterable $this$any$iv = args2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Value it = (Value)element$iv;
                        boolean bl2 = false;
                        if (!(!it.fitsInInt())) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Expected list of numbers. Got: ", args2));
            }
            Value value = CollectionsKt.getOrNull(args2, 1);
            Value value2 = CollectionsKt.getOrNull(args2, 2);
            Value value3 = CollectionsKt.getOrNull(args2, 3);
            Value value4 = CollectionsKt.getOrNull(args2, 4);
            Value value5 = CollectionsKt.getOrNull(args2, 5);
            Value value6 = CollectionsKt.getOrNull(args2, 6);
            LocalDateTime localDateTime = LocalDateTime.of(args2.get(0).asInt(), value == null ? 1 : (n6 = value.asInt()), value2 == null ? 1 : (n5 = value2.asInt()), value3 == null ? 0 : (n4 = value3.asInt()), value4 == null ? 0 : (n3 = value4.asInt()), value5 == null ? 0 : (n2 = value5.asInt()), value6 == null ? 0 : (n = value6.asInt()));
            date2 = date = (Date)new MongoshDate(localDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        if (createObject) {
            object = date;
            return object;
        } else {
            String string = date.toString();
            Intrinsics.checkNotNullExpressionValue(string, "date.toString()");
            object = string;
        }
        return object;
    }

    private final Date parseDate(String str) {
        TemporalAccessor accessor = MongoShellEvaluatorKt.access$getDATE_FORMATTER$p().parse(str);
        Intrinsics.checkNotNullExpressionValue(accessor, "accessor");
        Integer n = this.safeGet(accessor, ChronoField.YEAR);
        Integer n2 = this.safeGet(accessor, ChronoField.MONTH_OF_YEAR);
        Integer n3 = this.safeGet(accessor, ChronoField.DAY_OF_MONTH);
        Integer n4 = this.safeGet(accessor, ChronoField.HOUR_OF_DAY);
        Integer n5 = this.safeGet(accessor, ChronoField.MINUTE_OF_HOUR);
        Integer n6 = this.safeGet(accessor, ChronoField.SECOND_OF_MINUTE);
        Integer n7 = this.safeGet(accessor, ChronoField.NANO_OF_SECOND);
        Integer n8 = this.safeGet(accessor, ChronoField.OFFSET_SECONDS);
        OffsetDateTime dateTime = OffsetDateTime.of(n == null ? 0 : n, n2 == null ? 1 : n2, n3 == null ? 1 : n3, n4 == null ? 0 : n4, n5 == null ? 0 : n5, n6 == null ? 0 : n6, n7 == null ? 0 : n7, ZoneOffset.ofTotalSeconds(n8 == null ? 0 : n8));
        return new MongoshDate(dateTime.toInstant().toEpochMilli());
    }

    private final Integer safeGet(TemporalAccessor $this$safeGet, TemporalField field) {
        try {
            return $this$safeGet.get(field);
        }
        catch (UnsupportedTemporalTypeException unsupportedTemporalTypeException) {
            return null;
        }
    }

    @Nullable
    public final String getShellApiType(@NotNull Value rawValue) {
        Intrinsics.checkNotNullParameter(rawValue, "rawValue");
        Object[] objectArray = new Object[]{rawValue};
        Value rawType = this.getShellApiTypeFn.execute(objectArray);
        return rawType.isString() ? rawType.asString() : null;
    }

    @NotNull
    public final Value eval(@Language(value="js") @NotNull String script, @NotNull String name) {
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(name, "name");
        this.updateDatabase();
        ProxyExecutable originalEval = arg_0 -> MongoShellEvaluator.eval$lambda-3(this, name, arg_0);
        Object[] objectArray = new Object[]{originalEval, script};
        Value value = this.shellEvaluator.invokeMember("customEval", objectArray);
        Intrinsics.checkNotNullExpressionValue(value, "shellEvaluator.invokeMem\u2026l\", originalEval, script)");
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDatabase() {
        String string;
        void $this$get$iv;
        Value currentDb = MongoShellContext.eval$default(this.context, "db", null, 2, null);
        Value nameGetter = MongoShellContext.eval$default(this.context, "(db) => db.getName()", null, 2, null);
        Object[] objectArray = new Object[]{currentDb};
        String currentDbName = nameGetter.execute(objectArray).asString();
        Value value = this.shellInstanceState;
        String identifier$iv = "currentDb";
        boolean $i$f$get = false;
        Value value2 = $this$get$iv.getMember(identifier$iv);
        if (value2 == null) {
            string = null;
        } else {
            Value it = value2;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{it};
            string = nameGetter.execute(objectArray2).asString();
        }
        String stateDbName = string;
        if (!Intrinsics.areEqual(currentDbName, stateDbName)) {
            Object[] objectArray3 = new Object[]{currentDb};
            this.shellInstanceState.invokeMember("setDbFunc", objectArray3);
        }
    }

    public final void close() {
        this.context.close();
    }

    public final void setClient(@NotNull MongoClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.serviceProvider.setClient(client);
    }

    private static final Object initContext$lambda-0(MongoShellEvaluator this$0, Value[] args2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        boolean bl = args2[0].asBoolean();
        Intrinsics.checkNotNullExpressionValue(args2, "args");
        return this$0.dateHelper(bl, ArraysKt.drop(args2, 1));
    }

    private static final Object initContext$lambda-1(Value[] it) {
        return System.currentTimeMillis();
    }

    private static final Object eval$lambda-3(MongoShellEvaluator this$0, String $name, Value[] args2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($name, "$name");
        MongoShellContext mongoShellContext = this$0.context;
        String string = args2[0].asString();
        Intrinsics.checkNotNullExpressionValue(string, "args[0].asString()");
        return mongoShellContext.eval(string, $name);
    }

    public static final /* synthetic */ Value access$shellResult(MongoShellEvaluator $this, Value printable, String type) {
        return $this.shellResult(printable, type);
    }

    public static final /* synthetic */ Value access$getToShellResultFn$p(MongoShellEvaluator $this) {
        return $this.toShellResultFn;
    }

    public static final /* synthetic */ Object access$dateHelper(MongoShellEvaluator $this, boolean createObject, List args2) {
        return $this.dateHelper(createObject, args2);
    }

    public static final /* synthetic */ MongoShellConverter access$getConverter$p(MongoShellEvaluator $this) {
        return $this.converter;
    }
}

