/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.ReadPreference;
import com.mongodb.TagSet;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.result.DocumentResult;
import com.mongodb.mongosh.service.AggregateCreateOptions;
import com.mongodb.mongosh.service.BaseMongoIterableHelper;
import com.mongodb.mongosh.service.BaseMongoIterableHelperKt;
import com.mongodb.mongosh.service.Either;
import com.mongodb.mongosh.service.OptionConvertersKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u00020\u0001B+\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000e2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$H\u0016RB\u0010\f\u001a0\u0012\u0004\u0012\u00020\u000e\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00100\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0013\u001a*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/mongodb/mongosh/service/AggregateIterableHelper;", "Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;", "Lcom/mongodb/client/AggregateIterable;", "", "iterable", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "options", "Lorg/bson/Document;", "createOptions", "Lcom/mongodb/mongosh/service/AggregateCreateOptions;", "(Lcom/mongodb/client/AggregateIterable;Lcom/mongodb/mongosh/MongoShellConverter;Lorg/bson/Document;Lcom/mongodb/mongosh/service/AggregateCreateOptions;)V", "converters", "", "", "Lkotlin/Function2;", "Lcom/mongodb/mongosh/service/Either;", "getConverters", "()Ljava/util/Map;", "defaultConverter", "Lkotlin/Function3;", "getDefaultConverter", "()Lkotlin/jvm/functions/Function3;", "collation", "", "v", "comment", "explain", "verbosity", "hint", "maxTimeMS", "", "readConcern", "Lorg/graalvm/polyglot/Value;", "readPrev", "tags", "", "Lcom/mongodb/TagSet;", "JMongosh"})
public final class AggregateIterableHelper
extends BaseMongoIterableHelper<AggregateIterable<? extends Object>> {
    @Nullable
    private final AggregateCreateOptions createOptions;
    @NotNull
    private final Map<String, Function2<AggregateIterable<?>, Object, Either<AggregateIterable<?>>>> converters;
    @NotNull
    private final Function3<AggregateIterable<?>, String, Object, Either<AggregateIterable<?>>> defaultConverter;

    public AggregateIterableHelper(@NotNull AggregateIterable<?> iterable, @NotNull MongoShellConverter converter, @NotNull Document options, @Nullable AggregateCreateOptions createOptions) {
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(options, "options");
        super((MongoIterable)iterable, converter, options);
        this.createOptions = createOptions;
        this.converters = OptionConvertersKt.getAggregateConverters();
        this.defaultConverter = OptionConvertersKt.getAggregateDefaultConverter();
    }

    @Override
    @NotNull
    public Map<String, Function2<AggregateIterable<?>, Object, Either<AggregateIterable<?>>>> getConverters() {
        return this.converters;
    }

    @Override
    @NotNull
    public Function3<AggregateIterable<?>, String, Object, Either<AggregateIterable<?>>> getDefaultConverter() {
        return this.defaultConverter;
    }

    @Override
    @Nullable
    public Object explain(@Nullable String verbosity) {
        if (!(this.createOptions != null)) {
            boolean bl = false;
            String string = "createOptions were not saved";
            throw new IllegalStateException(string.toString());
        }
        Document explain = new Document();
        Map map = explain;
        Object object = this.createOptions.getCollection();
        if (object == null) {
            object = 1;
        }
        map.put("aggregate", object);
        ((Map)explain).put("pipeline", this.createOptions.getPipeline());
        ((Map)explain).put("explain", true);
        explain.putAll(this.getOptions());
        return this.createOptions.getDb().runCommand(explain);
    }

    @NotNull
    public AggregateIterableHelper readPrev(@NotNull String v, @Nullable List<TagSet> tags) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-AggregateIterableHelper$readPrev$22 = false;
            String $i$a$-check-AggregateIterableHelper$readPrev$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-AggregateIterableHelper$readPrev$22.toString());
        }
        MongoDatabase newDb = tags == null ? this.createOptions.getDb().withReadPreference(ReadPreference.valueOf(v)) : this.createOptions.getDb().withReadPreference(ReadPreference.valueOf(v, tags));
        Intrinsics.checkNotNullExpressionValue(newDb, "newDb");
        AggregateCreateOptions newCreateOptions = AggregateCreateOptions.copy$default(this.createOptions, newDb, null, null, 6, null);
        AggregateIterable<Document> newIterable = BaseMongoIterableHelperKt.aggregate(this.getOptions(), newCreateOptions);
        return new AggregateIterableHelper(newIterable, this.getConverter(), this.getOptions(), newCreateOptions);
    }

    @NotNull
    public AggregateIterableHelper readConcern(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-AggregateIterableHelper$readConcern$22 = false;
            String $i$a$-check-AggregateIterableHelper$readConcern$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-AggregateIterableHelper$readConcern$22.toString());
        }
        if (!v.hasMembers()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("document was expected. Got ", v));
        }
        MongoDatabase newDb = OptionConvertersKt.getReadConcernConverter().invoke(this.createOptions.getDb(), ((DocumentResult)MongoShellConverter.toJava$default(this.getConverter(), v, null, 2, null)).getValue()).getOrThrow();
        AggregateCreateOptions newCreateOptions = AggregateCreateOptions.copy$default(this.createOptions, newDb, null, null, 6, null);
        AggregateIterable<Document> newIterable = BaseMongoIterableHelperKt.aggregate(this.getOptions(), newCreateOptions);
        return new AggregateIterableHelper(newIterable, this.getConverter(), this.getOptions(), newCreateOptions);
    }

    @Override
    public void maxTimeMS(long v) {
        this.set("maxTimeMS", v);
    }

    @Override
    public void comment(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("comment", v);
    }

    @Override
    public void hint(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("hint", v);
    }

    @Override
    public void collation(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("collation", v);
    }
}

