/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.TagSet;
import com.mongodb.client.MongoIterable;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.service.Either;
import com.mongodb.mongosh.service.OptionConvertersKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b \u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u0004\u0018\u00010\u00032\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0006\u0010(\u001a\u00020 J\u0006\u0010)\u001a\u00020 J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020$H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\b\u0010-\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\bH\u0016J\u0014\u00100\u001a\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u001f\u001a\u000201H\u0016J$\u00102\u001a\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u001f\u001a\u00020\u000e2\u000e\u00103\u001a\n\u0012\u0004\u0012\u000205\u0018\u000104H\u0016J\u0010\u00106\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u000207H\u0016J\u001a\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\u000e2\b\u0010:\u001a\u0004\u0018\u00010\u0003H\u0004J\u0010\u0010;\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010<\u001a\u00020\u001d2\u0006\u0010=\u001a\u00020\bH\u0016J\b\u0010>\u001a\u00020\u001dH\u0016J\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000304R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR8\u0010\f\u001a(\u0012\u0004\u0012\u00020\u000e\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u000f0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R2\u0010\u0013\u001a\"\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006@"}, d2={"Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;", "T", "Lcom/mongodb/client/MongoIterable;", "", "iterable", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "options", "Lorg/bson/Document;", "(Lcom/mongodb/client/MongoIterable;Lcom/mongodb/mongosh/MongoShellConverter;Lorg/bson/Document;)V", "getConverter", "()Lcom/mongodb/mongosh/MongoShellConverter;", "converters", "", "", "Lkotlin/Function2;", "Lcom/mongodb/mongosh/service/Either;", "getConverters", "()Ljava/util/Map;", "defaultConverter", "Lkotlin/Function3;", "getDefaultConverter", "()Lkotlin/jvm/functions/Function3;", "getIterable", "()Lcom/mongodb/client/MongoIterable;", "Lcom/mongodb/client/MongoIterable;", "getOptions", "()Lorg/bson/Document;", "allowPartialResults", "", "batchSize", "v", "", "collation", "comment", "count", "", "explain", "verbosity", "hint", "itcount", "limit", "max", "maxTimeMS", "min", "noCursorTimeout", "oplogReplay", "projection", "readConcern", "Lorg/graalvm/polyglot/Value;", "readPrev", "tags", "", "Lcom/mongodb/TagSet;", "returnKey", "", "set", "key", "value", "skip", "sort", "spec", "tailable", "toArray", "JMongosh"})
public abstract class BaseMongoIterableHelper<T extends MongoIterable<?>> {
    @NotNull
    private final T iterable;
    @NotNull
    private final MongoShellConverter converter;
    @NotNull
    private final Document options;

    public BaseMongoIterableHelper(@NotNull T iterable, @NotNull MongoShellConverter converter, @NotNull Document options) {
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(options, "options");
        this.iterable = iterable;
        this.converter = converter;
        this.options = options;
    }

    @NotNull
    public final T getIterable() {
        return this.iterable;
    }

    @NotNull
    protected final MongoShellConverter getConverter() {
        return this.converter;
    }

    @NotNull
    protected final Document getOptions() {
        return this.options;
    }

    @NotNull
    public abstract Map<String, Function2<T, Object, Either<T>>> getConverters();

    @NotNull
    public abstract Function3<T, String, Object, Either<T>> getDefaultConverter();

    public final int itcount() {
        return CollectionsKt.count((Iterable)this.iterable);
    }

    @NotNull
    public final List<Object> toArray() {
        return CollectionsKt.toList((Iterable)this.iterable);
    }

    public final void batchSize(int v) {
        this.set("batchSize", v);
    }

    public void limit(int v) {
        throw new NotImplementedError("limit is not supported");
    }

    public final int limit() {
        Object object = this.options.get("limit");
        Integer n = object instanceof Integer ? (Integer)object : null;
        return n == null ? -1 : n;
    }

    public void max(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("max is not supported");
    }

    public void min(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("min is not supported");
    }

    public void projection(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("projection is not supported");
    }

    public void skip(int v) {
        throw new NotImplementedError("skip is not supported");
    }

    public void comment(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("comment is not supported");
    }

    public void hint(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("hint is not supported");
    }

    public void hint(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("hint is not supported");
    }

    public void collation(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("collation is not supported");
    }

    public void allowPartialResults() {
        throw new NotImplementedError("allowPartialResults is not supported");
    }

    public long count() {
        throw new NotImplementedError("count is not supported");
    }

    public void maxTimeMS(long v) {
        throw new NotImplementedError("maxTimeMS is not supported");
    }

    public void noCursorTimeout() {
        throw new NotImplementedError("noCursorTimeout is not supported");
    }

    public void oplogReplay() {
        throw new NotImplementedError("oplogReplay is not supported");
    }

    public void returnKey(boolean v) {
        throw new NotImplementedError("returnKey is not supported");
    }

    public void sort(@NotNull Document spec) {
        Intrinsics.checkNotNullParameter(spec, "spec");
        throw new NotImplementedError("sort is not supported");
    }

    public void tailable() {
        throw new NotImplementedError("tailable is not supported");
    }

    @Nullable
    public Object explain(@Nullable String verbosity) {
        throw new NotImplementedError("explain is not supported");
    }

    @NotNull
    public BaseMongoIterableHelper<?> readPrev(@NotNull String v, @Nullable List<TagSet> tags) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("readPrev is not supported");
    }

    @NotNull
    public BaseMongoIterableHelper<?> readConcern(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        throw new NotImplementedError("readConcern is not supported");
    }

    protected final void set(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, "key");
        ((Map)this.options).put(key, value);
        OptionConvertersKt.convert(this.iterable, this.getConverters(), this.getDefaultConverter(), MapsKt.mapOf(TuplesKt.to(key, value)));
    }
}

