/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.service.AggregateCreateOptions;
import com.mongodb.mongosh.service.AggregateIterableHelper;
import com.mongodb.mongosh.service.BaseMongoIterableHelper;
import com.mongodb.mongosh.service.FindCreateOptions;
import com.mongodb.mongosh.service.FindIterableHelper;
import com.mongodb.mongosh.service.MongoIterableHelper;
import com.mongodb.mongosh.service.OptionConvertersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\bH\u0000\u001a&\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0010\u0010\u000b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"aggregate", "Lcom/mongodb/client/AggregateIterable;", "Lorg/bson/Document;", "options", "createOptions", "Lcom/mongodb/mongosh/service/AggregateCreateOptions;", "find", "Lcom/mongodb/client/FindIterable;", "Lcom/mongodb/mongosh/service/FindCreateOptions;", "helper", "Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;", "iterable", "Lcom/mongodb/client/MongoIterable;", "", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "JMongosh"})
public final class BaseMongoIterableHelperKt {
    @NotNull
    public static final FindIterable<Document> find(@NotNull Document options, @NotNull FindCreateOptions createOptions) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(createOptions, "createOptions");
        String coll = createOptions.getCollection();
        MongoDatabase db = createOptions.getDb();
        Document find = createOptions.getFind();
        FindIterable<Document> iterable = db.getCollection(coll).find(find);
        Intrinsics.checkNotNullExpressionValue(iterable, "iterable");
        OptionConvertersKt.convert(iterable, OptionConvertersKt.getFindConverters(), OptionConvertersKt.getFindDefaultConverter(), options).getOrThrow();
        return iterable;
    }

    @NotNull
    public static final AggregateIterable<Document> aggregate(@NotNull Document options, @NotNull AggregateCreateOptions createOptions) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(createOptions, "createOptions");
        String coll = createOptions.getCollection();
        MongoDatabase db = createOptions.getDb();
        List<Document> pipeline = createOptions.getPipeline();
        AggregateIterable<Document> iterable = coll == null ? db.aggregate(pipeline) : db.getCollection(coll).aggregate(pipeline);
        Intrinsics.checkNotNullExpressionValue(iterable, "iterable");
        OptionConvertersKt.convert(iterable, OptionConvertersKt.getAggregateConverters(), OptionConvertersKt.getAggregateDefaultConverter(), options).getOrThrow();
        return iterable;
    }

    @NotNull
    public static final BaseMongoIterableHelper<?> helper(@NotNull MongoIterable<? extends Object> iterable, @NotNull MongoShellConverter converter) {
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        Intrinsics.checkNotNullParameter(converter, "converter");
        MongoIterable<? extends Object> mongoIterable = iterable;
        return mongoIterable instanceof FindIterable ? (BaseMongoIterableHelper)new FindIterableHelper((FindIterable)iterable, converter, new Document(), null) : (mongoIterable instanceof AggregateIterable ? (BaseMongoIterableHelper)new AggregateIterableHelper((AggregateIterable)iterable, converter, new Document(), null) : (BaseMongoIterableHelper)new MongoIterableHelper(iterable, converter, new Document()));
    }
}

