/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.client.MongoCursor;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.ValueWrapper;
import com.mongodb.mongosh.result.DocumentResult;
import com.mongodb.mongosh.service.BaseMongoIterableHelper;
import com.mongodb.mongosh.service.ServiceProviderCursor;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0015H\u0017J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0017J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011H\u0017J\b\u0010 \u001a\u00020!H\u0017J\u0014\u0010\"\u001a\u0004\u0018\u00010\r2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0017J\u0012\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r0\fH\u0002J\b\u0010%\u001a\u00020\nH\u0017J\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\b\u0010'\u001a\u00020\nH\u0017J\b\u0010(\u001a\u00020\u0015H\u0017J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0015H\u0017J\u0010\u0010*\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\u0010\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020!H\u0017J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\n\u0010/\u001a\u0004\u0018\u00010\rH\u0017J\u0010\u00100\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\u0010\u00101\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\u0010\u00102\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u00103\u001a\u00020\u001dH\u0017J\u0010\u00104\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0015H\u0017J\u0010\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u001dH\u0017J\n\u00107\u001a\u0004\u0018\u00010\rH\u0017J\u001a\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010:\u001a\u0004\u0018\u00010\u001dH\u0002J\n\u0010;\u001a\u0004\u0018\u00010\rH\u0017J\u0010\u0010<\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u001dH\u0017J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011H\u0017R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/mongodb/mongosh/service/Cursor;", "Lcom/mongodb/mongosh/service/ServiceProviderCursor;", "helper", "Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "wrapper", "Lcom/mongodb/mongosh/ValueWrapper;", "(Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;Lcom/mongodb/mongosh/MongoShellConverter;Lcom/mongodb/mongosh/ValueWrapper;)V", "closed", "", "iterator", "Lcom/mongodb/client/MongoCursor;", "", "resultsUsedInScript", "addCursorFlag", "flag", "", "v", "addOption", "option", "", "batchSize", "bufferedCount", "checkQueryNotExecuted", "", "clone", "close", "options", "Lorg/graalvm/polyglot/Value;", "collation", "comment", "count", "", "explain", "verbosity", "getOrCreateIterator", "hasNext", "hint", "isExhausted", "itcount", "limit", "max", "maxAwaitTimeMS", "value", "maxTimeMS", "min", "next", "project", "returnKey", "showRecordId", "size", "skip", "sort", "spec", "toArray", "toDocument", "Lorg/bson/Document;", "map", "tryNext", "withReadConcern", "withReadPreference", "JMongosh"})
public final class Cursor
implements ServiceProviderCursor {
    @NotNull
    private BaseMongoIterableHelper<?> helper;
    @NotNull
    private final MongoShellConverter converter;
    @NotNull
    private final ValueWrapper wrapper;
    @Nullable
    private MongoCursor<? extends Object> iterator;
    @HostAccess.Export
    @JvmField
    public boolean closed;
    @HostAccess.Export
    @JvmField
    public boolean resultsUsedInScript;

    public Cursor(@NotNull BaseMongoIterableHelper<?> helper, @NotNull MongoShellConverter converter, @NotNull ValueWrapper wrapper) {
        Intrinsics.checkNotNullParameter(helper, "helper");
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        this.helper = helper;
        this.converter = converter;
        this.wrapper = wrapper;
        this.resultsUsedInScript = true;
    }

    private final MongoCursor<? extends Object> getOrCreateIterator() {
        Iterator<Object> it = this.iterator;
        if (it == null) {
            this.iterator = it = this.helper.getIterable().iterator();
        }
        return it;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor addCursorFlag(@NotNull String flag, boolean v) {
        Intrinsics.checkNotNullParameter(flag, "flag");
        this.checkQueryNotExecuted();
        switch (flag) {
            case "noCursorTimeout": {
                this.helper.noCursorTimeout();
                break;
            }
            case "partial": {
                this.helper.allowPartialResults();
                break;
            }
            case "oplogReplay": {
                this.helper.oplogReplay();
                break;
            }
            case "tailable": {
                this.helper.tailable();
                break;
            }
            case "slaveOk": 
            case "awaitData": 
            case "exhaust": {
                throw new NotImplementedError("Cursor flag " + flag + " is not supported");
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown cursor flag ", flag));
            }
        }
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor addOption(int option) {
        throw new NotImplementedError("addOption is not supported");
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor batchSize(int v) {
        this.checkQueryNotExecuted();
        this.helper.batchSize(v);
        return this;
    }

    @Override
    public int bufferedCount() {
        throw new NotImplementedError("bufferedCount is not supported");
    }

    @Override
    @HostAccess.Export
    public void close() {
        this.closed = true;
        MongoCursor<? extends Object> mongoCursor = this.iterator;
        if (mongoCursor != null) {
            mongoCursor.close();
        }
    }

    @Override
    @HostAccess.Export
    public void close(@NotNull Value options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this.close();
    }

    @Override
    @NotNull
    public Cursor clone() {
        this.checkQueryNotExecuted();
        throw new NotImplementedError("clone is not supported");
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor collation(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        if (!v.hasMembers()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Expected one argument of type object. Got: ", v));
        }
        Document collation = this.toDocument(this.converter, v);
        this.helper.collation(collation);
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor comment(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        this.helper.comment(v);
        return this;
    }

    @Override
    @HostAccess.Export
    public long count() {
        this.checkQueryNotExecuted();
        return this.helper.count();
    }

    @Override
    @HostAccess.Export
    @Nullable
    public Object explain(@Nullable String verbosity) {
        this.checkQueryNotExecuted();
        return this.converter.toJs(this.helper.explain(verbosity));
    }

    @Override
    @HostAccess.Export
    public boolean hasNext() {
        return this.getOrCreateIterator().hasNext();
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor hint(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        if (!v.hasMembers() && !v.isString()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Expected one argument of type string or object. Got: ", v));
        }
        if (v.isString()) {
            String string = v.asString();
            Intrinsics.checkNotNullExpressionValue(string, "v.asString()");
            this.helper.hint(string);
        } else if (v.hasMembers()) {
            this.helper.hint(this.toDocument(this.converter, v));
        }
        return this;
    }

    @Override
    @HostAccess.Export
    public boolean isExhausted() {
        return this.closed && !this.hasNext();
    }

    @Override
    @HostAccess.Export
    public int itcount() {
        this.checkQueryNotExecuted();
        return this.helper.itcount();
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor limit(int v) {
        this.checkQueryNotExecuted();
        this.helper.limit(v);
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor max(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        if (!v.hasMembers()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Expected one argument of type object. Got: ", v));
        }
        this.helper.max(this.toDocument(this.converter, v));
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor maxTimeMS(long v) {
        this.checkQueryNotExecuted();
        this.helper.maxTimeMS(v);
        return this;
    }

    @Override
    @NotNull
    public ServiceProviderCursor maxAwaitTimeMS(int value) {
        throw new NotImplementedError("maxAwaitTimeMS is not supported");
    }

    @Override
    @HostAccess.Export
    @NotNull
    public ServiceProviderCursor min(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        if (!v.hasMembers()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Expected one argument of type object. Got: ", v));
        }
        this.helper.min(this.toDocument(this.converter, v));
        return this;
    }

    @Override
    @HostAccess.Export
    @Nullable
    public Object next() {
        Object value = this.getOrCreateIterator().next();
        return this.resultsUsedInScript ? this.converter.toJs(value) : value;
    }

    @Override
    @HostAccess.Export
    @Nullable
    public Object tryNext() {
        Object value = this.getOrCreateIterator().tryNext();
        return this.resultsUsedInScript ? this.converter.toJs(value) : value;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public ServiceProviderCursor project(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        this.helper.projection(this.toDocument(this.converter, v));
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor returnKey(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        this.helper.returnKey(v.isBoolean() ? v.asBoolean() : true);
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor withReadPreference(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        this.helper = this.helper.readPrev(v, null);
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor withReadConcern(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.checkQueryNotExecuted();
        this.helper = this.helper.readConcern(v);
        return this;
    }

    @Override
    @NotNull
    public ServiceProviderCursor showRecordId(boolean v) {
        throw new NotImplementedError("showRecordId is not supported");
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value size() {
        throw new NotImplementedError("size is not supported");
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor skip(int v) {
        this.checkQueryNotExecuted();
        this.helper.skip(v);
        return this;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor sort(@NotNull Value spec) {
        Intrinsics.checkNotNullParameter(spec, "spec");
        this.checkQueryNotExecuted();
        this.helper.sort(this.toDocument(this.converter, spec));
        return this;
    }

    @Override
    @HostAccess.Export
    @Nullable
    public Object toArray() {
        this.checkQueryNotExecuted();
        return this.converter.toJs(this.helper.toArray());
    }

    private final void checkQueryNotExecuted() {
        if (!(this.iterator == null)) {
            boolean bl = false;
            String string = "query already executed";
            throw new IllegalStateException(string.toString());
        }
    }

    private final Document toDocument(MongoShellConverter converter, Value map) {
        return map == null || map.isNull() ? new Document() : ((DocumentResult)MongoShellConverter.toJava$default(converter, map, null, 2, null)).getValue();
    }
}

