/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.CursorType;
import com.mongodb.ReadPreference;
import com.mongodb.TagSet;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CountOptions;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.result.DocumentResult;
import com.mongodb.mongosh.service.BaseMongoIterableHelper;
import com.mongodb.mongosh.service.BaseMongoIterableHelperKt;
import com.mongodb.mongosh.service.Either;
import com.mongodb.mongosh.service.FindCreateOptions;
import com.mongodb.mongosh.service.OptionConvertersKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.bson.Document;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u00020\u0001B1\u0012\u0010\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020*H\u0016J \u0010+\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000e2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0010\u00102\u001a\u00020\u00182\u0006\u00103\u001a\u00020\bH\u0016J\b\u00104\u001a\u00020\u0018H\u0016RB\u0010\f\u001a0\u0012\u0004\u0012\u00020\u000e\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00100\u000f0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\u0013\u001a*\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00065"}, d2={"Lcom/mongodb/mongosh/service/FindIterableHelper;", "Lcom/mongodb/mongosh/service/BaseMongoIterableHelper;", "Lcom/mongodb/client/FindIterable;", "", "iterable", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "options", "Lorg/bson/Document;", "createOptions", "Lcom/mongodb/mongosh/service/FindCreateOptions;", "(Lcom/mongodb/client/FindIterable;Lcom/mongodb/mongosh/MongoShellConverter;Lorg/bson/Document;Lcom/mongodb/mongosh/service/FindCreateOptions;)V", "converters", "", "", "Lkotlin/Function2;", "Lcom/mongodb/mongosh/service/Either;", "getConverters", "()Ljava/util/Map;", "defaultConverter", "Lkotlin/Function3;", "getDefaultConverter", "()Lkotlin/jvm/functions/Function3;", "allowPartialResults", "", "collation", "v", "comment", "count", "", "explain", "verbosity", "hint", "limit", "", "max", "maxTimeMS", "min", "noCursorTimeout", "oplogReplay", "projection", "readConcern", "Lorg/graalvm/polyglot/Value;", "readPrev", "tags", "", "Lcom/mongodb/TagSet;", "returnKey", "", "skip", "sort", "spec", "tailable", "JMongosh"})
public final class FindIterableHelper
extends BaseMongoIterableHelper<FindIterable<? extends Object>> {
    @Nullable
    private final FindCreateOptions createOptions;
    @NotNull
    private final Map<String, Function2<FindIterable<?>, Object, Either<FindIterable<?>>>> converters;
    @NotNull
    private final Function3<FindIterable<?>, String, Object, Either<FindIterable<?>>> defaultConverter;

    public FindIterableHelper(@NotNull FindIterable<? extends Object> iterable, @NotNull MongoShellConverter converter, @NotNull Document options, @Nullable FindCreateOptions createOptions) {
        Intrinsics.checkNotNullParameter(iterable, "iterable");
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(options, "options");
        super((MongoIterable)iterable, converter, options);
        this.createOptions = createOptions;
        this.converters = OptionConvertersKt.getFindConverters();
        this.defaultConverter = OptionConvertersKt.getFindDefaultConverter();
    }

    @Override
    @NotNull
    public Map<String, Function2<FindIterable<?>, Object, Either<FindIterable<?>>>> getConverters() {
        return this.converters;
    }

    @Override
    @NotNull
    public Function3<FindIterable<?>, String, Object, Either<FindIterable<?>>> getDefaultConverter() {
        return this.defaultConverter;
    }

    @NotNull
    public FindIterableHelper readPrev(@NotNull String v, @Nullable List<TagSet> tags) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-FindIterableHelper$readPrev$22 = false;
            String $i$a$-check-FindIterableHelper$readPrev$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-FindIterableHelper$readPrev$22.toString());
        }
        MongoDatabase newDb = tags == null ? this.createOptions.getDb().withReadPreference(ReadPreference.valueOf(v)) : this.createOptions.getDb().withReadPreference(ReadPreference.valueOf(v, tags));
        Intrinsics.checkNotNullExpressionValue(newDb, "newDb");
        FindCreateOptions newCreateOptions = FindCreateOptions.copy$default(this.createOptions, newDb, null, null, 6, null);
        FindIterable<Document> newIterable = BaseMongoIterableHelperKt.find(this.getOptions(), newCreateOptions);
        return new FindIterableHelper(newIterable, this.getConverter(), this.getOptions(), newCreateOptions);
    }

    @NotNull
    public FindIterableHelper readConcern(@NotNull Value v) {
        Intrinsics.checkNotNullParameter(v, "v");
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-FindIterableHelper$readConcern$22 = false;
            String $i$a$-check-FindIterableHelper$readConcern$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-FindIterableHelper$readConcern$22.toString());
        }
        if (!v.hasMembers()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("document was expected. Got ", v));
        }
        MongoDatabase newDb = OptionConvertersKt.getReadConcernConverter().invoke(this.createOptions.getDb(), ((DocumentResult)MongoShellConverter.toJava$default(this.getConverter(), v, null, 2, null)).getValue()).getOrThrow();
        FindCreateOptions newCreateOptions = FindCreateOptions.copy$default(this.createOptions, newDb, null, null, 6, null);
        FindIterable<Document> newIterable = BaseMongoIterableHelperKt.find(this.getOptions(), newCreateOptions);
        return new FindIterableHelper(newIterable, this.getConverter(), this.getOptions(), newCreateOptions);
    }

    @Override
    public void allowPartialResults() {
        this.set("allowPartialResults", true);
    }

    @Override
    public void oplogReplay() {
        this.set("oplogReplay", true);
    }

    @Override
    public void noCursorTimeout() {
        this.set("noCursorTimeout", true);
    }

    @Override
    public void maxTimeMS(long v) {
        this.set("maxTimeMS", v);
    }

    @Override
    public void projection(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("projection", v);
    }

    @Override
    public void limit(int v) {
        this.set("limit", v);
    }

    @Override
    public void max(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("max", v);
    }

    @Override
    public void min(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("min", v);
    }

    @Override
    public void skip(int v) {
        this.set("skip", v);
    }

    @Override
    public void comment(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("comment", v);
    }

    @Override
    public void hint(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("hint", v);
    }

    @Override
    public void hint(@NotNull String v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("hint", v);
    }

    @Override
    public void collation(@NotNull Document v) {
        Intrinsics.checkNotNullParameter(v, "v");
        this.set("collation", v);
    }

    @Override
    public void returnKey(boolean v) {
        this.set("returnKey", v);
    }

    @Override
    public void sort(@NotNull Document spec) {
        Intrinsics.checkNotNullParameter(spec, "spec");
        this.set("sort", spec);
    }

    @Override
    public void tailable() {
        this.set("tailable", CursorType.Tailable.toString());
    }

    @Override
    public long count() {
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-FindIterableHelper$count$22 = false;
            String $i$a$-check-FindIterableHelper$count$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-FindIterableHelper$count$22.toString());
        }
        Map $this$filterKeys$iv = this.getOptions();
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!OptionConvertersKt.getCountOptionsConverters().containsKey(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map countOptionsMap = result$iv;
        CountOptions countOptions = OptionConvertersKt.convert(new CountOptions(), OptionConvertersKt.getCountOptionsConverters(), OptionConvertersKt.getCountOptionsDefaultConverter(), countOptionsMap).getOrThrow();
        return this.createOptions.getDb().getCollection(this.createOptions.getCollection()).countDocuments(this.createOptions.getFind(), countOptions);
    }

    @Override
    @Nullable
    public Object explain(@Nullable String verbosity) {
        if (!(this.createOptions != null)) {
            boolean $i$a$-check-FindIterableHelper$explain$22 = false;
            String $i$a$-check-FindIterableHelper$explain$22 = "createOptions were not saved";
            throw new IllegalStateException($i$a$-check-FindIterableHelper$explain$22.toString());
        }
        Document findCommand = new Document();
        Map $i$a$-check-FindIterableHelper$explain$22 = findCommand;
        Object object = "find";
        Object object2 = this.createOptions.getCollection();
        $i$a$-check-FindIterableHelper$explain$22.put(object, object2);
        $i$a$-check-FindIterableHelper$explain$22 = findCommand;
        object = "filter";
        object2 = this.createOptions.getFind();
        $i$a$-check-FindIterableHelper$explain$22.put(object, object2);
        findCommand.putAll(this.getOptions());
        Document explain = new Document();
        object = explain;
        object2 = "explain";
        object.put(object2, findCommand);
        object = explain;
        object2 = "verbosity";
        String string = verbosity;
        if (string == null) {
            string = "queryPlanner";
        }
        String string2 = string;
        object.put(object2, string2);
        return this.createOptions.getDb().runCommand(explain);
    }
}

