/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.mongosh.service;

import com.mongodb.MongoNamespace;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.mongosh.MongoShellConverter;
import com.mongodb.mongosh.ValueWrapper;
import com.mongodb.mongosh.result.ArrayResult;
import com.mongodb.mongosh.result.DocumentResult;
import com.mongodb.mongosh.service.AdminServiceProvider;
import com.mongodb.mongosh.service.AggregateCreateOptions;
import com.mongodb.mongosh.service.AggregateIterableHelper;
import com.mongodb.mongosh.service.BaseMongoIterableHelperKt;
import com.mongodb.mongosh.service.Cursor;
import com.mongodb.mongosh.service.Either;
import com.mongodb.mongosh.service.FindCreateOptions;
import com.mongodb.mongosh.service.FindIterableHelper;
import com.mongodb.mongosh.service.JavaServiceProvider;
import com.mongodb.mongosh.service.Left;
import com.mongodb.mongosh.service.OptionConvertersKt;
import com.mongodb.mongosh.service.ReadableServiceProvider;
import com.mongodb.mongosh.service.Right;
import com.mongodb.mongosh.service.WritableServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0017J.\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0017J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0017J*\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\"\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J*\u0010!\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J*\u0010\"\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J4\u0010#\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010$\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\"\u0010%\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\u001a\u0010&\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\"\u0010'\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010(\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J*\u0010)\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J2\u0010*\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J2\u0010,\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\b\u0010.\u001a\u00020\u0012H\u0017J.\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010\u000f\u001a\u00020\f2\u0016\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u000103\u0018\u000102H\u0003J\"\u00104\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\u001a\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\b\u00107\u001a\u00020\u0012H\u0017J\b\u00108\u001a\u00020\u0012H\u0017J\b\u00109\u001a\u00020\u0012H\u0017J\b\u0010:\u001a\u00020\u0012H\u0017J\u001c\u0010;\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0<002\u0006\u0010>\u001a\u00020=H\u0002J4\u0010?\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010B\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010C\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J,\u0010D\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010E\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\u0012\u0010F\u001a\u00020A2\b\u0010G\u001a\u0004\u0018\u000103H\u0002J$\u0010H\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\u001a\u0010I\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\"\u0010J\u001a\u00020\u0012\"\u0004\b\u0000\u0010K2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK000MH\u0002J\u0012\u0010N\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J*\u0010O\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010P\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J2\u0010R\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J\b\u0010S\u001a\u00020\u0012H\u0017J\u0018\u0010T\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010U\u001a\u00020\u0012H\u0017J\"\u0010V\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010U\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J4\u0010W\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010E\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0017J\u000e\u0010X\u001a\u00020Y2\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010Z\u001a\u0004\u0018\u00010=2\b\u0010[\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\fH\u0002J$\u0010\\\u001a\f\u0012\u0006\u0012\u0004\u0018\u000103\u0018\u00010]2\b\u0010[\u001a\u0004\u0018\u00010\u00122\u0006\u0010$\u001a\u00020\fH\u0002J.\u0010^\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK0]00\"\u0004\b\u0000\u0010K2\u0012\u0010_\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HK000]H\u0002J2\u0010`\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017J2\u0010a\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/mongodb/mongosh/service/JavaServiceProvider;", "Lcom/mongodb/mongosh/service/ReadableServiceProvider;", "Lcom/mongodb/mongosh/service/WritableServiceProvider;", "Lcom/mongodb/mongosh/service/AdminServiceProvider;", "client", "Lcom/mongodb/client/MongoClient;", "converter", "Lcom/mongodb/mongosh/MongoShellConverter;", "wrapper", "Lcom/mongodb/mongosh/ValueWrapper;", "(Lcom/mongodb/client/MongoClient;Lcom/mongodb/mongosh/MongoShellConverter;Lcom/mongodb/mongosh/ValueWrapper;)V", "platform", "", "aggregate", "Lcom/mongodb/mongosh/service/Cursor;", "database", "collection", "pipeline", "Lorg/graalvm/polyglot/Value;", "options", "dbOptions", "aggregateDb", "authenticate", "authDoc", "bulkWrite", "requests", "count", "query", "countDocuments", "filter", "createCollection", "createIndexes", "indexSpecs", "deleteMany", "deleteOne", "distinct", "fieldName", "dropCollection", "dropDatabase", "estimatedDocumentCount", "find", "findOneAndDelete", "findOneAndReplace", "replacement", "findOneAndUpdate", "update", "getConnectionInfo", "getDatabase", "Lcom/mongodb/mongosh/service/Either;", "Lcom/mongodb/client/MongoDatabase;", "", "", "getIndexes", "getNewConnection", "uri", "getReadConcern", "getReadPreference", "getTopology", "getWriteConcern", "getWriteModel", "Lcom/mongodb/client/model/WriteModel;", "Lorg/bson/Document;", "model", "initializeBulkOp", "ordered", "", "insertMany", "docs", "insertOne", "document", "interpretAsBoolean", "v", "listCollections", "listDatabases", "promise", "T", "block", "Lkotlin/Function0;", "readPreferenceFromOptions", "renameCollection", "oldName", "newName", "replaceOne", "resetConnectionOptions", "runCommand", "spec", "runCommandWithCheck", "save", "setClient", "", "toDocument", "value", "toList", "", "unwrap", "l", "updateMany", "updateOne", "JMongosh"})
public final class JavaServiceProvider
implements ReadableServiceProvider,
WritableServiceProvider,
AdminServiceProvider {
    @Nullable
    private MongoClient client;
    @NotNull
    private final MongoShellConverter converter;
    @NotNull
    private final ValueWrapper wrapper;
    @HostAccess.Export
    @JvmField
    @NotNull
    public final String platform;

    public JavaServiceProvider(@Nullable MongoClient client, @NotNull MongoShellConverter converter, @NotNull ValueWrapper wrapper) {
        Intrinsics.checkNotNullParameter(converter, "converter");
        Intrinsics.checkNotNullParameter(wrapper, "wrapper");
        this.client = client;
        this.converter = converter;
        this.wrapper = wrapper;
        this.platform = "JavaShell";
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value runCommand(@NotNull String database, @NotNull Value spec) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(spec, "spec");
        return this.promise((Function0)new Function0<Either<? extends Document>>(this, database, spec){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ String $database;
            final /* synthetic */ Value $spec;
            {
                this.this$0 = $receiver;
                this.$database = $database;
                this.$spec = $spec;
                super(0);
            }

            @NotNull
            public final Either<Document> invoke() {
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).map((Function1)new Function1<MongoDatabase, Document>(this.$spec, this.this$0){
                    final /* synthetic */ Value $spec;
                    final /* synthetic */ JavaServiceProvider this$0;
                    {
                        this.$spec = $spec;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Document invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return this.$spec.isString() ? db.runCommand(new Document(this.$spec.asString(), 1)) : db.runCommand(JavaServiceProvider.access$toDocument(this.this$0, this.$spec, "spec"));
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value runCommandWithCheck(@NotNull String database, @NotNull Value spec, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(spec, "spec");
        return this.promise((Function0)new Function0<Either<? extends Document>>(this, database, spec){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ String $database;
            final /* synthetic */ Value $spec;
            {
                this.this$0 = $receiver;
                this.$database = $database;
                this.$spec = $spec;
                super(0);
            }

            @NotNull
            public final Either<Document> invoke() {
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).map((Function1)new Function1<MongoDatabase, Document>(this.$spec, this.this$0){
                    final /* synthetic */ Value $spec;
                    final /* synthetic */ JavaServiceProvider this$0;
                    {
                        this.$spec = $spec;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Document invoke(@NotNull MongoDatabase db) {
                        Document res;
                        Intrinsics.checkNotNullParameter(db, "db");
                        Document document = res = this.$spec.isString() ? db.runCommand(new Document(this.$spec.asString(), 1)) : db.runCommand(JavaServiceProvider.access$toDocument(this.this$0, this.$spec, "spec"));
                        if (!JavaServiceProvider.access$interpretAsBoolean(this.this$0, res.get("ok"))) {
                            String string;
                            StringBuilder stringBuilder = new StringBuilder().append("Command failed. Spec: ");
                            if (this.$spec.isString()) {
                                string = this.$spec.asString();
                            } else {
                                Document document2 = JavaServiceProvider.access$toDocument(this.this$0, this.$spec, "spec");
                                string = document2 == null ? null : document2.toJson();
                            }
                            throw new Exception(stringBuilder.append((Object)string).append(". Result: ").append((Object)res.toJson()).toString());
                        }
                        return res;
                    }
                });
            }
        });
    }

    private final boolean interpretAsBoolean(Object v) {
        boolean bl;
        Boolean bl2;
        Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
        if (number == null) {
            bl2 = null;
        } else {
            Integer n = number.intValue();
            bl2 = ((Object)n).equals(1);
        }
        if (bl2 == null) {
            Boolean bl3;
            Boolean bl4 = bl3 = v instanceof Boolean ? (Boolean)v : null;
            bl = bl3 == null ? false : bl3;
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value insertOne(@NotNull String database, @NotNull String collection, @Nullable Value document, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Map<String, ? extends Object>>>(this, document, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $document;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Map<String, Object>> invoke() {
                Map map;
                Document options;
                Document document = JavaServiceProvider.access$toDocument(this.this$0, this.$document, "document");
                Document document2 = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).map((Function1)new Function1<MongoDatabase, Map<String, ? extends Object>>(this.$collection, document){
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $document;
                    {
                        this.$collection = $collection;
                        this.$document = $document;
                        super(1);
                    }

                    @NotNull
                    public final Map<String, Object> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        InsertOneResult result2 = db.getCollection(this.$collection).insertOne(this.$document);
                        Pair[] pairArray = new Pair[]{TuplesKt.to("acknowledged", result2.wasAcknowledged()), TuplesKt.to("insertedId", result2.getInsertedId())};
                        return MapsKt.mapOf(pairArray);
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value replaceOne(@NotNull String database, @NotNull String collection, @NotNull Value filter, @NotNull Value replacement, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        return this.promise((Function0)new Function0<Either<? extends Map<String, ? extends Object>>>(this, filter, replacement, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $replacement;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$replacement = $replacement;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Map<String, Object>> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document replacement = JavaServiceProvider.access$toDocument(this.this$0, this.$replacement, "replacement");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$collection, filter, replacement){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    final /* synthetic */ Document $replacement;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        this.$replacement = $replacement;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new ReplaceOptions(), OptionConvertersKt.getReplaceOptionsConverters(), OptionConvertersKt.getReplaceOptionsDefaultConverter(), this.$opt).map((Function1)new Function1<ReplaceOptions, Map<String, ? extends Object>>(db, this.$collection, this.$filter, this.$replacement){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            final /* synthetic */ Document $replacement;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                this.$replacement = $replacement;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Object> invoke(@NotNull ReplaceOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                UpdateResult res = this.$db.getCollection(this.$collection).replaceOne(this.$filter, this.$replacement, opt);
                                Pair[] pairArray = new Pair[]{TuplesKt.to("acknowledged", res.wasAcknowledged()), TuplesKt.to("matchedCount", res.getMatchedCount()), TuplesKt.to("modifiedCount", res.getModifiedCount()), TuplesKt.to("upsertedCount", res.getUpsertedId() == null ? 0 : 1), TuplesKt.to("upsertedId", res.getUpsertedId())};
                                return MapsKt.mapOf(pairArray);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value updateMany(@NotNull String database, @NotNull String collection, @NotNull Value filter, @NotNull Value update, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        Intrinsics.checkNotNullParameter(update, "update");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, options, database, update, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ Value $update;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$update = $update;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$update, this.this$0, this.$collection, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ Value $update;
                    final /* synthetic */ JavaServiceProvider this$0;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$update = $update;
                        this.this$0 = $receiver;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new UpdateOptions(), OptionConvertersKt.getUpdateConverters(), OptionConvertersKt.getUpdateDefaultConverter(), this.$opt).flatMap((Function1)new Function1<UpdateOptions, Either<? extends Map<String, ? extends Object>>>(this.$update, this.this$0, db, this.$collection, this.$filter){
                            final /* synthetic */ Value $update;
                            final /* synthetic */ JavaServiceProvider this$0;
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            {
                                this.$update = $update;
                                this.this$0 = $receiver;
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled aggressive block sorting
                             */
                            @NotNull
                            public final Either<Map<String, Object>> invoke(@NotNull UpdateOptions updateOptions) {
                                void $this$filterIsInstanceTo$iv$iv;
                                void $this$filterIsInstance$iv;
                                Either either;
                                Iterator<T> iterator2;
                                Iterable $this$any$iv;
                                List updatePipeline;
                                block12: {
                                    block9: {
                                        boolean bl;
                                        block7: {
                                            block11: {
                                                block8: {
                                                    block10: {
                                                        Intrinsics.checkNotNullParameter(updateOptions, "updateOptions");
                                                        if (!this.$update.hasArrayElements()) break block8;
                                                        updatePipeline = JavaServiceProvider.access$toList(this.this$0, this.$update, "update");
                                                        if (updatePipeline == null) break block9;
                                                        $this$any$iv = updatePipeline;
                                                        boolean $i$f$any = false;
                                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block10;
                                                        bl = false;
                                                        break block7;
                                                    }
                                                    iterator2 = $this$any$iv.iterator();
                                                    break block11;
                                                }
                                                if (this.$update.hasMembers()) {
                                                    either = new Right<UpdateResult>(this.$db.getCollection(this.$collection).updateMany((Bson)this.$filter, (Bson)JavaServiceProvider.access$toDocument(this.this$0, this.$update, "update"), updateOptions));
                                                    return either.map(updateMany.2.INSTANCE);
                                                }
                                                either = new Left<T>(new IllegalArgumentException("updatePipeline must be a list or object"));
                                                return either.map(updateMany.2.INSTANCE);
                                            }
                                            while (iterator2.hasNext()) {
                                                T element$iv;
                                                T it = element$iv = iterator2.next();
                                                boolean bl2 = false;
                                                if (!(!(it instanceof Document))) continue;
                                                bl = true;
                                                break block7;
                                            }
                                            bl = false;
                                        }
                                        if (!bl) break block12;
                                    }
                                    either = new Left<T>(new IllegalArgumentException("updatePipeline must be a list of objects"));
                                    return either.map(updateMany.2.INSTANCE);
                                }
                                $this$any$iv = updatePipeline;
                                Bson bson = this.$filter;
                                MongoCollection<Document> mongoCollection = this.$db.getCollection(this.$collection);
                                boolean $i$f$filterIsInstance = false;
                                iterator2 = $this$filterIsInstance$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterIsInstanceTo = false;
                                Iterator<T> iterator3 = $this$filterIsInstanceTo$iv$iv.iterator();
                                while (true) {
                                    if (!iterator3.hasNext()) {
                                        List list = (List)destination$iv$iv;
                                        UpdateResult updateResult = mongoCollection.updateMany(bson, list, updateOptions);
                                        either = new Right<UpdateResult>(updateResult);
                                        return either.map(updateMany.2.INSTANCE);
                                    }
                                    T element$iv$iv = iterator3.next();
                                    if (!(element$iv$iv instanceof Document)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value updateOne(@NotNull String database, @NotNull String collection, @NotNull Value filter, @NotNull Value update, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        Intrinsics.checkNotNullParameter(update, "update");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, options, database, collection, update){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            final /* synthetic */ Value $update;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                this.$update = $update;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$collection, this.$update, this.this$0, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Value $update;
                    final /* synthetic */ JavaServiceProvider this$0;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$update = $update;
                        this.this$0 = $receiver;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new UpdateOptions(), OptionConvertersKt.getUpdateConverters(), OptionConvertersKt.getUpdateDefaultConverter(), this.$opt).map((Function1)new Function1<UpdateOptions, Map<String, ? extends Object>>(db, this.$collection, this.$update, this.this$0, this.$filter){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Value $update;
                            final /* synthetic */ JavaServiceProvider this$0;
                            final /* synthetic */ Document $filter;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$update = $update;
                                this.this$0 = $receiver;
                                this.$filter = $filter;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Map<String, Object> invoke(@NotNull UpdateOptions updateOptions) {
                                UpdateResult updateResult;
                                Intrinsics.checkNotNullParameter(updateOptions, "updateOptions");
                                MongoCollection<Document> coll = this.$db.getCollection(this.$collection);
                                if (this.$update.hasArrayElements()) {
                                    List list;
                                    List list2 = JavaServiceProvider.access$toList(this.this$0, this.$update, "update");
                                    if (list2 == null) {
                                        list = null;
                                    } else {
                                        void $this$mapTo$iv$iv;
                                        Iterable $this$map$iv = list2;
                                        boolean $i$f$map = false;
                                        Iterable iterable = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                        boolean $i$f$mapTo = false;
                                        Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                                        while (iterator2.hasNext()) {
                                            void it;
                                            T item$iv$iv;
                                            T t = item$iv$iv = iterator2.next();
                                            Collection collection = destination$iv$iv;
                                            boolean bl = false;
                                            void v2 = it;
                                            if (v2 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type org.bson.Document");
                                            }
                                            collection.add((Document)v2);
                                        }
                                        list = (List)destination$iv$iv;
                                    }
                                    List pipeline = list;
                                    updateResult = coll.updateOne((Bson)this.$filter, pipeline, updateOptions);
                                } else {
                                    updateResult = coll.updateOne((Bson)this.$filter, (Bson)JavaServiceProvider.access$toDocument(this.this$0, this.$update, "update"), updateOptions);
                                }
                                UpdateResult res = updateResult;
                                Pair[] pairArray = new Pair[]{TuplesKt.to("acknowledged", res.wasAcknowledged()), TuplesKt.to("matchedCount", res.getMatchedCount()), TuplesKt.to("modifiedCount", res.getModifiedCount()), TuplesKt.to("upsertedCount", res.getUpsertedId() == null ? 0 : 1), TuplesKt.to("upsertedId", res.getUpsertedId())};
                                return MapsKt.mapOf(pairArray);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value save(@NotNull String database, @NotNull String collection, @NotNull Value document, @Nullable Value options, @Nullable Value dbOptions) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(document, "document");
        return this.promise(save.1.INSTANCE);
    }

    @HostAccess.Export
    private final Either<MongoDatabase> getDatabase(String database, Map<String, ? extends Object> dbOptions) {
        Either<MongoDatabase> either;
        MongoClient mongoClient = this.client;
        Intrinsics.checkNotNull(mongoClient);
        MongoDatabase db = mongoClient.getDatabase(database);
        if (dbOptions == null) {
            either = (Either<MongoDatabase>)new Right<MongoDatabase>(db);
        } else {
            Intrinsics.checkNotNullExpressionValue(db, "db");
            either = OptionConvertersKt.convert(db, OptionConvertersKt.getDbConverters(), OptionConvertersKt.getDbDefaultConverter(), dbOptions);
        }
        return either;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value dropDatabase(@NotNull String database, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, database){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ String $database;
            {
                this.this$0 = $receiver;
                this.$database = $database;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).map((Function1)new Function1<MongoDatabase, Map<String, ? extends Object>>(this.$database){
                    final /* synthetic */ String $database;
                    {
                        this.$database = $database;
                        super(1);
                    }

                    @NotNull
                    public final Map<String, Object> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        db.drop();
                        Pair[] pairArray = new Pair[]{TuplesKt.to("ok", 1), TuplesKt.to("dropped", this.$database)};
                        return MapsKt.mapOf(pairArray);
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value bulkWrite(@NotNull String database, @NotNull String collection, @NotNull Value requests, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(requests, "requests");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, requests, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $requests;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$requests = $requests;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                List requests;
                block15: {
                    block14: {
                        boolean bl;
                        block13: {
                            requests = JavaServiceProvider.access$toList(this.this$0, this.$requests, "requests");
                            if (requests == null) break block14;
                            Iterable $this$any$iv = requests;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                Iterator<T> iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    T element$iv;
                                    T it = element$iv = iterator2.next();
                                    boolean bl2 = false;
                                    if (!(!(it instanceof Document))) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block15;
                    }
                    return new Left<T>(new IllegalArgumentException("requests must be a list of objects"));
                }
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, (List<? extends Object>)requests, this.this$0, this.$collection){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ List<Object> $requests;
                    final /* synthetic */ JavaServiceProvider this$0;
                    final /* synthetic */ String $collection;
                    {
                        this.$opt = $opt;
                        this.$requests = $requests;
                        this.this$0 = $receiver;
                        this.$collection = $collection;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new BulkWriteOptions(), OptionConvertersKt.getBulkWriteOptionsConverters(), OptionConvertersKt.getBulkWriteOptionsDefaultConverter(), this.$opt).flatMap((Function1)new Function1<BulkWriteOptions, Either<? extends Map<String, ? extends Object>>>(this.$requests, this.this$0, db, this.$collection){
                            final /* synthetic */ List<Object> $requests;
                            final /* synthetic */ JavaServiceProvider this$0;
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            {
                                this.$requests = $requests;
                                this.this$0 = $receiver;
                                this.$db = $db;
                                this.$collection = $collection;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Either<Map<String, Object>> invoke(@NotNull BulkWriteOptions options) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Intrinsics.checkNotNullParameter(options, "options");
                                Iterable iterable = this.$requests;
                                JavaServiceProvider javaServiceProvider = this.this$0;
                                boolean $i$f$map = false;
                                void var6_5 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                                while (iterator2.hasNext()) {
                                    void it;
                                    T item$iv$iv;
                                    T t = item$iv$iv = iterator2.next();
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    void v0 = it;
                                    if (v0 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type org.bson.Document");
                                    }
                                    collection.add(JavaServiceProvider.access$getWriteModel(javaServiceProvider, (Document)v0));
                                }
                                List writeModels = (List)destination$iv$iv;
                                return JavaServiceProvider.access$unwrap(this.this$0, writeModels).map((Function1)new Function1<List<? extends WriteModel<Document>>, Map<String, ? extends Object>>(this.$db, this.$collection, options){
                                    final /* synthetic */ MongoDatabase $db;
                                    final /* synthetic */ String $collection;
                                    final /* synthetic */ BulkWriteOptions $options;
                                    {
                                        this.$db = $db;
                                        this.$collection = $collection;
                                        this.$options = $options;
                                        super(1);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    @NotNull
                                    public final Map<String, Object> invoke(@NotNull List<? extends WriteModel<Document>> requests) {
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        void $this$associateTo$iv$iv;
                                        Iterable<BulkWriteUpsert> $this$associate$iv;
                                        Intrinsics.checkNotNullParameter(requests, "requests");
                                        BulkWriteResult result2 = this.$db.getCollection(this.$collection).bulkWrite(requests, this.$options);
                                        Pair[] pairArray = new Pair[8];
                                        pairArray[0] = TuplesKt.to("ok", result2.wasAcknowledged());
                                        pairArray[1] = TuplesKt.to("insertedCount", result2.getInsertedCount());
                                        Iterable<BulkWriteInsert> iterable = result2.getInserts();
                                        Intrinsics.checkNotNullExpressionValue(iterable, "result.inserts");
                                        iterable = iterable;
                                        String string = "insertedIds";
                                        int n = 2;
                                        Pair[] pairArray2 = pairArray;
                                        boolean $i$f$associate = false;
                                        int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                                        void var7_11 = $this$associate$iv;
                                        Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv22);
                                        boolean $i$f$associateTo = false;
                                        for (Object element$iv$iv : $this$associateTo$iv$iv) {
                                            Map map = destination$iv$iv;
                                            BulkWriteInsert it = (BulkWriteInsert)element$iv$iv;
                                            boolean bl = false;
                                            Pair<String, BsonValue> pair = new Pair<String, BsonValue>(String.valueOf(it.getIndex()), it.getId());
                                            map.put(pair.getFirst(), pair.getSecond());
                                        }
                                        Object object = destination$iv$iv;
                                        pairArray2[n] = TuplesKt.to(string, object);
                                        pairArray[3] = TuplesKt.to("matchedCount", result2.getMatchedCount());
                                        pairArray[4] = TuplesKt.to("modifiedCount", result2.getModifiedCount());
                                        pairArray[5] = TuplesKt.to("deletedCount", result2.getDeletedCount());
                                        pairArray[6] = TuplesKt.to("upsertedCount", result2.getUpserts().size());
                                        $this$associate$iv = result2.getUpserts();
                                        Intrinsics.checkNotNullExpressionValue($this$associate$iv, "result.upserts");
                                        $this$associate$iv = $this$associate$iv;
                                        string = "upsertedIds";
                                        n = 7;
                                        pairArray2 = pairArray;
                                        boolean $i$f$map = false;
                                        void capacity$iv22 = $this$map$iv;
                                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            Object element$iv$iv;
                                            element$iv$iv = (BulkWriteUpsert)item$iv$iv;
                                            object = destination$iv$iv2;
                                            boolean bl = false;
                                            object.add(it.getId());
                                        }
                                        object = (List)destination$iv$iv2;
                                        pairArray2[n] = TuplesKt.to(string, object);
                                        return MapsKt.mapOf(pairArray);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Either<List<T>> unwrap(List<? extends Either<? extends T>> l) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = l;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Either either = (Either)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_11 = it;
            if (var11_11 instanceof Left) {
                return new Left(((Left)it).getValue());
            }
            if (!(var11_11 instanceof Right)) {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(((Right)it).getValue());
        }
        List list = (List)destination$iv$iv;
        return new Right<List>(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Either<WriteModel<Document>> getWriteModel(Document model) {
        Either either;
        Object object;
        if (model.keySet().size() != 1) {
            return new Left(new IllegalArgumentException());
        }
        Set<String> set = model.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "model.keys");
        String key = (String)CollectionsKt.first((Iterable)set);
        Object object2 = model.get(key);
        Object object3 = object = object2 instanceof Document ? (Document)object2 : null;
        if (object == null) {
            return new Left(new IllegalArgumentException(Intrinsics.stringPlus("Inner object must be an instance of object. ", model)));
        }
        Document innerDoc = object;
        object = key;
        if (object != null) {
            int n = -1;
            switch (((String)object).hashCode()) {
                case 1764373162: {
                    if (!((String)object).equals("deleteMany")) break;
                    n = 1;
                    break;
                }
                case -296147256: {
                    if (!((String)object).equals("updateMany")) break;
                    n = 2;
                    break;
                }
                case -1233053934: {
                    if (!((String)object).equals("replaceOne")) break;
                    n = 3;
                    break;
                }
                case -358724421: {
                    if (!((String)object).equals("deleteOne")) break;
                    n = 1;
                    break;
                }
                case -384480019: {
                    if (!((String)object).equals("insertOne")) break;
                    n = 4;
                    break;
                }
                case -1949213475: {
                    if (!((String)object).equals("updateOne")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    Document document;
                    Object object4 = innerDoc.get("document");
                    Document document2 = document = object4 instanceof Document ? (Document)object4 : null;
                    if (document == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'document' ", innerDoc)));
                    }
                    Document doc = document;
                    either = new Right<InsertOneModel<Document>>(new InsertOneModel<Document>(doc));
                    return either;
                }
                case 1: {
                    Document document;
                    Object object5 = innerDoc.get("filter");
                    Document document3 = document = object5 instanceof Document ? (Document)object5 : null;
                    if (document == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'filter' ", innerDoc)));
                    }
                    Document filter = document;
                    Object object6 = innerDoc.get("collation");
                    Document document4 = object6 instanceof Document ? (Document)object6 : null;
                    if (document4 == null) {
                        document4 = new Document();
                    }
                    Document collationDoc = document4;
                    object5 = Collation.builder();
                    Intrinsics.checkNotNullExpressionValue(object5, "builder()");
                    either = OptionConvertersKt.convert(object5, OptionConvertersKt.getCollationConverters(), OptionConvertersKt.getCollationDefaultConverter(), collationDoc).map((Function1)new Function1<Collation.Builder, WriteModel<Document>>(key, filter){
                        final /* synthetic */ String $key;
                        final /* synthetic */ Document $filter;
                        {
                            this.$key = $key;
                            this.$filter = $filter;
                            super(1);
                        }

                        @NotNull
                        public final WriteModel<Document> invoke(@NotNull Collation.Builder collation) {
                            Intrinsics.checkNotNullParameter(collation, "collation");
                            DeleteOptions opt = new DeleteOptions().collation(collation.build());
                            return Intrinsics.areEqual(this.$key, "deleteOne") ? (WriteModel)new DeleteOneModel<T>(this.$filter, opt) : (WriteModel)new DeleteManyModel<T>(this.$filter, opt);
                        }
                    });
                    return either;
                }
                case 2: {
                    Document collationDoc;
                    Object object7 = innerDoc.get("filter");
                    Document document = collationDoc = object7 instanceof Document ? (Document)object7 : null;
                    if (collationDoc == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'filter' ", innerDoc)));
                    }
                    Document filter = collationDoc;
                    Object object8 = innerDoc.get("update");
                    if (object8 == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'update' ", innerDoc)));
                    }
                    Object update = object8;
                    either = OptionConvertersKt.convert(new UpdateOptions(), OptionConvertersKt.getUpdateOptionsConverters(), OptionConvertersKt.getUpdateOptionsDefaultConverter(), innerDoc).flatMap((Function1)new Function1<UpdateOptions, Either<? extends WriteModel<Document>>>(update, key, filter, innerDoc){
                        final /* synthetic */ Object $update;
                        final /* synthetic */ String $key;
                        final /* synthetic */ Document $filter;
                        final /* synthetic */ Document $innerDoc;
                        {
                            this.$update = $update;
                            this.$key = $key;
                            this.$filter = $filter;
                            this.$innerDoc = $innerDoc;
                            super(1);
                        }

                        @NotNull
                        public final Either<WriteModel<Document>> invoke(@NotNull UpdateOptions opt) {
                            Either either;
                            WriteModel model;
                            Intrinsics.checkNotNullParameter(opt, "opt");
                            Object object = this.$update;
                            if (object instanceof Document) {
                                model = Intrinsics.areEqual(this.$key, "updateOne") ? (WriteModel)new UpdateOneModel<T>((Bson)this.$filter, (Bson)this.$update, opt) : (WriteModel)new UpdateManyModel<T>((Bson)this.$filter, (Bson)this.$update, opt);
                                either = new Right<WriteModel>(model);
                            } else if (object instanceof List) {
                                WriteModel writeModel;
                                Iterable $this$filterIsInstanceTo$iv$iv;
                                boolean $i$f$filterIsInstanceTo;
                                Collection destination$iv$iv;
                                Iterable $this$filterIsInstance$iv;
                                boolean $i$f$filterIsInstance;
                                Bson bson;
                                if (Intrinsics.areEqual(this.$key, "updateOne")) {
                                    Iterable iterable = (Iterable)this.$update;
                                    bson = this.$filter;
                                    $i$f$filterIsInstance = false;
                                    Iterable iterable2 = $this$filterIsInstance$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterIsInstanceTo = false;
                                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof Document)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    UpdateOptions updateOptions = opt;
                                    List list = (List)destination$iv$iv;
                                    Bson bson2 = bson;
                                    writeModel = new UpdateOneModel<T>(bson2, list, updateOptions);
                                } else {
                                    $this$filterIsInstance$iv = (Iterable)this.$update;
                                    bson = this.$filter;
                                    $i$f$filterIsInstance = false;
                                    $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                                    destination$iv$iv = new ArrayList<E>();
                                    $i$f$filterIsInstanceTo = false;
                                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                        if (!(element$iv$iv instanceof Document)) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    UpdateOptions updateOptions = opt;
                                    List list = (List)destination$iv$iv;
                                    Bson bson3 = bson;
                                    writeModel = new UpdateManyModel<T>(bson3, list, updateOptions);
                                }
                                model = writeModel;
                                either = new Right<WriteModel>(model);
                            } else {
                                either = new Left<T>(new IllegalArgumentException(Intrinsics.stringPlus("Property 'update' has to be a document of a list ", this.$innerDoc)));
                            }
                            Either res = either;
                            return res;
                        }
                    });
                    return either;
                }
                case 3: {
                    Document update;
                    Object object9 = innerDoc.get("filter");
                    Document document = update = object9 instanceof Document ? (Document)object9 : null;
                    if (update == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'filter' ", innerDoc)));
                    }
                    Document filter = update;
                    Object object10 = innerDoc.get("replacement");
                    Object object11 = object9 = object10 instanceof Document ? (Document)object10 : null;
                    if (object9 == null) {
                        return new Left(new IllegalArgumentException(Intrinsics.stringPlus("No property 'replacement' ", innerDoc)));
                    }
                    Object replacement = object9;
                    either = OptionConvertersKt.convert(new ReplaceOptions(), OptionConvertersKt.getReplaceOptionsConverters(), OptionConvertersKt.getReplaceOptionsDefaultConverter(), innerDoc).map((Function1)new Function1<ReplaceOptions, ReplaceOneModel<Document>>(filter, (Document)replacement){
                        final /* synthetic */ Document $filter;
                        final /* synthetic */ Document $replacement;
                        {
                            this.$filter = $filter;
                            this.$replacement = $replacement;
                            super(1);
                        }

                        @NotNull
                        public final ReplaceOneModel<Document> invoke(@NotNull ReplaceOptions opt) {
                            Intrinsics.checkNotNullParameter(opt, "opt");
                            return new ReplaceOneModel<Document>(this.$filter, this.$replacement, opt);
                        }
                    });
                    return either;
                }
            }
        }
        either = new Left(new IllegalArgumentException(Intrinsics.stringPlus("Unknown bulk write operation ", model)));
        return either;
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value deleteMany(@NotNull String database, @NotNull String collection, @NotNull Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        return this.promise((Function0)new Function0<Either<? extends Map<String, ? extends Object>>>(this, filter, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Map<String, Object>> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$collection, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new DeleteOptions(), OptionConvertersKt.getDeleteConverters(), OptionConvertersKt.getDeleteDefaultConverter(), this.$opt).map((Function1)new Function1<DeleteOptions, Map<String, ? extends Object>>(db, this.$collection, this.$filter){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Object> invoke(@NotNull DeleteOptions deleteOptions) {
                                Intrinsics.checkNotNullParameter(deleteOptions, "deleteOptions");
                                DeleteResult result2 = this.$db.getCollection(this.$collection).deleteMany(this.$filter, deleteOptions);
                                Pair[] pairArray = new Pair[]{TuplesKt.to("acknowledged", result2.wasAcknowledged()), TuplesKt.to("deletedCount", result2.getDeletedCount())};
                                return MapsKt.mapOf(pairArray);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value deleteOne(@NotNull String database, @NotNull String collection, @NotNull Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$collection, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new DeleteOptions(), OptionConvertersKt.getDeleteConverters(), OptionConvertersKt.getDeleteDefaultConverter(), this.$opt).map((Function1)new Function1<DeleteOptions, Map<String, ? extends Object>>(db, this.$collection, this.$filter){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Object> invoke(@NotNull DeleteOptions deleteOptions) {
                                Intrinsics.checkNotNullParameter(deleteOptions, "deleteOptions");
                                DeleteResult result2 = this.$db.getCollection(this.$collection).deleteOne(this.$filter, deleteOptions);
                                Pair[] pairArray = new Pair[]{TuplesKt.to("acknowledged", result2.wasAcknowledged()), TuplesKt.to("deletedCount", result2.getDeletedCount())};
                                return MapsKt.mapOf(pairArray);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value findOneAndDelete(@NotNull String database, @NotNull String collection, @NotNull Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Document>>>((Map<String, ? extends Object>)opt, this.$collection, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Document>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new FindOneAndDeleteOptions(), OptionConvertersKt.getFindOneAndDeleteConverters(), OptionConvertersKt.getFindOneAndDeleteDefaultConverter(), this.$opt).map((Function1)new Function1<FindOneAndDeleteOptions, Map<String, ? extends Document>>(db, this.$collection, this.$filter){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Document> invoke(@NotNull FindOneAndDeleteOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                Document res = this.$db.getCollection(this.$collection).findOneAndDelete(this.$filter, opt);
                                return MapsKt.mapOf(TuplesKt.to("value", res));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value findOneAndReplace(@NotNull String database, @NotNull String collection, @NotNull Value filter, @NotNull Value replacement, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        return this.promise((Function0)new Function0<Either<? extends Map<String, ? extends Document>>>(this, filter, replacement, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $replacement;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$replacement = $replacement;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Map<String, Document>> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document replacement = JavaServiceProvider.access$toDocument(this.this$0, this.$replacement, "replacement");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Document>>>((Map<String, ? extends Object>)opt, this.$collection, filter, replacement){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    final /* synthetic */ Document $replacement;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        this.$replacement = $replacement;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Document>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new FindOneAndReplaceOptions(), OptionConvertersKt.getFindOneAndReplaceOptionsConverters(), OptionConvertersKt.getFindOneAndReplaceOptionsDefaultConverters(), this.$opt).map((Function1)new Function1<FindOneAndReplaceOptions, Map<String, ? extends Document>>(db, this.$collection, this.$filter, this.$replacement){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            final /* synthetic */ Document $replacement;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                this.$replacement = $replacement;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Document> invoke(@NotNull FindOneAndReplaceOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                Document res = this.$db.getCollection(this.$collection).findOneAndReplace(this.$filter, this.$replacement, opt);
                                return MapsKt.mapOf(TuplesKt.to("value", res));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value findOneAndUpdate(@NotNull String database, @NotNull String collection, @NotNull Value filter, @NotNull Value update, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(filter, "filter");
        Intrinsics.checkNotNullParameter(update, "update");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, update, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $update;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$update = $update;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document update = JavaServiceProvider.access$toDocument(this.this$0, this.$update, "update");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Document>>>((Map<String, ? extends Object>)opt, this.$collection, filter, update){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    final /* synthetic */ Document $update;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        this.$update = $update;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Document>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new FindOneAndUpdateOptions(), OptionConvertersKt.getFindOneAndUpdateConverters(), OptionConvertersKt.getFindOneAndUpdateDefaultConverter(), this.$opt).map((Function1)new Function1<FindOneAndUpdateOptions, Map<String, ? extends Document>>(db, this.$collection, this.$filter, this.$update){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            final /* synthetic */ Document $update;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                this.$update = $update;
                                super(1);
                            }

                            @NotNull
                            public final Map<String, Document> invoke(@NotNull FindOneAndUpdateOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                Document res = this.$db.getCollection(this.$collection).findOneAndUpdate((Bson)this.$filter, (Bson)this.$update, opt);
                                return MapsKt.mapOf(TuplesKt.to("value", res));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value insertMany(@NotNull String database, @NotNull String collection, @Nullable Value docs, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, options, docs, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $options;
            final /* synthetic */ Value $docs;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$docs = $docs;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                List docs;
                Map dbOptions;
                Map opt;
                block15: {
                    block14: {
                        boolean bl;
                        block13: {
                            Map map;
                            Map map2;
                            Document options;
                            Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                            if (document == null) {
                                map2 = null;
                            } else {
                                Map $this$filterKeys$iv = document;
                                boolean $i$f$filterKeys = false;
                                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                                for (Map.Entry<K, V> entry : $this$filterKeys$iv.entrySet()) {
                                    String string = (String)entry.getKey();
                                    boolean bl2 = false;
                                    if (!(!OptionConvertersKt.getDbConverters().containsKey(string))) continue;
                                    result$iv.put(entry.getKey(), entry.getValue());
                                }
                                map2 = result$iv;
                            }
                            opt = map2;
                            Document document2 = options;
                            if (document2 == null) {
                                map = null;
                            } else {
                                Map $this$filterKeys$iv = document2;
                                boolean $i$f$filterKeys = false;
                                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                                for (Map.Entry<K, V> entry : $this$filterKeys$iv.entrySet()) {
                                    String it2 = (String)entry.getKey();
                                    boolean bl3 = false;
                                    if (!OptionConvertersKt.getDbConverters().containsKey(it2)) continue;
                                    result$iv.put(entry.getKey(), entry.getValue());
                                }
                                map = result$iv;
                            }
                            dbOptions = map;
                            docs = JavaServiceProvider.access$toList(this.this$0, this.$docs, "docs");
                            if (docs == null) break block14;
                            Iterable $this$any$iv = docs;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                Iterator<Map.Entry<K, V>> iterator2 = $this$any$iv.iterator();
                                while (iterator2.hasNext()) {
                                    Map.Entry<K, V> entry;
                                    Map.Entry<K, V> entry2 = entry = iterator2.next();
                                    boolean bl4 = false;
                                    if (!(!(entry2 instanceof Document))) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block15;
                    }
                    return new Left<T>(new IllegalArgumentException("docs must be a list of objects"));
                }
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Map<String, ? extends Object>>>((Map<String, ? extends Object>)opt, this.$collection, (List<? extends Object>)docs){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ List<Object> $docs;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$docs = $docs;
                        super(1);
                    }

                    @NotNull
                    public final Either<Map<String, Object>> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new InsertManyOptions(), OptionConvertersKt.getInsertManyConverters(), OptionConvertersKt.getInsertManyDefaultConverter(), this.$opt).map((Function1)new Function1<InsertManyOptions, Map<String, ? extends Object>>(db, this.$collection, this.$docs){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ List<Object> $docs;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$docs = $docs;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Map<String, Object> invoke(@NotNull InsertManyOptions opt) {
                                void $this$filterIsInstanceTo$iv$iv;
                                void $this$filterIsInstance$iv;
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                Pair[] pairArray = (Pair[])this.$docs;
                                MongoCollection<Document> mongoCollection = this.$db.getCollection(this.$collection);
                                boolean $i$f$filterIsInstance = false;
                                void var4_5 = $this$filterIsInstance$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterIsInstanceTo = false;
                                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                    if (!(element$iv$iv instanceof Document)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                mongoCollection.insertMany((List)destination$iv$iv, opt);
                                pairArray = new Pair[]{TuplesKt.to("acknowledged", true), TuplesKt.to("insertedIds", CollectionsKt.emptyList())};
                                return MapsKt.mapOf(pairArray);
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @HostAccess.Export
    @NotNull
    public Cursor aggregate(@NotNull String database, @NotNull String collection, @Nullable Value pipeline, @Nullable Value options, @Nullable Value dbOptions) {
        List list;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Object it;
        List<Object> pipeline2;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    Intrinsics.checkNotNullParameter(database, "database");
                    Intrinsics.checkNotNullParameter(collection, "collection");
                    pipeline2 = this.toList(pipeline, "pipeline");
                    if (pipeline2 == null) break block10;
                    Iterable $this$any$iv = pipeline2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv;
                            it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!(!(it instanceof Document))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            throw new IllegalArgumentException("pipeline must be a list of objects");
        }
        Document options2 = this.toDocument(options, "options");
        Document dbOptions2 = this.toDocument(dbOptions, "dbOptions");
        MongoDatabase db = this.getDatabase(database, dbOptions2).getOrThrow();
        it = pipeline2;
        String string = collection;
        MongoDatabase mongoDatabase = db;
        boolean $i$f$filterIsInstance = false;
        void var13_16 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Document)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        String string2 = string;
        MongoDatabase mongoDatabase2 = mongoDatabase;
        AggregateCreateOptions createOptions = new AggregateCreateOptions(mongoDatabase2, string2, list2);
        Document document = options2;
        if (document == null) {
            document = new Document();
        }
        Document opt = document;
        return new Cursor(new AggregateIterableHelper(BaseMongoIterableHelperKt.aggregate(opt, createOptions), this.converter, opt, createOptions), this.converter, this.wrapper);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @HostAccess.Export
    @NotNull
    public Cursor aggregateDb(@NotNull String database, @Nullable Value pipeline, @Nullable Value options, @Nullable Value dbOptions) {
        List list;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Object it;
        List<Object> pipeline2;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    Intrinsics.checkNotNullParameter(database, "database");
                    pipeline2 = this.toList(pipeline, "pipeline");
                    if (pipeline2 == null) break block10;
                    Iterable $this$any$iv = pipeline2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv;
                            it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!(!(it instanceof Document))) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            throw new IllegalArgumentException("pipeline must be a list of objects");
        }
        Document options2 = this.toDocument(options, "options");
        Document dbOptions2 = this.toDocument(dbOptions, "dbOptions");
        MongoDatabase db = this.getDatabase(database, dbOptions2).getOrThrow();
        it = pipeline2;
        String string = null;
        MongoDatabase mongoDatabase = db;
        boolean $i$f$filterIsInstance = false;
        void var12_15 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Document)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = list = (List)destination$iv$iv;
        String string2 = string;
        MongoDatabase mongoDatabase2 = mongoDatabase;
        AggregateCreateOptions createOptions = new AggregateCreateOptions(mongoDatabase2, string2, list2);
        Document document = options2;
        if (document == null) {
            document = new Document();
        }
        Document opt = document;
        return new Cursor(new AggregateIterableHelper(BaseMongoIterableHelperKt.aggregate(opt, createOptions), this.converter, opt, createOptions), this.converter, this.wrapper);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value count(@NotNull String database, @NotNull String collection, @Nullable Value query, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Long>>(this, query, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $query;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$query = $query;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Long> invoke() {
                Map map;
                Map map2;
                Document options;
                Document query = JavaServiceProvider.access$toDocument(this.this$0, this.$query, "query");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Long>>((Map<String, ? extends Object>)opt, this.$collection, query){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $query;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$query = $query;
                        super(1);
                    }

                    @NotNull
                    public final Either<Long> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new CountOptions(), OptionConvertersKt.getCountOptionsConverters(), OptionConvertersKt.getCountOptionsDefaultConverter(), this.$opt).map((Function1)new Function1<CountOptions, Long>(db, this.$collection, this.$query){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $query;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$query = $query;
                                super(1);
                            }

                            @NotNull
                            public final Long invoke(@NotNull CountOptions countOptions) {
                                Intrinsics.checkNotNullParameter(countOptions, "countOptions");
                                return this.$db.getCollection(this.$collection).countDocuments(this.$query, countOptions);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value countDocuments(@NotNull String database, @NotNull String collection, @Nullable Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Long>>(this, filter, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Long> invoke() {
                Map map;
                Map map2;
                Document options;
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Long>>((Map<String, ? extends Object>)opt, this.$collection, filter){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ Document $filter;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Either<Long> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new CountOptions(), OptionConvertersKt.getCountOptionsConverters(), OptionConvertersKt.getCountOptionsDefaultConverter(), this.$opt).map((Function1)new Function1<CountOptions, Long>(db, this.$collection, this.$filter){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Document $filter;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$filter = $filter;
                                super(1);
                            }

                            @NotNull
                            public final Long invoke(@NotNull CountOptions countOptions) {
                                Intrinsics.checkNotNullParameter(countOptions, "countOptions");
                                return this.$db.getCollection(this.$collection).countDocuments(this.$filter, countOptions);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value distinct(@NotNull String database, @NotNull String collection, @NotNull String fieldName, @Nullable Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(fieldName, "fieldName");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, filter, options, database, collection, fieldName){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            final /* synthetic */ String $fieldName;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                this.$fieldName = $fieldName;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Document document;
                Document filter;
                Document document2 = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                if (document2 == null) {
                    document2 = filter = new Document();
                }
                if ((document = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options")) == null) {
                    document = new Document();
                }
                Document options = document;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Object>>(options, this.$collection, this.$fieldName, filter, this.this$0){
                    final /* synthetic */ Document $options;
                    final /* synthetic */ String $collection;
                    final /* synthetic */ String $fieldName;
                    final /* synthetic */ Document $filter;
                    final /* synthetic */ JavaServiceProvider this$0;
                    {
                        this.$options = $options;
                        this.$collection = $collection;
                        this.$fieldName = $fieldName;
                        this.$filter = $filter;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Either<Object> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        Object object = this.$options.get("collation");
                        Document collationDoc = object instanceof Document ? (Document)object : null;
                        object = Collation.builder();
                        Intrinsics.checkNotNullExpressionValue(object, "builder()");
                        return OptionConvertersKt.convert(object, OptionConvertersKt.getCollationConverters(), OptionConvertersKt.getCollationDefaultConverter(), collationDoc).map((Function1)new Function1<Collation.Builder, Object>(this.$collection, this.$fieldName, this.$filter, this.$options, db, this.this$0){
                            final /* synthetic */ String $collection;
                            final /* synthetic */ String $fieldName;
                            final /* synthetic */ Document $filter;
                            final /* synthetic */ Document $options;
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ JavaServiceProvider this$0;
                            {
                                this.$collection = $collection;
                                this.$fieldName = $fieldName;
                                this.$filter = $filter;
                                this.$options = $options;
                                this.$db = $db;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final Object invoke(@NotNull Collation.Builder $noName_0) {
                                Document res;
                                Intrinsics.checkNotNullParameter($noName_0, "$noName_0");
                                Document command = new Document();
                                ((Map)command).put("distinct", this.$collection);
                                ((Map)command).put("key", this.$fieldName);
                                ((Map)command).put("query", this.$filter);
                                if (this.$options.get("collation") != null) {
                                    ((Map)command).put("collation", this.$options.get("collation"));
                                }
                                if (!JavaServiceProvider.access$interpretAsBoolean(this.this$0, (res = this.$db.runCommand(command)).get("ok")) || !res.containsKey("values")) {
                                    throw new Exception("Command failed. Command: " + command.toJson() + ". Result: " + res.toJson());
                                }
                                return JavaServiceProvider.access$getConverter$p(this.this$0).toJs(res.get("values"));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value estimatedDocumentCount(@NotNull String database, @NotNull String collection, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Map map2;
                Document options;
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map2 = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map2 = result$iv;
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document2;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Long>>((Map<String, ? extends Object>)opt, this.$collection){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        super(1);
                    }

                    @NotNull
                    public final Either<Long> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new EstimatedDocumentCountOptions(), OptionConvertersKt.getEstimatedCountOptionsConverters(), OptionConvertersKt.getEstimatedCountOptionsDefaultConverter(), this.$opt).map((Function1)new Function1<EstimatedDocumentCountOptions, Long>(db, this.$collection){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                super(1);
                            }

                            @NotNull
                            public final Long invoke(@NotNull EstimatedDocumentCountOptions countOptions) {
                                Intrinsics.checkNotNullParameter(countOptions, "countOptions");
                                return this.$db.getCollection(this.$collection).estimatedDocumentCount(countOptions);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Cursor find(@NotNull String database, @NotNull String collection, @Nullable Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        Document filter2 = this.toDocument(filter, "filter");
        Document options2 = this.toDocument(options, "options");
        MongoClient mongoClient = this.client;
        Intrinsics.checkNotNull(mongoClient);
        MongoDatabase db = mongoClient.getDatabase(database);
        Intrinsics.checkNotNullExpressionValue(db, "db");
        Document document = filter2;
        if (document == null) {
            document = new Document();
        }
        FindCreateOptions createOptions = new FindCreateOptions(db, collection, document);
        Document document2 = options2;
        if (document2 == null) {
            document2 = new Document();
        }
        Document opt = document2;
        return new Cursor(new FindIterableHelper(BaseMongoIterableHelperKt.find(opt, createOptions), this.converter, opt, createOptions), this.converter, this.wrapper);
    }

    private final Document toDocument(Value value, String fieldName) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (!value.hasMembers()) {
            throw new IllegalArgumentException(fieldName + " should be an object: " + value);
        }
        return ((DocumentResult)MongoShellConverter.toJava$default(this.converter, value, null, 2, null)).getValue();
    }

    private final List<Object> toList(Value value, String fieldName) {
        if (value == null || value.isNull()) {
            return null;
        }
        if (!value.hasArrayElements()) {
            throw new IllegalArgumentException(fieldName + " should be a list: " + value);
        }
        return ((ArrayResult)MongoShellConverter.toJava$default(this.converter, value, null, 2, null)).getValue();
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getTopology() {
        return this.promise(getTopology.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value listDatabases(@NotNull String database, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        return this.promise((Function0)new Function0<Either<? extends Map<String, ? extends ListDatabasesIterable<Document>>>>(this){
            final /* synthetic */ JavaServiceProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Either<Map<String, ListDatabasesIterable<Document>>> invoke() {
                MongoClient mongoClient = JavaServiceProvider.access$getClient$p(this.this$0);
                Intrinsics.checkNotNull(mongoClient);
                return new Right<Map<String, ListDatabasesIterable<Document>>>(MapsKt.mapOf(TuplesKt.to("databases", mongoClient.listDatabases())));
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getNewConnection(@NotNull String uri, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        return this.promise(getNewConnection.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value readPreferenceFromOptions(@Nullable Value options) {
        return this.promise(readPreferenceFromOptions.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getConnectionInfo() {
        return this.promise(getConnectionInfo.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value authenticate(@NotNull Value authDoc) {
        Intrinsics.checkNotNullParameter(authDoc, "authDoc");
        return this.promise(authenticate.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getIndexes(@NotNull String database, @NotNull String collection, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends ListIndexesIterable<Document>>>(this, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<ListIndexesIterable<Document>> invoke() {
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).map((Function1)new Function1<MongoDatabase, ListIndexesIterable<Document>>(this.$collection){
                    final /* synthetic */ String $collection;
                    {
                        this.$collection = $collection;
                        super(1);
                    }

                    public final ListIndexesIterable<Document> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return db.getCollection(this.$collection).listIndexes();
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value listCollections(@NotNull String database, @Nullable Value filter, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        return this.promise((Function0)new Function0<Either<? extends ListCollectionsIterable<Document>>>(this, filter, database){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $filter;
            final /* synthetic */ String $database;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$database = $database;
                super(0);
            }

            @NotNull
            public final Either<ListCollectionsIterable<Document>> invoke() {
                Document filter = JavaServiceProvider.access$toDocument(this.this$0, this.$filter, "filter");
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).map((Function1)new Function1<MongoDatabase, ListCollectionsIterable<Document>>(filter){
                    final /* synthetic */ Document $filter;
                    {
                        this.$filter = $filter;
                        super(1);
                    }

                    public final ListCollectionsIterable<Document> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        ListCollectionsIterable<Document> list = db.listCollections();
                        if (this.$filter != null) {
                            list.filter(this.$filter);
                        }
                        return list;
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value createCollection(@NotNull String database, @NotNull String collection, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Unit>>(this, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Unit> invoke() {
                Map map;
                Map map2;
                String it;
                LinkedHashMap<K, V> result$iv;
                boolean $i$f$filterKeys;
                Map $this$filterKeys$iv;
                Map map3;
                Document options;
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map3 = null;
                } else {
                    $this$filterKeys$iv = document;
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!(!OptionConvertersKt.getDbConverters().containsKey(it))) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map3 = map2 = (Map)result$iv;
                }
                if (map3 == null) {
                    map2 = new Document();
                }
                Map opt = map2;
                Document document2 = options;
                if (document2 == null) {
                    map = null;
                } else {
                    $this$filterKeys$iv = document2;
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Unit>>((Map<String, ? extends Object>)opt, this.$collection){
                    final /* synthetic */ Map<String, Object> $opt;
                    final /* synthetic */ String $collection;
                    {
                        this.$opt = $opt;
                        this.$collection = $collection;
                        super(1);
                    }

                    @NotNull
                    public final Either<Unit> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        Object viewOn = this.$opt.get("viewOn");
                        return viewOn instanceof String ? OptionConvertersKt.convert(new CreateViewOptions(), OptionConvertersKt.getCreateViewOptionsConverters(), OptionConvertersKt.getCreateViewOptionsConverter(), this.$opt).map((Function1)new Function1<CreateViewOptions, Unit>(this.$opt, db, this.$collection, viewOn){
                            final /* synthetic */ Map<String, Object> $opt;
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            final /* synthetic */ Object $viewOn;
                            {
                                this.$opt = $opt;
                                this.$db = $db;
                                this.$collection = $collection;
                                this.$viewOn = $viewOn;
                                super(1);
                            }

                            public final void invoke(@NotNull CreateViewOptions createViewOptions) {
                                Intrinsics.checkNotNullParameter(createViewOptions, "createViewOptions");
                                Object object = this.$opt.get("pipeline");
                                List list = object instanceof List ? (List)object : null;
                                List<Document> pipeline = list == null ? null : CollectionsKt.filterIsInstance(list, Document.class);
                                List<Document> list2 = pipeline;
                                List list3 = list2 == null ? null : CollectionsKt.toMutableList((Collection)list2);
                                this.$db.createView(this.$collection, (String)this.$viewOn, list3 == null ? (List)new ArrayList<E>() : list3, createViewOptions);
                            }
                        }) : OptionConvertersKt.convert(new CreateCollectionOptions(), OptionConvertersKt.getCreateCollectionOptionsConverters(), OptionConvertersKt.getCreateCollectionOptionsConverter(), this.$opt).map((Function1)new Function1<CreateCollectionOptions, Unit>(db, this.$collection){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                super(1);
                            }

                            public final void invoke(@NotNull CreateCollectionOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                this.$db.createCollection(this.$collection, opt);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getReadPreference() {
        return this.promise(getReadPreference.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getReadConcern() {
        return this.promise(getReadConcern.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value getWriteConcern() {
        return this.promise(getWriteConcern.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value resetConnectionOptions() {
        return this.promise(resetConnectionOptions.1.INSTANCE);
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value createIndexes(@NotNull String database, @NotNull String collection, @Nullable Value indexSpecs, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, indexSpecs, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $indexSpecs;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$indexSpecs = $indexSpecs;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Map map;
                Document options;
                boolean bl;
                List<T> indexSpecs;
                block8: {
                    List<T> list = JavaServiceProvider.access$toList(this.this$0, this.$indexSpecs, "indexSpecs");
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    indexSpecs = list;
                    Iterable $this$any$iv = indexSpecs;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        Iterator<T> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            T element$iv;
                            T it = element$iv = iterator2.next();
                            boolean bl2 = false;
                            if (!(!(it instanceof Document))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus("Index specs must be a list of documents. Got ", indexSpecs));
                }
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl3 = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).flatMap((Function1)new Function1<MongoDatabase, Either<? extends List<String>>>(indexSpecs, this.this$0, this.$collection){
                    final /* synthetic */ List<Object> $indexSpecs;
                    final /* synthetic */ JavaServiceProvider this$0;
                    final /* synthetic */ String $collection;
                    {
                        this.$indexSpecs = $indexSpecs;
                        this.this$0 = $receiver;
                        this.$collection = $collection;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Either<List<String>> invoke(@NotNull MongoDatabase db) {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkNotNullParameter(db, "db");
                        Iterable $this$map$iv = this.$indexSpecs;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            void spec;
                            T item$iv$iv;
                            T t = item$iv$iv = iterator2.next();
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v0 = spec;
                            if (v0 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.bson.Document");
                            }
                            collection.add(OptionConvertersKt.convert(new IndexModel(new Document()), OptionConvertersKt.getIndexModelConverters(), OptionConvertersKt.getIndexModelDefaultConverter(), (Document)v0));
                        }
                        List convertedIndexes = (List)destination$iv$iv;
                        Either indexes = JavaServiceProvider.access$unwrap(this.this$0, convertedIndexes);
                        return indexes.map((Function1)new Function1<List<? extends IndexModel>, List<String>>(db, this.$collection){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $collection;
                            {
                                this.$db = $db;
                                this.$collection = $collection;
                                super(1);
                            }

                            public final List<String> invoke(@NotNull List<? extends IndexModel> indexes) {
                                Intrinsics.checkNotNullParameter(indexes, "indexes");
                                return this.$db.getCollection(this.$collection).createIndexes(indexes);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value dropCollection(@NotNull String database, @NotNull String collection, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise((Function0)new Function0<Either<? extends Unit>>(this, options, database, collection){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $collection;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$database = $database;
                this.$collection = $collection;
                super(0);
            }

            @NotNull
            public final Either<Unit> invoke() {
                Map map;
                Document options;
                Document document = options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                if (document == null) {
                    map = null;
                } else {
                    Map $this$filterKeys$iv = document;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!OptionConvertersKt.getDbConverters().containsKey(it)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    map = result$iv;
                }
                Map dbOptions = map;
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, dbOptions).map((Function1)new Function1<MongoDatabase, Unit>(this.$collection){
                    final /* synthetic */ String $collection;
                    {
                        this.$collection = $collection;
                        super(1);
                    }

                    public final void invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        db.getCollection(this.$collection).drop();
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value renameCollection(@NotNull String database, @NotNull String oldName, @NotNull String newName, @Nullable Value options) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(oldName, "oldName");
        Intrinsics.checkNotNullParameter(newName, "newName");
        return this.promise((Function0)new Function0<Either<? extends Object>>(this, options, database, oldName, newName){
            final /* synthetic */ JavaServiceProvider this$0;
            final /* synthetic */ Value $options;
            final /* synthetic */ String $database;
            final /* synthetic */ String $oldName;
            final /* synthetic */ String $newName;
            {
                this.this$0 = $receiver;
                this.$options = $options;
                this.$database = $database;
                this.$oldName = $oldName;
                this.$newName = $newName;
                super(0);
            }

            @NotNull
            public final Either<Object> invoke() {
                Document options = JavaServiceProvider.access$toDocument(this.this$0, this.$options, "options");
                return JavaServiceProvider.access$getDatabase(this.this$0, this.$database, null).flatMap((Function1)new Function1<MongoDatabase, Either<? extends Unit>>(options, this.$oldName, this.$database, this.$newName){
                    final /* synthetic */ Document $options;
                    final /* synthetic */ String $oldName;
                    final /* synthetic */ String $database;
                    final /* synthetic */ String $newName;
                    {
                        this.$options = $options;
                        this.$oldName = $oldName;
                        this.$database = $database;
                        this.$newName = $newName;
                        super(1);
                    }

                    @NotNull
                    public final Either<Unit> invoke(@NotNull MongoDatabase db) {
                        Intrinsics.checkNotNullParameter(db, "db");
                        return OptionConvertersKt.convert(new RenameCollectionOptions(), OptionConvertersKt.getRenameCollectionConverters(), OptionConvertersKt.getRenameCollectionDefaultConverter(), this.$options).map((Function1)new Function1<RenameCollectionOptions, Unit>(db, this.$oldName, this.$database, this.$newName){
                            final /* synthetic */ MongoDatabase $db;
                            final /* synthetic */ String $oldName;
                            final /* synthetic */ String $database;
                            final /* synthetic */ String $newName;
                            {
                                this.$db = $db;
                                this.$oldName = $oldName;
                                this.$database = $database;
                                this.$newName = $newName;
                                super(1);
                            }

                            public final void invoke(@NotNull RenameCollectionOptions opt) {
                                Intrinsics.checkNotNullParameter(opt, "opt");
                                this.$db.getCollection(this.$oldName).renameCollection(new MongoNamespace(this.$database, this.$newName), opt);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @HostAccess.Export
    @NotNull
    public Value initializeBulkOp(@NotNull String database, @NotNull String collection, boolean ordered, @Nullable Value options, @Nullable Value dbOptions) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(collection, "collection");
        return this.promise(initializeBulkOp.1.INSTANCE);
    }

    private final <T> Value promise(Function0<? extends Either<? extends T>> block) {
        return this.converter.toJsPromise(block.invoke());
    }

    public final void setClient(@NotNull MongoClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.client = client;
    }

    public static final /* synthetic */ Either access$getDatabase(JavaServiceProvider $this, String database, Map dbOptions) {
        return $this.getDatabase(database, dbOptions);
    }

    public static final /* synthetic */ Document access$toDocument(JavaServiceProvider $this, Value value, String fieldName) {
        return $this.toDocument(value, fieldName);
    }

    public static final /* synthetic */ boolean access$interpretAsBoolean(JavaServiceProvider $this, Object v) {
        return $this.interpretAsBoolean(v);
    }

    public static final /* synthetic */ List access$toList(JavaServiceProvider $this, Value value, String fieldName) {
        return $this.toList(value, fieldName);
    }

    public static final /* synthetic */ Either access$unwrap(JavaServiceProvider $this, List l) {
        return $this.unwrap(l);
    }

    public static final /* synthetic */ Either access$getWriteModel(JavaServiceProvider $this, Document model) {
        return $this.getWriteModel(model);
    }

    public static final /* synthetic */ MongoShellConverter access$getConverter$p(JavaServiceProvider $this) {
        return $this.converter;
    }

    public static final /* synthetic */ MongoClient access$getClient$p(JavaServiceProvider $this) {
        return $this.client;
    }
}

