/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class JSConstantNode
extends JavaScriptNode
implements RepeatableNode {
    public static JSConstantNode create(Object value) {
        assert (!(value instanceof Long) && !(value instanceof BigInteger));
        if (value instanceof Integer) {
            return JSConstantNode.createInt((Integer)value);
        }
        if (value instanceof Double) {
            double doubleValue = (Double)value;
            if (JSRuntime.doubleIsRepresentableAsInt(doubleValue)) {
                return JSConstantNode.createInt((int)doubleValue);
            }
            return JSConstantNode.createDouble(doubleValue);
        }
        if (value instanceof Boolean) {
            return JSConstantNode.createBoolean((Boolean)value);
        }
        if (value instanceof TruffleString) {
            return JSConstantNode.createString((TruffleString)value);
        }
        if (value == Null.instance) {
            return JSConstantNode.createNull();
        }
        if (value == Undefined.instance) {
            return JSConstantNode.createUndefined();
        }
        if (value instanceof BigInt) {
            return JSConstantNode.createBigInt((BigInt)value);
        }
        if (value instanceof SafeInteger) {
            return JSConstantNode.createSafeInteger((SafeInteger)value);
        }
        if (JSDynamicObject.isJSDynamicObject(value)) {
            return new JSConstantJSObjectNode((JSDynamicObject)value);
        }
        assert (!(value instanceof String));
        return new JSConstantObjectNode(value);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor();
        if (this instanceof JSConstantDoubleNode || this instanceof JSConstantIntegerNode || this instanceof JSConstantSafeIntegerNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.NumericLiteral.name());
        } else if (this instanceof JSConstantBigIntNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.BigIntLiteral.name());
        } else if (this instanceof JSConstantBooleanNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.BooleanLiteral.name());
        } else if (this instanceof JSConstantStringNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.StringLiteral.name());
        } else if (this instanceof JSConstantNullNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.NullLiteral.name());
        } else if (this instanceof JSConstantUndefinedNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.UndefinedLiteral.name());
        } else if (this instanceof JSConstantObjectNode || this instanceof JSConstantJSObjectNode) {
            descriptor.addProperty("literalType", (Object)JSTags.LiteralTag.Type.ObjectLiteral.name());
        }
        return descriptor;
    }

    public static JSConstantNode createUndefined() {
        return new JSConstantUndefinedNode();
    }

    public static JSConstantNode createNull() {
        return new JSConstantNullNode();
    }

    public static JSConstantNode createInt(int value) {
        return new JSConstantIntegerNode(value);
    }

    public static JSConstantNode createSafeInteger(SafeInteger value) {
        return new JSConstantSafeIntegerNode(value);
    }

    public static JSConstantNode createBigInt(BigInt value) {
        return new JSConstantBigIntNode(value);
    }

    public static JSConstantNode createDouble(double value) {
        return new JSConstantDoubleNode(value);
    }

    public static JSConstantNode createConstantNumericUnit() {
        return new JSConstantNumericUnitNode();
    }

    public static JSConstantNode createBoolean(boolean value) {
        return new JSConstantBooleanNode(value);
    }

    public static JSConstantNode createString(TruffleString value) {
        return new JSConstantStringNode(value);
    }

    public abstract Object getValue();

    @Override
    public final void executeVoid(VirtualFrame frame) {
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return this.copy();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Map<String, Object> getDebugProperties() {
        Map<String, Object> map = super.getDebugProperties();
        map.put("value", Strings.isTString(this.getValue()) ? JSRuntime.quote(Strings.toJavaString((TruffleString)this.getValue())) : this.getValue());
        return map;
    }

    @Override
    public String expressionToString() {
        Object value = this.getValue();
        if (JSRuntime.isJSPrimitive(value)) {
            String string = JSRuntime.toJavaString(value);
            if (Strings.isTString(value)) {
                return JSRuntime.quote(string);
            }
            return string;
        }
        return null;
    }

    public static final class JSConstantStringNode
    extends JSConstantNode {
        private final TruffleString stringValue;

        private JSConstantStringNode(TruffleString str) {
            this.stringValue = Objects.requireNonNull(str);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.stringValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == TruffleString.class;
        }

        @Override
        public Object getValue() {
            return this.stringValue;
        }
    }

    public static final class JSConstantUndefinedNode
    extends JSConstantNode {
        private JSConstantUndefinedNode() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Undefined.instance;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == JSDynamicObject.class;
        }

        @Override
        public Object getValue() {
            return Undefined.instance;
        }
    }

    public static final class JSConstantNullNode
    extends JSConstantNode {
        private JSConstantNullNode() {
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Null.instance;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == JSDynamicObject.class;
        }

        @Override
        public Object getValue() {
            return Null.instance;
        }
    }

    private static final class JSConstantJSObjectNode
    extends JSConstantNode {
        private final JSDynamicObject objectValue;

        private JSConstantJSObjectNode(JSDynamicObject obj) {
            this.objectValue = obj;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.objectValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == JSDynamicObject.class;
        }

        @Override
        public Object getValue() {
            return this.objectValue;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.LiteralTag.class) {
                return false;
            }
            return super.hasTag(tag);
        }
    }

    private static final class JSConstantObjectNode
    extends JSConstantNode {
        private final Object objectValue;

        private JSConstantObjectNode(Object obj) {
            this.objectValue = obj;
            assert (!(obj instanceof JavaScriptNode)) : "must be JS value";
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.objectValue;
        }

        @Override
        public Object getValue() {
            return this.objectValue;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.LiteralTag.class) {
                return false;
            }
            return super.hasTag(tag);
        }
    }

    public static final class JSConstantBooleanNode
    extends JSConstantNode {
        private final boolean booleanValue;

        private JSConstantBooleanNode(boolean value) {
            this.booleanValue = value;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Boolean.TYPE;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.booleanValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.booleanValue ? 1.0 : 0.0;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frame) {
            return this.booleanValue;
        }

        @Override
        public Object getValue() {
            return this.booleanValue;
        }
    }

    public static final class JSConstantSafeIntegerNode
    extends JSConstantNode {
        private final SafeInteger safeIntValue;

        private JSConstantSafeIntegerNode(SafeInteger value) {
            this.safeIntValue = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.safeIntValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.safeIntValue.doubleValue();
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Number.class || clazz == Double.TYPE;
        }

        @Override
        public Object getValue() {
            return this.safeIntValue;
        }
    }

    public static final class JSConstantBigIntNode
    extends JSConstantNode {
        private final BigInt bigIntValue;

        private JSConstantBigIntNode(BigInt value) {
            this.bigIntValue = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.bigIntValue;
        }

        public BigInt executeBigInt(VirtualFrame frame) {
            return this.bigIntValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == BigInt.class;
        }

        @Override
        public Object getValue() {
            return this.bigIntValue;
        }
    }

    public static final class JSConstantNumericUnitNode
    extends JSConstantNode {
        private JSConstantNumericUnitNode() {
        }

        @Override
        public boolean isInstrumentable() {
            return false;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            throw Errors.shouldNotReachHere();
        }

        @Override
        public Object getValue() {
            throw Errors.shouldNotReachHere();
        }
    }

    public static final class JSConstantIntegerNode
    extends JSConstantNode {
        private final int intValue;

        private JSConstantIntegerNode(int value) {
            this.intValue = value;
        }

        @Override
        public int executeInt(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.intValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Integer.TYPE;
        }

        @Override
        public Object getValue() {
            return this.intValue;
        }
    }

    public static final class JSConstantDoubleNode
    extends JSConstantNode {
        private final double doubleValue;

        private JSConstantDoubleNode(double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.doubleValue;
        }

        @Override
        public double executeDouble(VirtualFrame frame) {
            return this.doubleValue;
        }

        @Override
        public boolean isResultAlwaysOfType(Class<?> clazz) {
            return clazz == Double.TYPE;
        }

        @Override
        public Object getValue() {
            return this.doubleValue;
        }
    }
}

