/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.configuration;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.OverridableUuidRepresentationCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.internal.ProvidersCodecRegistry;

final class OverridableUuidRepresentationCodecProvider
implements CodecProvider {
    private final CodecProvider wrapped;
    private final UuidRepresentation uuidRepresentation;

    OverridableUuidRepresentationCodecProvider(CodecProvider wrapped, UuidRepresentation uuidRepresentation) {
        this.uuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
        this.wrapped = Assertions.notNull("wrapped", wrapped);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.get(clazz, Collections.emptyList(), registry);
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, List<Type> typeArguments, CodecRegistry registry) {
        Codec<T> codec = ProvidersCodecRegistry.getFromCodecProvider(this.wrapped, clazz, typeArguments, registry);
        if (codec instanceof OverridableUuidRepresentationCodec) {
            Codec codecWithUuidRepresentation = ((OverridableUuidRepresentationCodec)((Object)codec)).withUuidRepresentation(this.uuidRepresentation);
            codec = codecWithUuidRepresentation;
        }
        return codec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverridableUuidRepresentationCodecProvider that = (OverridableUuidRepresentationCodecProvider)o;
        if (!this.wrapped.equals(that.wrapped)) {
            return false;
        }
        return this.uuidRepresentation == that.uuidRepresentation;
    }

    public int hashCode() {
        int result2 = this.wrapped.hashCode();
        result2 = 31 * result2 + this.uuidRepresentation.hashCode();
        return result2;
    }

    public String toString() {
        return "OverridableUuidRepresentationCodecRegistry{wrapped=" + this.wrapped + ", uuidRepresentation=" + (Object)((Object)this.uuidRepresentation) + '}';
    }
}

