/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.qiniu;

import com.baidu.qiniu.Total;
import com.baidu.ueditor.UdeitorProperties;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.common.ZoneReqInfo;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.UrlSafeBase64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.springframework.web.multipart.MultipartFile;

public class QiniuUtils {
    public static UdeitorProperties properties;

    public static String upload(MultipartFile file, String fileName) {
        String zoneStr = properties.getQiniu().get("zone");
        Zone zone = QiniuUtils.getByName(zoneStr);
        Configuration cfg = new Configuration(zone);
        UploadManager uploadManager = new UploadManager(cfg);
        String accessKey = properties.getQiniu().get("accessKey");
        String secretKey = properties.getQiniu().get("secretKey");
        String bucket = properties.getQiniu().get("bucket");
        try {
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(file.getBytes());
            Auth auth = Auth.create((String)accessKey, (String)secretKey);
            String upToken = auth.uploadToken(bucket);
            try {
                com.qiniu.http.Response response = uploadManager.put((InputStream)byteInputStream, fileName, upToken, null, null);
                DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
                return properties.getQiniu().get("cdn") + putRet.key;
            }
            catch (QiniuException ex) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String upload(String content, String fileName) {
        String zoneStr = properties.getQiniu().get("zone");
        Zone zone = QiniuUtils.getByName(zoneStr);
        String accessKey = properties.getQiniu().get("accessKey");
        String secretKey = properties.getQiniu().get("secretKey");
        String bucket = properties.getQiniu().get("bucket");
        String url = zone.getUpBackupHttp(new ZoneReqInfo(accessKey, bucket)) + "/putb64/-1/key/" + UrlSafeBase64.encodeToString((String)fileName);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        String upToken = auth.uploadToken(bucket);
        RequestBody rb = RequestBody.create(null, (String)content);
        Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/octet-stream").addHeader("Authorization", "UpToken " + upToken).post(rb).build();
        OkHttpClient client = new OkHttpClient();
        Response response = null;
        try {
            response = client.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultPutRet putRet = (DefaultPutRet)new Gson().fromJson(response.body().charStream(), DefaultPutRet.class);
        if (putRet.key == null) {
            return null;
        }
        return properties.getQiniu().get("cdn") + putRet.key;
    }

    public static List<String> listFile(String prefix, int index, int size, Total total) {
        Configuration cfg = new Configuration(Zone.zone0());
        String accessKey = properties.getQiniu().get("accessKey");
        String secretKey = properties.getQiniu().get("secretKey");
        String bucket = properties.getQiniu().get("bucket");
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        BucketManager bucketManager = new BucketManager(auth, cfg);
        int limit = 1000;
        String delimiter = "";
        BucketManager.FileListIterator fileListIterator = bucketManager.createFileListIterator(bucket, prefix, limit, delimiter);
        FileInfo[] items = null;
        if (fileListIterator.hasNext()) {
            items = fileListIterator.next();
        }
        if (items == null) {
            return null;
        }
        total.setTotal(items.length);
        if (index < 0 || index > items.length) {
            return null;
        }
        return Arrays.stream(items).skip(index).limit(size).map(fileInfo -> properties.getQiniu().get("cdn") + fileInfo.key).collect(Collectors.toList());
    }

    static Zone getByName(String name) {
        Zone zone = null;
        switch (name) {
            case "zone0": {
                zone = Zone.zone0();
                break;
            }
            case "zone1": {
                zone = Zone.zone1();
                break;
            }
            case "zone2": {
                zone = Zone.zone2();
                break;
            }
            case "zoneNa0": {
                zone = Zone.zoneNa0();
                break;
            }
            case "zoneAs0": {
                zone = Zone.zoneAs0();
                break;
            }
            default: {
                throw new RuntimeException("\u767e\u5ea6\u7f16\u8f91\u4e03\u725b\u4e91zone\u914d\u7f6e\u9519\u8bef\uff0chttps://developer.qiniu.com/kodo/sdk/1239/java#server-upload");
            }
        }
        return zone;
    }
}

