/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.grpc;

import com.deep007.mitmproxyjava.MitmRequest;
import com.deep007.mitmproxyjava.MitmResponse;
import com.deep007.mitmproxyjava.grpc.MitmProxyHubClientServerGrpc;
import com.deep007.mitmproxyjava.mitmproxy.RemoteMitmproxy;
import com.deep007.mitmproxyjava.modle.FlowRequest;
import com.deep007.mitmproxyjava.modle.FlowResponse;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MitmproxyFlowCallBackServer {
    private static volatile MitmproxyFlowCallBackServer mitmFlowCallBackServer;
    private Server server = ServerBuilder.forPort((int)60061).addService((BindableService)new MonitorServerImpl()).build();
    public final int port = 60061;
    private boolean isStarted = false;

    public static synchronized MitmproxyFlowCallBackServer getInstance() {
        if (mitmFlowCallBackServer == null) {
            try {
                mitmFlowCallBackServer = new MitmproxyFlowCallBackServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mitmFlowCallBackServer;
    }

    private MitmproxyFlowCallBackServer() throws Exception {
        this.start();
    }

    public int getPort() {
        return 60061;
    }

    private void start() throws Exception {
        if (!this.isStarted) {
            this.server.start();
            Class<?> nettyServerHandlerClass = Class.forName("io.grpc.netty.shaded.io.grpc.netty.NettyServerHandler");
            Field loggerField = nettyServerHandlerClass.getDeclaredField("logger");
            loggerField.setAccessible(true);
            Logger log = (Logger)loggerField.get(null);
            log.setLevel(Level.SEVERE);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    MitmproxyFlowCallBackServer.this.stop();
                }
            });
            this.isStarted = true;
            System.out.println("MitmproxyFlowCallBackServer started on 60061");
        }
    }

    private void stop() {
        if (this.isStarted && this.server != null) {
            this.server.shutdownNow();
            this.server = null;
        }
    }

    private class MonitorServerImpl
    extends MitmProxyHubClientServerGrpc.MitmProxyHubClientServerImplBase {
        private MonitorServerImpl() {
        }

        @Override
        public void onMitmRequest(MitmRequest request, StreamObserver<MitmRequest> responseObserver) {
            String mitmproxyId = request.getMitmproxyId();
            System.out.println("remotemitmproxy " + request.getMethod() + " - " + request.getUrl());
            FlowRequest lRequest = FlowRequest.create(request);
            RemoteMitmproxy remoteMitmproxy = RemoteMitmproxy.RemoteMitmproxies.get(mitmproxyId);
            if (remoteMitmproxy != null) {
                remoteMitmproxy.onRequest(lRequest);
            }
            responseObserver.onNext((Object)lRequest.getMitmRequest());
            responseObserver.onCompleted();
        }

        @Override
        public void onMitmResponse(MitmResponse response, StreamObserver<MitmResponse> responseObserver) {
            String mitmproxyId = response.getMitmproxyId();
            RemoteMitmproxy remoteMitmproxy = RemoteMitmproxy.RemoteMitmproxies.get(mitmproxyId);
            FlowResponse lResponse = FlowResponse.create(response);
            if (remoteMitmproxy != null) {
                remoteMitmproxy.onResponse(lResponse);
            }
            responseObserver.onNext((Object)lResponse.getMitmResponse());
            responseObserver.onCompleted();
        }
    }
}

