/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.data.norm;

import deepnetts.data.MLDataItem;
import deepnetts.util.Tensors;
import java.io.Serializable;
import javax.visrec.ml.data.DataSet;
import javax.visrec.ml.data.Normalizer;

public class DecimalScaleNormalizer
implements Normalizer<DataSet<MLDataItem>>,
Serializable {
    private float[] inputDivisor;
    private float[] outputDivisor;

    public DecimalScaleNormalizer(DataSet<MLDataItem> dataSet) {
        this.inputDivisor = ((MLDataItem)dataSet.get(0)).getInput().copy().getValues();
        this.outputDivisor = ((MLDataItem)dataSet.get(0)).getTargetOutput().copy().getValues();
        for (MLDataItem item : dataSet) {
            this.inputDivisor = Tensors.absMax(item.getInput().getValues(), this.inputDivisor);
            this.outputDivisor = Tensors.absMax(item.getTargetOutput().getValues(), this.outputDivisor);
        }
        for (MLDataItem item : dataSet) {
            this.inputDivisor = this.getDecimalScaleFor(item.getInput().getValues());
            this.outputDivisor = this.getDecimalScaleFor(item.getTargetOutput().getValues());
        }
    }

    private float[] getDecimalScaleFor(float[] values) {
        float[] decimalScales = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            decimalScales[i] = this.getDecimalScaleFor(values[i]);
        }
        return decimalScales;
    }

    private float getDecimalScaleFor(float val) {
        float scale = 1.0f;
        for (val = Math.abs(val); val > 1.0f; val /= (scale *= 10.0f)) {
        }
        return scale;
    }

    public void normalize(DataSet<MLDataItem> dataSet) {
        for (MLDataItem item : dataSet) {
            item.getInput().div(this.inputDivisor);
            item.getTargetOutput().div(this.outputDivisor);
        }
    }
}

