/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.data.norm;

import deepnetts.data.MLDataItem;
import deepnetts.util.Tensor;
import deepnetts.util.Tensors;
import java.io.Serializable;
import javax.visrec.ml.data.DataSet;
import javax.visrec.ml.data.Normalizer;

public final class MaxNormalizer
implements Normalizer<DataSet<MLDataItem>>,
Serializable {
    private Tensor maxInputs;
    private Tensor maxOutputs;

    public MaxNormalizer(DataSet<MLDataItem> dataSet) {
        this.maxInputs = ((MLDataItem)dataSet.get(0)).getInput().copy();
        this.maxOutputs = ((MLDataItem)dataSet.get(0)).getTargetOutput().copy();
        for (MLDataItem item : dataSet) {
            this.maxInputs = Tensors.absMax(item.getInput(), this.maxInputs);
            this.maxOutputs = Tensors.absMax(item.getTargetOutput(), this.maxOutputs);
        }
    }

    public void normalize(DataSet<MLDataItem> dataSet) {
        for (MLDataItem item : dataSet) {
            item.getInput().div(this.maxInputs);
            item.getTargetOutput().div(this.maxOutputs);
        }
    }

    public Tensor getMaxInputs() {
        return this.maxInputs;
    }

    public void setMaxInputs(Tensor maxInputs) {
        this.maxInputs = maxInputs;
    }

    public Tensor getMaxOutputs() {
        return this.maxOutputs;
    }

    public void setMaxOutputs(Tensor maxOutputs) {
        this.maxOutputs = maxOutputs;
    }

    public void deNormalizeOutputs(Tensor outputs) {
        outputs.multiplyElementWise(this.maxOutputs);
    }

    public void deNormalizeInputs(Tensor inputs) {
        inputs.multiplyElementWise(this.maxInputs);
    }
}

