/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.data.norm;

import deepnetts.data.MLDataItem;
import deepnetts.util.Tensor;
import deepnetts.util.Tensors;
import java.io.Serializable;
import javax.visrec.ml.data.DataSet;
import javax.visrec.ml.data.Normalizer;

public class MinMaxNormalizer
implements Normalizer<DataSet<MLDataItem>>,
Serializable {
    private Tensor minInput;
    private Tensor maxInput;
    private Tensor minOutput;
    private Tensor maxOutput;

    public MinMaxNormalizer(DataSet<MLDataItem> dataSet) {
        this.minInput = ((MLDataItem)dataSet.get(0)).getInput().copy();
        this.maxInput = ((MLDataItem)dataSet.get(0)).getInput().copy();
        this.minOutput = ((MLDataItem)dataSet.get(0)).getTargetOutput().copy();
        this.maxOutput = ((MLDataItem)dataSet.get(0)).getTargetOutput().copy();
        for (MLDataItem item : dataSet) {
            this.minInput = Tensors.absMin(item.getInput(), this.minInput);
            this.maxInput = Tensors.absMax(item.getInput(), this.maxInput);
            this.minOutput = Tensors.absMin(item.getTargetOutput(), this.minOutput);
            this.maxOutput = Tensors.absMax(item.getTargetOutput(), this.maxOutput);
        }
    }

    public void normalize(DataSet<MLDataItem> dataSet) {
        Tensor inDivider = this.maxInput.copy();
        this.maxInput.sub(this.minInput);
        Tensor outDivider = this.maxOutput.copy();
        this.maxOutput.sub(this.minOutput);
        for (MLDataItem item : dataSet) {
            item.getInput().sub(this.minInput);
            item.getInput().div(inDivider);
            item.getTargetOutput().sub(this.minInput);
            item.getTargetOutput().sub(outDivider);
        }
    }
}

