/*
 * Decompiled with CFR 0.152.
 */
package deepnetts.data.norm;

import deepnetts.data.MLDataItem;
import java.io.Serializable;
import javax.visrec.ml.data.DataSet;
import javax.visrec.ml.data.Normalizer;

public class RangeNormalizer
implements Normalizer<DataSet<MLDataItem>>,
Serializable {
    private final float min;
    private final float max;

    public RangeNormalizer(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public void normalize(DataSet<MLDataItem> dataSet) {
        float divisor = this.max - this.min;
        for (MLDataItem item : dataSet) {
            item.getInput().sub(this.min);
            item.getInput().div(divisor);
            item.getTargetOutput().sub(this.min);
            item.getTargetOutput().div(divisor);
        }
    }
}

